package org.nuiton.jaxx.config;

/*-
 * #%L
 * JAXX :: Config
 * %%
 * Copyright (C) 2008 - 2016 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.runtime.JAXXBinding;
import org.nuiton.jaxx.runtime.JAXXContext;
import org.nuiton.jaxx.runtime.JAXXObject;
import org.nuiton.jaxx.runtime.JAXXObjectDescriptor;
import org.nuiton.jaxx.runtime.JAXXUtil;
import org.nuiton.jaxx.runtime.SwingUtil;
import org.nuiton.jaxx.runtime.context.DefaultJAXXContext;
import static org.nuiton.i18n.I18n.t;

public class ConfigCallBackUI extends JPanel implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKWUQU8TQRTHp5W2tBWpkKAHDySgNSK7evIAQQVCClYxgoTYi9PdsR2c7oyzb+1y4eDBm1/Ag1cvhu9APJl48cp3MOEj+Ga3tNS0tUIPO5vpe7/5vzf/t99+k5SvyV2pa5YXcJCetUfD0NKBB7zBrI3Hu7ub1T3mwCrzHc0VSE3iXyJJkhWSd9v7PhCrUkaSHZNsQ7JbJHtFNpT0mHcGtFAmOR/2BfPrjAGQ232THd+3t9qRC6EKdOusnqp7nfXz4/3jBFv9nCQkVCg/g2XP/QegU/VImSS5C2SivEffU1tQr4biNPdqWNCY2VsR1Pef0QZ7Rw5IpkzSimqEAZk/V3siXIQKFZDR2Y3n1GPiHpDi3/od6b3hNZRvlhUqxDJ13r5cVypKTwPJ1KnnCqbxqobMLcUJHcTY7MaWo6UQRgWKuGYqDi2/iQ2wzvxlwrPtrILLAF3E3FMykKtdiduaRSnj7ZRkTQKZ7ApaDgD1dpNzgJklRl1T1URXeNSn7mjsXplWo+51x0a7Jui6Qmfc6ucMdKLVcWLHFIkKSekAt4HM9B8C4+MXGBU7eKa/g80xUeCHwwP9tXlyfGrbLIqb/lfWmQlFDyktFfaGG23jsWcD4MJ+StVCBYFM4MVE41scrHyrFYnqUUV0fZYhWSXq15GWyhwffZ96/esSSa6RnJDUXaMmfp1koa6xY1K4oXr4KBJ3uTmKz4KRCSQt6L7EuyVXFl0KdLrKPRdvZSnELhUHd6kt6nDz5MeXTzePTjuVQI2zw2R2upV6RdLcE9xj0Yi3prfnSOeVzwJXdkaz17AmzJpTrdmZiZ7FXvUXHCmChhe7eIezpom8EwZmmYtqMW/zEa8wBG+UuRxoVaBDJxbjiqYp4DeqGgBb6s2dHIKb11LCDvc5ok3Qg/Ojslo2S4zX6nBB0Ah34k9Cn35NDcMAFg7SMQwjD1KKba62L4oy208GEG4g4Q/yhs8DuAcAAA==";
    private static final Log log = LogFactory.getLog(ConfigCallBackUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JTree detectedCallBack;
    protected JButton go;
    protected ConfigCallBackUIHandler handler;
    protected JPanel treeHeader;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JLabel $JLabel0;
    private ConfigCallBackUI $JPanel0;
    private JScrollPane $JScrollPane0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    /**
         * Init the ui.
         */
        public void init() {
            getHandler().init(this);
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public ConfigCallBackUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ConfigCallBackUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ConfigCallBackUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public ConfigCallBackUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ConfigCallBackUI() {
        $initialize();
    }

    public ConfigCallBackUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ConfigCallBackUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public ConfigCallBackUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if ($bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if ($bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if ($bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__go(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().doAction(this);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JTree getDetectedCallBack() {
        return detectedCallBack;
    }

    public JButton getGo() {
        return go;
    }

    public ConfigCallBackUIHandler getHandler() {
        return handler;
    }

    public JPanel getTreeHeader() {
        return treeHeader;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToTreeHeader() {
        treeHeader.add($JLabel0);
    }

    protected void createDetectedCallBack() {
        $objectMap.put("detectedCallBack", detectedCallBack = new JTree());
        
        detectedCallBack.setName("detectedCallBack");
        detectedCallBack.setEditable(false);
        detectedCallBack.setRootVisible(false);
        detectedCallBack.setRowHeight(24);
    }

    protected void createGo() {
        $objectMap.put("go", go = new JButton());
        
        go.setName("go");
        go.setText(t("config.launch.callBack"));
        go.setToolTipText(t("config.launch.callBack.tip"));
        go.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__go"));
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = getContextValue(ConfigCallBackUIHandler.class));
    }

    protected void createTreeHeader() {
        $objectMap.put("treeHeader", treeHeader = new JPanel());
        
        treeHeader.setName("treeHeader");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected void $initialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $JPanel0 = this;
        $initialize_01_createComponents();
        $initialize_02_registerDataBindings();
        $initialize_03_finalizeCreateComponents();
        $initialize_04_applyDataBindings();
        $initialize_05_setProperties();
        $initialize_06_finalizeInitialize();
    }

    protected void $initialize_01_createComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$JPanel0", $JPanel0);
        createHandler();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createDetectedCallBack();
        createGo();
        createTreeHeader();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(t("config.detected.callBack"));
        // inline creation of $JPanel0
        setName("$JPanel0");
        setLayout(new BorderLayout());
    }

    protected void $initialize_02_registerDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // register 0 data bindings
    }

    protected void $initialize_03_finalizeCreateComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $JPanel0
        add($JScrollPane0, BorderLayout.CENTER);
        add(go, BorderLayout.SOUTH);
        add(treeHeader, BorderLayout.EAST);
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(detectedCallBack);
        addChildrenToTreeHeader();
    }

    protected void $initialize_04_applyDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
    }

    protected void $initialize_05_setProperties() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        
        // apply 3 property setters
        $JScrollPane0.setColumnHeaderView(treeHeader);
        go.setIcon(SwingUtil.createActionIcon("config-quit"));
    }

    protected void $initialize_06_finalizeInitialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
    }

}