/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.swing.config;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultSingleSelectionModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.context.JAXXInitialContext;
import jaxx.runtime.swing.config.ConfigCallBackUI;
import jaxx.runtime.swing.config.ConfigCallBackUIHandler;
import jaxx.runtime.swing.config.ConfigCategoryUI;
import jaxx.runtime.swing.config.ConfigUI;
import jaxx.runtime.swing.config.model.CallBackMap;
import jaxx.runtime.swing.config.model.CategoryModel;
import jaxx.runtime.swing.config.model.ConfigUIModel;
import jaxx.runtime.swing.config.model.OptionModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class ConfigUIHandler {
    public static final Log log = LogFactory.getLog(ConfigUIHandler.class);
    public static final String CALLBACKS_WITH_OPTIONS = "callbacksWithOptions";
    public static final String CALLBACKS = "callbacks";
    private final ConfigUI ui;

    public ConfigUIHandler(ConfigUI ui) {
        this.ui = ui;
    }

    public void initUI(String defaultCategory) {
        ConfigUIModel model = this.ui.getModel();
        JTabbedPane categories = this.ui.getCategories();
        categories.setModel(new DefaultSingleSelectionModel(){
            private static final long serialVersionUID = 1L;

            @Override
            public void setSelectedIndex(int index) {
                boolean canContinue;
                boolean bl = canContinue = !this.isSelected() || ConfigUIHandler.this.canQuitCategory();
                if (canContinue) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("new index : " + index));
                    }
                    super.setSelectedIndex(index);
                }
            }
        });
        JButton quitButton = this.ui.getQuit();
        Action quitAction = this.createQuitAction();
        String tip = quitButton.getToolTipText();
        quitButton.setAction(quitAction);
        quitButton.setToolTipText(tip);
        for (CategoryModel categoryModel : model) {
            String category = categoryModel.getCategory();
            String categoryLabel = I18n._((String)categoryModel.getCategoryLabel(), (Object[])new Object[0]);
            ConfigCategoryUI p = new ConfigCategoryUI((JAXXContext)new JAXXInitialContext().add((Object)this.ui).add((Object)categoryModel));
            p.getCategoryLabel().setText(categoryLabel);
            p.setName(category);
            categories.addTab(I18n._((String)category, (Object[])new Object[0]), null, p, categoryLabel);
        }
        model.setCategory(defaultCategory);
        int categoryIndex = model.getCategoryIndex(defaultCategory);
        if (log.isDebugEnabled()) {
            log.debug((Object)("index of default category (" + defaultCategory + ")  : " + categoryIndex));
        }
        categories.setSelectedIndex(categoryIndex);
    }

    public void destroy() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("destroy ui " + this.ui.getName()));
        }
        JAXXUtil.destroy((Component)this.ui);
        this.ui.getModel().destroy();
    }

    public void changeCategory(ChangeEvent e) {
        JPanel p = (JPanel)this.ui.getCategories().getSelectedComponent();
        if (p == null) {
            return;
        }
        this.ui.getModel().setCategory(p.getName());
        this.ui.getCategories().invalidate();
    }

    public void displayUI(Frame parentUI, boolean undecorated) {
        JDialog f = new JDialog(parentUI, true);
        f.setTitle(I18n._((String)"config.title", (Object[])new Object[0]));
        f.add(this.ui);
        if (parentUI != null) {
            f.setIconImage(parentUI.getIconImage());
        }
        this.ui.getModel().setStandalone(parentUI == null);
        f.setDefaultCloseOperation(0);
        f.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ActionEvent myEvent = new ActionEvent(e.getSource(), 1, "quit");
                ConfigUIHandler.this.ui.getQuit().getAction().actionPerformed(myEvent);
            }
        });
        f.setUndecorated(undecorated);
        JRootPane rootPane = f.getRootPane();
        rootPane.setDefaultButton(this.ui.getQuit());
        rootPane.getInputMap(2).put(KeyStroke.getKeyStroke("ESCAPE"), "quit");
        rootPane.getActionMap().put("quit", this.ui.getQuit().getAction());
        f.pack();
        SwingUtil.center((Component)this.ui, (Component)f);
        f.setVisible(true);
    }

    protected Action createQuitAction() {
        JButton button = this.ui.getQuit();
        AbstractAction quitAction = new AbstractAction(button.getText(), button.getIcon()){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!ConfigUIHandler.this.canQuitCategory()) {
                    return;
                }
                final Window parentWindow = ConfigUIHandler.this.ui.getParentContainer(Window.class);
                ConfigUIModel model = ConfigUIHandler.this.ui.getModel();
                if (!model.isSaved() || model.isStandalone()) {
                    ConfigUIHandler.this.closeUI(parentWindow, model);
                    return;
                }
                CallBackMap forSaved = model.getCallBacksForSaved();
                if (forSaved.isEmpty()) {
                    ConfigUIHandler.this.closeUI(parentWindow, model);
                    return;
                }
                forSaved = model.getCallBacksForSaved();
                JAXXInitialContext context = new JAXXInitialContext().add("parent", (Object)parentWindow).add((Object)ConfigUIHandler.this.ui).add(ConfigUIHandler.CALLBACKS_WITH_OPTIONS, (Object)forSaved).add(ConfigUIHandler.CALLBACKS, new ArrayList(forSaved.keySet())).add((Object)new ConfigCallBackUIHandler());
                ConfigCallBackUI lastUI = new ConfigCallBackUI((JAXXContext)context);
                lastUI.init();
                ConfigUIHandler.this.ui.setVisible(false);
                parentWindow.remove(ConfigUIHandler.this.ui);
                parentWindow.add(lastUI);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        parentWindow.validate();
                    }
                });
            }
        };
        return quitAction;
    }

    protected void closeUI(Window parentWindow, ConfigUIModel model) {
        this.destroy();
        parentWindow.dispose();
        Runnable runnable = model.getCloseAction();
        if (runnable != null) {
            log.info((Object)"execute close action");
            runnable.run();
        }
    }

    protected boolean canQuitCategory() {
        boolean canContinue = true;
        ConfigUIModel model = this.ui.getModel();
        CategoryModel categoryModel = model.getCategoryModel();
        String categoryName = I18n._((String)categoryModel.getCategory(), (Object[])new Object[0]);
        if (!categoryModel.isValid()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append(I18n._((String)"config.message.quit.invalid.category", (Object[])new Object[]{categoryName}));
            buffer.append('\n');
            for (OptionModel m : categoryModel.getInvalidOptions()) {
                buffer.append("\n- ").append(m.getKey());
            }
            buffer.append('\n');
            int reponse = this.askUser(I18n._((String)"config.title.need.confirm", (Object[])new Object[0]), buffer.toString(), 0, new Object[]{I18n._((String)"config.choice.continue", (Object[])new Object[0]), I18n._((String)"config.choice.cancel", (Object[])new Object[0])}, 0);
            switch (reponse) {
                case -1: 
                case 1: {
                    canContinue = false;
                    break;
                }
                case 0: {
                    if (!categoryModel.isModified()) break;
                    model.reset();
                }
            }
        } else if (categoryModel.isModified()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append(I18n._((String)"config.message.quit.valid.and.modified.category", (Object[])new Object[]{categoryName})).append('\n');
            for (OptionModel m : categoryModel.getModifiedOptions()) {
                buffer.append("\n- ").append(m.getKey());
            }
            buffer.append('\n');
            int reponse = this.askUser(I18n._((String)"config.title.need.confirm", (Object[])new Object[0]), buffer.toString(), 2, new Object[]{I18n._((String)"config.choice.save", (Object[])new Object[0]), I18n._((String)"config.choice.doNotSave", (Object[])new Object[0]), I18n._((String)"config.choice.cancel", (Object[])new Object[0])}, 0);
            switch (reponse) {
                case -1: 
                case 2: {
                    canContinue = false;
                    break;
                }
                case 0: {
                    model.saveModified();
                    break;
                }
                case 1: {
                    model.reset();
                }
            }
        }
        return canContinue;
    }

    public int askUser(String title, String message, int typeMessage, Object[] options, int defaultOption) {
        int response = JOptionPane.showOptionDialog(this.ui, message, title, -1, typeMessage, null, options, options[defaultOption]);
        return response;
    }
}

