/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.guix.generator;

import java.io.Reader;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.guix.CompilerException;
import org.nuiton.guix.generator.JavaArgument;
import org.nuiton.guix.generator.JavaField;
import org.nuiton.guix.generator.JavaFile;
import org.nuiton.guix.generator.JavaMethod;
import org.nuiton.guix.parser.JavaParser;
import org.nuiton.guix.parser.ParseException;
import org.nuiton.guix.parser.SimpleNode;
import org.nuiton.guix.tags.TagManager;

public class JavaFileParser {
    private static final Log log = LogFactory.getLog(JavaFileParser.class);
    private String className;
    private String packageName = null;
    private String superclassName = "java.lang.Object";
    private List<JavaMethod> methods = new ArrayList<JavaMethod>();
    private List<JavaField> fields = new ArrayList<JavaField>();

    public static JavaFile parseJavaFile(String displayName, Reader src) throws ClassNotFoundException {
        JavaFileParser parser = new JavaFileParser();
        if (log.isDebugEnabled()) {
            log.debug((Object)("starting parsing : " + displayName));
        }
        try {
            parser.doParse(displayName, src);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage());
            throw new RuntimeException(e);
        }
        JavaFile jf = new JavaFile(1, 0, parser.packageName, parser.className.substring(parser.className.lastIndexOf(".") + 1), parser.superclassName, new ArrayList<String>(), null);
        for (JavaMethod jm : parser.methods) {
            if (!Modifier.isPublic(jm.getModifiers())) continue;
            jf.addMethod(jm);
        }
        for (JavaField jfi : parser.fields) {
            if (!Modifier.isPublic(jfi.getModifiers())) continue;
            jf.addField(jfi);
        }
        Class<?> superclass = Class.forName(parser.superclassName);
        for (Method method : superclass.getMethods()) {
            JavaArgument[] jas = new JavaArgument[method.getParameterTypes().length];
            for (int i = 0; i < method.getParameterTypes().length; ++i) {
                jas[i] = new JavaArgument(method.getParameterTypes()[i].getName(), "arg" + i);
            }
            String[] exceptions = new String[method.getExceptionTypes().length];
            for (int i = 0; i < method.getExceptionTypes().length; ++i) {
                exceptions[i] = method.getExceptionTypes()[i].getName();
            }
            jf.addMethod(new JavaMethod(method.getModifiers(), method.getReturnType().getName(), method.getName(), jas, exceptions, "", null));
        }
        for (AccessibleObject accessibleObject : superclass.getFields()) {
            jf.addField(new JavaField(((Field)accessibleObject).getModifiers(), ((Field)accessibleObject).getType().getName(), ((Field)accessibleObject).getName(), null));
        }
        for (AnnotatedElement annotatedElement : superclass.getInterfaces()) {
            jf.getInterfaces().add(((Class)annotatedElement).getName());
        }
        return jf;
    }

    private void doParse(String displayName, Reader src) {
        try {
            JavaParser p = new JavaParser(src);
            p.CompilationUnit();
            SimpleNode node = p.popNode();
            if (node != null) {
                this.scanCompilationUnit(node);
                return;
            }
            throw new CompilerException("Internal error: null node parsing Java file from " + src);
        }
        catch (ParseException e) {
            throw new CompilerException("Error parsing Java source code " + displayName + ": " + e.getMessage());
        }
    }

    private void scanCompilationUnit(SimpleNode node) {
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            SimpleNode child = node.getChild(i);
            int nodeType = child.getId();
            if (nodeType == 2) {
                this.packageName = child.getChild(1).getText().trim();
                continue;
            }
            if (nodeType == 3) {
                String text = child.getText().trim();
                if (text.startsWith("import")) {
                    text = text.substring("import".length()).trim();
                }
                if (!text.endsWith(";")) continue;
                text = text.substring(0, text.length() - 1);
                continue;
            }
            if (nodeType == 5) {
                this.scanCompilationUnit(child);
                continue;
            }
            if (nodeType != 6) continue;
            this.scanClass(child);
        }
    }

    private void scanClass(SimpleNode node) {
        boolean isInterface = node.firstToken.image.equals("interface");
        this.className = node.firstToken.next.image;
        if (this.packageName != null) {
            this.className = this.packageName + "." + this.className;
        }
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            SimpleNode child = node.getChild(i);
            int nodeType = child.getId();
            if (nodeType == 7) {
                if (isInterface) continue;
                assert (child.jjtGetNumChildren() == 1) : "expected ExtendsList to have exactly one child for a non-interface class";
                String rawName = child.getChild(0).getText().trim();
                this.superclassName = TagManager.resolveClassName(rawName);
                if (this.superclassName != null) continue;
                throw new CompilerException("Could not find class: " + rawName);
            }
            if (nodeType != 15) continue;
            this.scanClassNode(child);
        }
    }

    private void scanClassNode(SimpleNode node) {
        int nodeType = node.getId();
        if (nodeType == 22) {
            String returnType = null;
            String name = null;
            ArrayList<JavaArgument> parameterTypes = new ArrayList<JavaArgument>();
            for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
                SimpleNode child = node.getChild(i);
                int type = child.getId();
                if (type == 36) {
                    returnType = TagManager.resolveClassName(child.getText().trim());
                    continue;
                }
                if (type != 23) continue;
                name = child.firstToken.image.trim();
                SimpleNode formalParameters = child.getChild(0);
                assert (formalParameters.getId() == 24);
                for (int j = 0; j < formalParameters.jjtGetNumChildren(); ++j) {
                    SimpleNode parameter = formalParameters.getChild(j);
                    String rawParameterType = parameter.getChild(1).getText().trim().replaceAll("\\.\\.\\.", "[]");
                    String parameterType = TagManager.resolveClassName(rawParameterType);
                    if (parameterType == null) {
                        throw new CompilerException("could not find class '" + rawParameterType + "'");
                    }
                    parameterTypes.add(new JavaArgument(parameterType, "arg" + j));
                }
            }
            this.methods.add(new JavaMethod(1, returnType, name, parameterTypes.toArray(new JavaArgument[parameterTypes.size()]), null, "", null));
        } else if (nodeType != 6 && nodeType != 26) {
            if (nodeType == 17) {
                String[] declarationTokens;
                String name;
                String text;
                String declaration = text = node.getText();
                int equals = text.indexOf("=");
                if (equals != -1) {
                    declaration = declaration.substring(0, equals);
                }
                if ((name = (declarationTokens = (declaration = declaration.trim()).split("\\s"))[declarationTokens.length - 1]).endsWith(";")) {
                    name = name.substring(0, name.length() - 1).trim();
                }
                String className = declarationTokens[declarationTokens.length - 2];
                String type = TagManager.resolveClassName(className);
                this.fields.add(new JavaField(1, type, name, null));
            } else {
                for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
                    SimpleNode child = node.getChild(i);
                    this.scanClassNode(child);
                }
            }
        }
    }
}

