/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.guix.generator;

import java.lang.reflect.Modifier;
import java.util.Comparator;
import org.nuiton.guix.generator.JavaFile;
import org.nuiton.guix.tags.TagHandler;

public class JavaField
implements Comparable<JavaField> {
    private int modifiers;
    private String type;
    private String name;
    private String initializer;
    private String javaDoc;
    private TagHandler tagHandler;
    public static final Comparator<JavaField> COMPARATOR = new Comparator<JavaField>(){

        @Override
        public int compare(JavaField o1, JavaField o2) {
            int result = this.compareStatic(o1, o2);
            if (result != 0) {
                return result;
            }
            result = this.compareDataSource(o1, o2);
            if (result != 0) {
                return result;
            }
            result = this.compareVisibility(o1, o2);
            if (result != 0) {
                return result;
            }
            return o1.name.compareTo(o2.name);
        }

        public int compareStatic(JavaField o1, JavaField o2) {
            if (Modifier.isStatic(o1.modifiers) && !Modifier.isStatic(o2.modifiers)) {
                return -1;
            }
            if (!Modifier.isStatic(o1.modifiers) && Modifier.isStatic(o2.modifiers)) {
                return 1;
            }
            return 0;
        }

        public int compareDataSource(JavaField o1, JavaField o2) {
            if (o1.name.startsWith("$DataSource") && !o2.name.startsWith("$DataSource")) {
                return 1;
            }
            if (!o1.name.startsWith("$DataSource") && o2.name.startsWith("$DataSource")) {
                return -1;
            }
            return 0;
        }

        public int compareVisibility(JavaField o1, JavaField o2) {
            if (!Modifier.isPublic(o1.modifiers) && Modifier.isPublic(o2.modifiers)) {
                return 1;
            }
            if (Modifier.isPublic(o1.modifiers) && !Modifier.isPublic(o2.modifiers)) {
                return -1;
            }
            if (Modifier.isProtected(o1.modifiers) && !Modifier.isProtected(o2.modifiers)) {
                return -1;
            }
            if (!Modifier.isProtected(o1.modifiers) && Modifier.isProtected(o2.modifiers)) {
                return 1;
            }
            if (Modifier.isPrivate(o1.modifiers) && !Modifier.isPrivate(o2.modifiers)) {
                return -1;
            }
            if (!Modifier.isPrivate(o1.modifiers) && Modifier.isPrivate(o2.modifiers)) {
                return 1;
            }
            return 0;
        }
    };

    public JavaField(int modifiers, String type, String name, String javaDoc) {
        this(modifiers, type, name, null, javaDoc, null);
    }

    public JavaField(int modifiers, String type, String name, String javaDoc, TagHandler tagHanlder) {
        this(modifiers, type, name, null, javaDoc, tagHanlder);
    }

    public JavaField(int modifiers, String type, String name, String initializer, String javaDoc, TagHandler tagHandler) {
        this.modifiers = modifiers;
        this.type = type;
        this.name = name;
        this.initializer = initializer;
        this.javaDoc = javaDoc;
        this.tagHandler = tagHandler;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public TagHandler getTagHandler() {
        return this.tagHandler;
    }

    public String toString(String lineSeparator) {
        StringBuffer result = new StringBuffer();
        if (this.javaDoc != null && !this.javaDoc.equals("")) {
            result.append("/**\n * ").append(this.javaDoc.replace("\n", "\n * ")).append("\n */").append(lineSeparator);
        }
        result.append(JavaFile.getModifiersText(this.modifiers));
        result.append(this.type).append(' ').append(this.name);
        if (this.initializer != null) {
            result.append(" = ").append(this.initializer);
        }
        result.append(';').append(lineSeparator);
        return result.toString();
    }

    @Override
    public int compareTo(JavaField o) {
        return COMPARATOR.compare(this, o);
    }

    public static JavaField newField(int modifiers, String returnType, String name) {
        return JavaField.newField(modifiers, returnType, name, null);
    }

    public static JavaField newField(int modifiers, String returnType, String name, String initializer) {
        return new JavaField(modifiers, returnType, name, initializer);
    }
}

