/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.guix;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.guix.CompilerException;
import org.nuiton.guix.parser.SimpleNode;

public class BindingUtils {
    protected static Matcher leftBraceMatcher = Pattern.compile("^(\\{)|[^\\\\](\\{)").matcher("");
    protected static Matcher rightBraceMatcher = Pattern.compile("^(\\})|[^\\\\](\\})").matcher("");
    private static Log log = LogFactory.getLog(BindingUtils.class);

    public static String processDataBindings(String stringValue) {
        int pos = BindingUtils.getNextLeftBrace(stringValue, 0);
        if (pos != -1) {
            StringBuffer expression = new StringBuffer();
            int lastPos = 0;
            while (pos != -1 && pos < stringValue.length()) {
                int pos2;
                if (pos > lastPos) {
                    if (expression.length() > 0) {
                        expression.append(" + ");
                    }
                    expression.append('\"');
                    expression.append(BindingUtils.escapeJavaString(stringValue.substring(lastPos, pos)));
                    expression.append('\"');
                }
                if (expression.length() > 0) {
                    expression.append(" + ");
                }
                if ((pos2 = BindingUtils.getNextRightBrace(stringValue, pos + 1)) == -1) {
                    if (log.isErrorEnabled()) {
                        log.error((Object)("unmatched '{' in expression: " + stringValue));
                    }
                    return "";
                }
                expression.append(stringValue.substring(pos + 1, pos2));
                if (++pos2 < stringValue.length()) {
                    pos = BindingUtils.getNextLeftBrace(stringValue, pos2);
                    lastPos = pos2;
                    continue;
                }
                lastPos = pos = stringValue.length();
            }
            if (lastPos < stringValue.length()) {
                if (expression.length() > 0) {
                    expression.append(" + ");
                }
                expression.append('\"');
                expression.append(BindingUtils.escapeJavaString(stringValue.substring(lastPos)));
                expression.append('\"');
            }
            return expression.toString();
        }
        return null;
    }

    protected static int getNextLeftBrace(String string, int pos) {
        leftBraceMatcher.reset(string);
        return leftBraceMatcher.find(pos) ? Math.max(leftBraceMatcher.start(1), leftBraceMatcher.start(2)) : -1;
    }

    protected static int getNextRightBrace(String string, int pos) {
        leftBraceMatcher.reset(string);
        rightBraceMatcher.reset(string);
        int openCount = 1;
        while (openCount > 0) {
            int rightPos;
            int leftPos = leftBraceMatcher.find(++pos) ? Math.max(leftBraceMatcher.start(1), leftBraceMatcher.start(2)) : -1;
            int n = rightPos = rightBraceMatcher.find(pos) ? Math.max(rightBraceMatcher.start(1), rightBraceMatcher.start(2)) : -1;
            assert (leftPos == -1 || leftPos >= pos);
            assert (rightPos == -1 || rightPos >= pos);
            if (leftPos != -1 && leftPos < rightPos) {
                pos = leftPos;
                ++openCount;
                continue;
            }
            if (rightPos != -1) {
                pos = rightPos;
                --openCount;
                continue;
            }
            openCount = 0;
        }
        return pos;
    }

    protected static String escapeJavaString(String raw) {
        StringBuffer out = new StringBuffer(raw);
        for (int i = 0; i < out.length(); ++i) {
            char c = out.charAt(i);
            if (c == '\\' || c == '\"') {
                out.insert(i, '\\');
                ++i;
                continue;
            }
            if (c == '\n') {
                out.replace(i, i + 1, "\\n");
                ++i;
                continue;
            }
            if (c == '\r') {
                out.replace(i, i + 1, "\\r");
                ++i;
                continue;
            }
            if (c >= ' ' && c <= '\u007f') continue;
            String value = Integer.toString(c, 16);
            while (value.length() < 4) {
                value = "0" + value;
            }
            out.replace(i, i + 1, "\\u" + value);
            i += 5;
        }
        return out.toString();
    }

    public static List<String[]> scanNode(SimpleNode node) throws CompilerException {
        ArrayList<String[]> bindings = new ArrayList<String[]>();
        switch (node.getId()) {
            case 22: {
                break;
            }
            case 17: {
                break;
            }
            default: {
                int count = node.jjtGetNumChildren();
                for (int i = 0; i < count; ++i) {
                    List<String[]> sss = BindingUtils.scanNode(node.getChild(i));
                    if (sss == null) continue;
                    bindings.addAll(sss);
                }
                String[] sArray = BindingUtils.determineNodeType(node);
                if (sArray == null) break;
                bindings.add(sArray);
            }
        }
        return bindings;
    }

    private static String[] determineExpressionType(SimpleNode expression) {
        assert (expression.getId() == 62);
        SimpleNode prefix = expression.getChild(0);
        if (prefix.jjtGetNumChildren() == 1) {
            int type = prefix.getChild(0).getId();
            if (type == 66 || type == 39) {
                return null;
            }
            if (type == 37 && expression.jjtGetNumChildren() == 1) {
                return prefix.getChild(0).getText().trim().split("\\.");
            }
        }
        if (expression.jjtGetNumChildren() == 1) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        int index = 0;
        for (int i = 0; i < expression.jjtGetNumChildren(); ++i) {
            String token = expression.getChild(i).getText().trim();
            if (token.startsWith("(")) {
                result.set(index - 1, (String)result.get(index - 1) + token);
                continue;
            }
            int nbToken = 0;
            while (token.startsWith(".")) {
                token = token.substring(1);
            }
            String[] splitedToken = token.split("\\.");
            for (int j = splitedToken.length - 1; j >= 0; --j) {
                if (Character.isUpperCase(splitedToken[j].charAt(0))) {
                    StringBuffer stringBuffer = new StringBuffer();
                    for (int k = 0; k < j; ++k) {
                        stringBuffer.append(splitedToken[k]).append(".");
                    }
                    result.add(index, stringBuffer.append(splitedToken[j]).toString());
                    ++nbToken;
                    break;
                }
                result.add(index, splitedToken[j]);
                ++nbToken;
            }
            index += nbToken;
        }
        return result.toArray(new String[result.size()]);
    }

    private static String[] determineNodeType(SimpleNode node) {
        String[] result = null;
        switch (node.getId()) {
            case 62: {
                result = BindingUtils.determineExpressionType(node);
                return result;
            }
        }
        return null;
    }
}

