/* *##% 
 * EUGene :: Maven plugin
 * Copyright (C) 2006 - 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * ##%*/
package org.nuiton.eugene.plugin;

import org.nuiton.plugin.PluginHelper;
import org.nuiton.plugin.PluginIOContext;

import java.io.File;

/**
 * Extract zipped XMI files from zargo archive.
 * 
 * @author ruchaud
 * @version $Revision: 835 $
 *
 * Last update: $Date: 2010-03-04 19:03:17 +0100 (jeu., 04 mars 2010) $
 * by : $Author: tchemit $
 * 
 * @goal zargo2xmi
 */
public class Zargo2Xmi extends EugeneAbstractMojo {

    public static final String[] ZARGO_FILE_FILTER =
            new String[]{"**/*.zargo", "**/*.zuml"};
    public static final String[] XMI_FILE_FILTER =
            new String[]{"*.xmi", "**/*.xmi"};
    /**
     * Les entrées-sorties du plugin.
     *
     * <p/>
     * 
     * En entrée on demande des répertoires où chercher les fichiers zargo a
     * convertir.
     * <p/>
     * En sortie on demande le répertoire ou extraire les xmi et copier les
     * resources.
     * <p/>
     * Par défaut on a les valeurs suivantes :
     * </p>
     * <pre>
     * &lt;zargoResources&gt;
     * </p>
     *   &lt;input&gt;src/main/xmi&lt;/input&gt;
     * </p>
     *   &lt;output&gt;target/generated-sources/xmi&lt;/ouput&gt;
     * </p>
     * &lt;/zargoResources&gt;
     * </pre>
     * </p>
     *
     * Note: si {@link #testPhase} est activée, les valeurs par défaut sont :
     * </p>
     * <pre>
     * &lt;zargoResources&gt;
     * </p>
     *   &lt;input&gt;src/test/xmi&lt;/input&gt;
     * </p>
     *   &lt;output&gt;target/generated-sources/test-xmi&lt;/ouput&gt;
     * </p>
     * &lt;zargoResources&gt;
     * </pre>
     *
     * @parameter
     * @since 1.0.0-rc-8
     */
    protected PluginIOContext zargoResources;

    @Override
    public void doAction() throws Exception {
        getLog().info("Extract zipped XMI files from zargo archive and " +
                      "copy resources");

        getLog().info("Extract zipped XMI files");
        PluginHelper.expandFiles(zargoResources, ZARGO_FILE_FILTER, null,
                                 XMI_FILE_FILTER, overwrite);

        getLog().info("Copy resources");
        PluginHelper.copyFiles(zargoResources, null, ZARGO_FILE_FILTER,
                               overwrite);
    }

    @Override
    protected PluginIOContext getResources() {
        return zargoResources;
    }

    @Override
    protected PluginIOContext initResources() {

        File defaultIn = getFileFromBasedir("src", "main", "xmi");
        File defaultOut = getFileFromBasedir("target", "generated-sources",
                                             "xmi");

        File defaultTestIn = getFileFromBasedir("src", "test", "xmi");
        File defaultTestOut = getFileFromBasedir("target", "generated-sources",
                                                 "test-xmi");

        zargoResources = initResources(
                defaultIn,
                defaultOut,
                defaultTestIn,
                defaultTestOut
        );

        return zargoResources;
    }
}
