/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugene.plugin;

import java.io.File;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import org.apache.maven.doxia.siterenderer.Renderer;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.plexus.i18n.I18N;
import org.nuiton.eugene.models.extension.tagvalue.provider.TagValueMetadatasProvider;
import org.nuiton.eugene.plugin.renderer.TagValuesReportRenderer;

@Mojo(name="tag-values-report", requiresReports=true, requiresDependencyResolution=ResolutionScope.COMPILE)
public class TagValuesReport
extends AbstractMavenReport {
    @Parameter(property="eugene.providerName", defaultValue="${project.artifactId}", required=true)
    protected String providerName;
    @Parameter(property="config.outputDirectory", defaultValue="${project.reporting.outputDirectory}", required=true)
    protected File outputDirectory;
    @Parameter(property="config.outputEncoding", defaultValue="${project.reporting.outputEncoding}", required=true)
    protected String outputEncoding;
    @Parameter(property="config.skip")
    protected boolean skip;
    @Parameter(property="eugene.javaDocDestDir", defaultValue="apidocs")
    protected String javaDocDestDir;
    @Parameter(property="eugene.jxrDestDir", defaultValue="xref")
    protected String jxrDestDir;
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject project;
    @Component
    protected Renderer siteRenderer;
    @Component
    protected I18N i18n;
    @Component(role=TagValueMetadatasProvider.class)
    protected Map<String, TagValueMetadatasProvider> providers;

    public String getDescription(Locale locale) {
        return this.i18n.getString(this.getOutputName(), locale, "report.description");
    }

    public String getName(Locale locale) {
        return this.i18n.getString(this.getOutputName(), locale, "report.title");
    }

    public String getCategoryName() {
        return "Project Reports";
    }

    public boolean canGenerateReport() {
        return !this.skip;
    }

    protected Renderer getSiteRenderer() {
        return this.siteRenderer;
    }

    protected String getOutputDirectory() {
        return this.outputDirectory.getAbsolutePath();
    }

    protected MavenProject getProject() {
        return this.project;
    }

    protected void executeReport(Locale locale) throws MavenReportException {
        Collection<TagValueMetadatasProvider> providers = this.providers.values();
        TagValuesReportRenderer reportRenderer = new TagValuesReportRenderer(this.getSink(), this.i18n, locale, this.getOutputName(), this.javaDocDestDir, this.jxrDestDir, providers);
        reportRenderer.render();
    }

    public String getOutputName() {
        return "tag-values-report";
    }
}

