/*
 * Decompiled with CFR 0.152.
 */
package org.nibblesec.tools;

import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.commons.configuration.reloading.FileChangedReloadingStrategy;
import org.apache.commons.configuration.reloading.ReloadingStrategy;

public class SerialKiller
extends ObjectInputStream {
    private final XMLConfiguration config;
    private final FileChangedReloadingStrategy reloadStrategy;
    private static final Logger LOGGER = Logger.getLogger(SerialKiller.class.getName());
    private static Handler fileHandler;
    private static String logFile;
    private static boolean logEnabled;
    private static String[] blacklist;
    private static String[] whitelist;
    private static boolean profiling;

    public SerialKiller(InputStream inputStream, String string) throws IOException, ConfigurationException {
        super(inputStream);
        this.config = new XMLConfiguration(string);
        this.reloadStrategy = new FileChangedReloadingStrategy();
        this.reloadStrategy.setRefreshDelay(this.config.getLong("refresh", 6000L));
        this.config.setReloadingStrategy((ReloadingStrategy)this.reloadStrategy);
        blacklist = this.config.getStringArray("blacklist.regexp");
        whitelist = this.config.getStringArray("whitelist.regexp");
        profiling = this.config.getBoolean("mode.profiling", false);
        logEnabled = this.config.getBoolean("logging.enabled", true);
        if (logEnabled) {
            logFile = this.config.getString("logging.logfile", "/tmp/serialkiller.log");
            fileHandler = new FileHandler(logFile, true);
            LOGGER.addHandler(fileHandler);
            LOGGER.setLevel(Level.ALL);
        }
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
        Object object;
        for (String string : blacklist) {
            Pattern object2 = Pattern.compile(string);
            object = object2.matcher(objectStreamClass.getName());
            if (!((Matcher)object).find()) continue;
            if (profiling) {
                LOGGER.log(Level.FINE, "Blacklist match: ''{0}''", objectStreamClass.getName());
                continue;
            }
            LOGGER.log(Level.SEVERE, "Blocked by blacklist ''{0}''. Match found for ''{1}''", new Object[]{string, objectStreamClass.getName()});
            throw new InvalidClassException("Class blocked by SK: '" + objectStreamClass.getName() + "'");
        }
        boolean bl = false;
        for (String string : whitelist) {
            object = Pattern.compile(string);
            Matcher matcher = ((Pattern)object).matcher(objectStreamClass.getName());
            if (!matcher.find()) continue;
            bl = true;
            if (!profiling) continue;
            LOGGER.log(Level.FINE, "Whitelist match: ''{0}''", objectStreamClass.getName());
        }
        if (!bl && !profiling) {
            LOGGER.log(Level.SEVERE, "Blocked by whitelist. No match found for ''{0}''", objectStreamClass.getName());
            throw new InvalidClassException("Class blocked by SK: '" + objectStreamClass.getName() + "'");
        }
        return super.resolveClass(objectStreamClass);
    }
}

