/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.messaging;

import java.io.IOException;
import java.util.Map;
import org.neo4j.driver.internal.messaging.Message;
import org.neo4j.driver.internal.messaging.MessageHandler;
import org.neo4j.driver.v1.Value;

public class RunMessage
implements Message {
    private final String statement;
    private final Map<String, Value> parameters;

    public RunMessage(String statement, Map<String, Value> parameters) {
        this.statement = statement;
        this.parameters = parameters;
    }

    @Override
    public void dispatch(MessageHandler handler) throws IOException {
        handler.handleRunMessage(this.statement, this.parameters);
    }

    public String toString() {
        return String.format("RUN \"%s\" %s", this.statement, this.parameters);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RunMessage that = (RunMessage)o;
        return !(this.parameters == null ? that.parameters != null : !this.parameters.equals(that.parameters)) && !(this.statement == null ? that.statement != null : !this.statement.equals(that.statement));
    }

    public int hashCode() {
        int result = this.statement != null ? this.statement.hashCode() : 0;
        result = 31 * result + (this.parameters != null ? this.parameters.hashCode() : 0);
        return result;
    }
}

