/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring.parsers.specific;

import java.util.HashMap;
import java.util.Map;
import org.mule.api.context.notification.ComponentMessageNotificationListener;
import org.mule.api.context.notification.ConnectionNotificationListener;
import org.mule.api.context.notification.CustomNotificationListener;
import org.mule.api.context.notification.EndpointMessageNotificationListener;
import org.mule.api.context.notification.ExceptionNotificationListener;
import org.mule.api.context.notification.ManagementNotificationListener;
import org.mule.api.context.notification.MessageNotificationListener;
import org.mule.api.context.notification.ModelNotificationListener;
import org.mule.api.context.notification.MuleContextNotificationListener;
import org.mule.api.context.notification.RegistryNotificationListener;
import org.mule.api.context.notification.RoutingNotificationListener;
import org.mule.api.context.notification.SecurityNotificationListener;
import org.mule.api.context.notification.ServiceNotificationListener;
import org.mule.api.context.notification.TransactionNotificationListener;
import org.mule.config.spring.parsers.PreProcessor;
import org.mule.config.spring.parsers.assembly.configuration.PropertyConfiguration;
import org.mule.config.spring.parsers.collection.ChildMapEntryDefinitionParser;
import org.mule.config.spring.parsers.processors.CheckExclusiveAttributes;
import org.mule.config.spring.parsers.processors.CheckRequiredAttributes;
import org.mule.context.notification.ComponentMessageNotification;
import org.mule.context.notification.ConnectionNotification;
import org.mule.context.notification.CustomNotification;
import org.mule.context.notification.EndpointMessageNotification;
import org.mule.context.notification.ExceptionNotification;
import org.mule.context.notification.ManagementNotification;
import org.mule.context.notification.ModelNotification;
import org.mule.context.notification.MuleContextNotification;
import org.mule.context.notification.RegistryNotification;
import org.mule.context.notification.RoutingNotification;
import org.mule.context.notification.SecurityNotification;
import org.mule.context.notification.ServiceNotification;
import org.mule.context.notification.TransactionNotification;
import org.w3c.dom.Element;

public class NotificationDefinitionParser
extends ChildMapEntryDefinitionParser {
    public static final Map EVENT_MAP;
    public static final Map INTERFACE_MAP;
    public static final String INTERFACE = "interface";
    public static final String INTERFACE_CLASS = "interface-class";
    public static final String EVENT = "event";
    public static final String EVENT_CLASS = "event-class";
    public static final String[][] INTERFACE_ATTRIBUTES;
    public static final String[][] EVENT_ATTRIBUTES;
    public static final String[][] ALL_ATTRIBUTES;

    public NotificationDefinitionParser() {
        super("interfaceToType", INTERFACE_CLASS, EVENT_CLASS);
        this.addMapping(EVENT, EVENT_MAP);
        this.addAlias(EVENT, "value");
        this.addMapping(INTERFACE, INTERFACE_MAP);
        this.addAlias(INTERFACE, "key");
        this.registerPreProcessor(new CheckExclusiveAttributes(INTERFACE_ATTRIBUTES));
        this.registerPreProcessor(new CheckExclusiveAttributes(EVENT_ATTRIBUTES));
        this.registerPreProcessor(new CheckRequiredAttributes(INTERFACE_ATTRIBUTES));
        this.registerPreProcessor(new CheckRequiredAttributes(EVENT_ATTRIBUTES));
        this.registerPreProcessor(new SetDefaults());
    }

    static {
        INTERFACE_ATTRIBUTES = new String[][]{{INTERFACE}, {INTERFACE_CLASS}};
        EVENT_ATTRIBUTES = new String[][]{{EVENT}, {EVENT_CLASS}};
        ALL_ATTRIBUTES = new String[][]{{EVENT}, {EVENT_CLASS}, {INTERFACE}, {INTERFACE_CLASS}};
        EVENT_MAP = new HashMap();
        EVENT_MAP.put("CONTEXT", MuleContextNotification.class.getName());
        EVENT_MAP.put("MODEL", ModelNotification.class.getName());
        EVENT_MAP.put("SERVICE", ServiceNotification.class.getName());
        EVENT_MAP.put("SECURITY", SecurityNotification.class.getName());
        EVENT_MAP.put("ENDPOINT-MESSAGE", EndpointMessageNotification.class.getName());
        EVENT_MAP.put("COMPONENT-MESSAGE", ComponentMessageNotification.class.getName());
        EVENT_MAP.put("MANAGEMENT", ManagementNotification.class.getName());
        EVENT_MAP.put("CONNECTION", ConnectionNotification.class.getName());
        EVENT_MAP.put("REGISTRY", RegistryNotification.class.getName());
        EVENT_MAP.put("CUSTOM", CustomNotification.class.getName());
        EVENT_MAP.put("EXCEPTION", ExceptionNotification.class.getName());
        EVENT_MAP.put("TRANSACTION", TransactionNotification.class.getName());
        EVENT_MAP.put("ROUTING", RoutingNotification.class.getName());
        INTERFACE_MAP = new HashMap();
        INTERFACE_MAP.put("CONTEXT", MuleContextNotificationListener.class.getName());
        INTERFACE_MAP.put("MODEL", ModelNotificationListener.class.getName());
        INTERFACE_MAP.put("SERVICE", ServiceNotificationListener.class.getName());
        INTERFACE_MAP.put("SECURITY", SecurityNotificationListener.class.getName());
        INTERFACE_MAP.put("MANAGEMENT", ManagementNotificationListener.class.getName());
        INTERFACE_MAP.put("CONNECTION", ConnectionNotificationListener.class.getName());
        INTERFACE_MAP.put("REGISTRY", RegistryNotificationListener.class.getName());
        INTERFACE_MAP.put("CUSTOM", CustomNotificationListener.class.getName());
        INTERFACE_MAP.put("MESSAGE", MessageNotificationListener.class.getName());
        INTERFACE_MAP.put("ENDPOINT-MESSAGE", EndpointMessageNotificationListener.class.getName());
        INTERFACE_MAP.put("COMPONENT-MESSAGE", ComponentMessageNotificationListener.class.getName());
        INTERFACE_MAP.put("EXCEPTION", ExceptionNotificationListener.class.getName());
        INTERFACE_MAP.put("TRANSACTION", TransactionNotificationListener.class.getName());
        INTERFACE_MAP.put("ROUTING", RoutingNotificationListener.class.getName());
        EVENT_MAP.put("MESSAGE", EndpointMessageNotification.class.getName());
    }

    private class SetDefaults
    implements PreProcessor {
        private SetDefaults() {
        }

        public void preProcess(PropertyConfiguration config, Element element) {
            this.copy(element, NotificationDefinitionParser.INTERFACE, NotificationDefinitionParser.EVENT, NotificationDefinitionParser.EVENT_CLASS);
            this.copy(element, NotificationDefinitionParser.EVENT, NotificationDefinitionParser.INTERFACE, NotificationDefinitionParser.INTERFACE_CLASS);
        }

        private void copy(Element element, String from, String to, String blocker) {
            if (element.hasAttribute(from) && !element.hasAttribute(to) && !element.hasAttribute(blocker)) {
                element.setAttribute(to, element.getAttribute(from));
            }
        }
    }
}

