/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.processors;

import java.lang.reflect.Field;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.api.annotations.expressions.Lookup;
import org.mule.api.context.MuleContextAware;
import org.mule.api.expression.RequiredValueException;
import org.mule.api.registry.InjectProcessor;
import org.mule.config.i18n.AnnotationsMessages;
import org.mule.util.StringUtils;

public class LookupInjectionProcessor
implements InjectProcessor,
MuleContextAware {
    protected final transient Log logger = LogFactory.getLog(LookupInjectionProcessor.class);
    private MuleContext context;

    public LookupInjectionProcessor() {
    }

    public LookupInjectionProcessor(MuleContext context) {
        this.context = context;
    }

    public void setMuleContext(MuleContext context) {
        this.context = context;
    }

    public Object process(Object object) {
        Field[] fields;
        try {
            fields = object.getClass().getDeclaredFields();
        }
        catch (NoClassDefFoundError e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.warn((Object)e.toString());
            }
            return object;
        }
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            if (!field.isAnnotationPresent(Lookup.class)) continue;
            try {
                field.setAccessible(true);
                String name = field.getAnnotation(Lookup.class).value();
                boolean optional = field.getAnnotation(Lookup.class).optional();
                Object value = StringUtils.isBlank((String)name) ? this.context.getRegistry().lookupObject(field.getType()) : this.context.getRegistry().lookupObject(name);
                if (value == null && !optional) {
                    throw new RequiredValueException(AnnotationsMessages.lookupNotFoundInRegistry(field.getType(), name, object.getClass()));
                }
                field.set(object, value);
                continue;
            }
            catch (RequiredValueException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RequiredValueException(AnnotationsMessages.lookupFailedSeePreviousException(object), (Throwable)e);
            }
        }
        return object;
    }
}

