/*
 * Decompiled with CFR 0.152.
 */
package org.bson.codecs.pojo;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.bson.assertions.Assertions;
import org.bson.codecs.configuration.CodecConfigurationException;
import org.bson.codecs.pojo.ClassModelBuilder;
import org.bson.codecs.pojo.CreatorExecutable;
import org.bson.codecs.pojo.InstanceCreatorFactoryImpl;
import org.bson.codecs.pojo.PropertyAccessorImpl;
import org.bson.codecs.pojo.PropertyMetadata;
import org.bson.codecs.pojo.PropertyModel;
import org.bson.codecs.pojo.PropertyModelBuilder;
import org.bson.codecs.pojo.PropertyModelSerializationImpl;
import org.bson.codecs.pojo.TypeData;
import org.bson.codecs.pojo.TypeParameterMap;

final class PojoBuilderHelper {
    private static final String IS_PREFIX = "is";
    private static final String GET_PREFIX = "get";
    private static final String SET_PREFIX = "set";

    static <T> void configureClassModelBuilder(ClassModelBuilder<T> classModelBuilder, Class<T> clazz) {
        classModelBuilder.type(Assertions.notNull("clazz", clazz));
        ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        TreeSet<String> propertyNames = new TreeSet<String>();
        HashMap<String, TypeParameterMap> propertyTypeParameterMap = new HashMap<String, TypeParameterMap>();
        Class<T> currentClass = clazz;
        String declaringClassName = clazz.getSimpleName();
        TypeData<T> parentClassTypeData = null;
        HashMap propertyNameMap = new HashMap();
        while (currentClass.getSuperclass() != null) {
            annotations.addAll(Arrays.asList(currentClass.getDeclaredAnnotations()));
            ArrayList genericTypeNames = new ArrayList();
            for (AnnotatedElement annotatedElement : currentClass.getTypeParameters()) {
                genericTypeNames.add(annotatedElement.getName());
            }
            for (AnnotatedElement annotatedElement : currentClass.getDeclaredMethods()) {
                String methodName = ((Method)annotatedElement).getName();
                if (!PojoBuilderHelper.isPropertyMethod((Method)annotatedElement) || !Modifier.isPublic(((Method)annotatedElement).getModifiers())) continue;
                String propertyName = PojoBuilderHelper.toPropertyName(methodName);
                propertyNames.add(propertyName);
                PropertyMetadata<?> propertyMetadata = PojoBuilderHelper.getOrCreateProperty(propertyName, declaringClassName, propertyNameMap, PojoBuilderHelper.getTypeData((Method)annotatedElement), propertyTypeParameterMap, parentClassTypeData, genericTypeNames, PojoBuilderHelper.getGenericType((Method)annotatedElement));
                if (PojoBuilderHelper.isGetter((Method)annotatedElement) && propertyMetadata.getGetter() == null) {
                    propertyMetadata.setGetter((Method)annotatedElement);
                    for (Annotation annotation : ((Method)annotatedElement).getDeclaredAnnotations()) {
                        propertyMetadata.addReadAnnotation(annotation);
                    }
                    continue;
                }
                if (propertyMetadata.getSetter() != null) continue;
                propertyMetadata.setSetter((Method)annotatedElement);
                for (Annotation annotation : ((Method)annotatedElement).getDeclaredAnnotations()) {
                    propertyMetadata.addWriteAnnotation(annotation);
                }
            }
            for (AnnotatedElement annotatedElement : currentClass.getDeclaredFields()) {
                propertyNames.add(((Field)annotatedElement).getName());
                PropertyMetadata<?> propertyMetadata = PojoBuilderHelper.getOrCreateProperty(((Field)annotatedElement).getName(), declaringClassName, propertyNameMap, PojoBuilderHelper.getTypeData(((Field)annotatedElement).getGenericType(), ((Field)annotatedElement).getType()), propertyTypeParameterMap, parentClassTypeData, genericTypeNames, ((Field)annotatedElement).getGenericType());
                if (propertyMetadata.getField() != null) continue;
                propertyMetadata.field((Field)annotatedElement);
                for (Annotation annotation : ((Field)annotatedElement).getDeclaredAnnotations()) {
                    propertyMetadata.addReadAnnotation(annotation);
                    propertyMetadata.addWriteAnnotation(annotation);
                }
            }
            parentClassTypeData = PojoBuilderHelper.getTypeData(currentClass.getGenericSuperclass(), currentClass);
            currentClass = currentClass.getSuperclass();
        }
        for (String propertyName : propertyNames) {
            PropertyMetadata propertyMetadata = (PropertyMetadata)propertyNameMap.get(propertyName);
            if (!propertyMetadata.isSerializable() && !propertyMetadata.isDeserializable()) continue;
            classModelBuilder.addProperty(PojoBuilderHelper.createPropertyModelBuilder(propertyMetadata));
        }
        Collections.reverse(annotations);
        classModelBuilder.annotations(annotations);
        classModelBuilder.propertyNameToTypeParameterMap(propertyTypeParameterMap);
        AnnotatedElement noArgsConstructor = null;
        for (AnnotatedElement annotatedElement : clazz.getDeclaredConstructors()) {
            if (((Constructor)annotatedElement).getParameterTypes().length != 0 || !Modifier.isPublic(((Constructor)annotatedElement).getModifiers()) && !Modifier.isProtected(((Constructor)annotatedElement).getModifiers())) continue;
            noArgsConstructor = annotatedElement;
            ((Constructor)noArgsConstructor).setAccessible(true);
        }
        classModelBuilder.instanceCreatorFactory(new InstanceCreatorFactoryImpl<T>(new CreatorExecutable<T>(clazz, noArgsConstructor)));
    }

    private static <T, S> PropertyMetadata<T> getOrCreateProperty(String propertyName, String declaringClassName, Map<String, PropertyMetadata<?>> propertyNameMap, TypeData<T> typeData, Map<String, TypeParameterMap> propertyTypeParameterMap, TypeData<S> parentClassTypeData, List<String> genericTypeNames, Type genericType) {
        PropertyMetadata<Object> propertyMetadata = propertyNameMap.get(propertyName);
        if (propertyMetadata == null) {
            propertyMetadata = new PropertyMetadata<T>(propertyName, declaringClassName, typeData);
            propertyNameMap.put(propertyName, propertyMetadata);
        }
        if (!propertyMetadata.getTypeData().equals(typeData)) {
            throw new CodecConfigurationException(String.format("Property '%s' in %s, has differing data types: %s and %s", propertyName, declaringClassName, propertyMetadata.getTypeData(), typeData));
        }
        TypeParameterMap typeParameterMap = PojoBuilderHelper.getTypeParameterMap(genericTypeNames, genericType);
        propertyTypeParameterMap.put(propertyMetadata.getName(), typeParameterMap);
        propertyMetadata.typeParameterInfo(typeParameterMap, parentClassTypeData);
        return propertyMetadata;
    }

    private static <T> TypeData<T> getTypeData(Type genericType, Class<T> clazz) {
        TypeData.Builder<T> builder = TypeData.builder(clazz);
        if (genericType instanceof ParameterizedType) {
            ParameterizedType pType = (ParameterizedType)genericType;
            for (Type argType : pType.getActualTypeArguments()) {
                PojoBuilderHelper.getNestedTypeData(builder, argType);
            }
        }
        return builder.build();
    }

    private static <T> void getNestedTypeData(TypeData.Builder<T> builder, Type type) {
        if (type instanceof ParameterizedType) {
            ParameterizedType pType = (ParameterizedType)type;
            TypeData.Builder paramBuilder = TypeData.builder((Class)pType.getRawType());
            for (Type argType : pType.getActualTypeArguments()) {
                PojoBuilderHelper.getNestedTypeData(paramBuilder, argType);
            }
            builder.addTypeParameter(paramBuilder.build());
        } else if (type instanceof TypeVariable) {
            builder.addTypeParameter(TypeData.builder(Object.class).build());
        } else if (type instanceof Class) {
            builder.addTypeParameter(TypeData.builder((Class)type).build());
        }
    }

    private static TypeData<?> getTypeData(Method method) {
        if (PojoBuilderHelper.isGetter(method)) {
            return PojoBuilderHelper.getTypeData(method.getGenericReturnType(), method.getReturnType());
        }
        return PojoBuilderHelper.getTypeData(method.getGenericParameterTypes()[0], method.getParameterTypes()[0]);
    }

    private static Type getGenericType(Method method) {
        return PojoBuilderHelper.isGetter(method) ? method.getGenericReturnType() : method.getGenericParameterTypes()[0];
    }

    static <T> PropertyModelBuilder<T> createPropertyModelBuilder(PropertyMetadata<T> propertyMetadata) {
        PropertyModelBuilder propertyModelBuilder = PropertyModel.builder().propertyName(propertyMetadata.getName()).readName(propertyMetadata.getName()).writeName(propertyMetadata.getName()).typeData(propertyMetadata.getTypeData()).readAnnotations(propertyMetadata.getReadAnnotations()).writeAnnotations(propertyMetadata.getWriteAnnotations()).propertySerialization(new PropertyModelSerializationImpl()).propertyAccessor(new PropertyAccessorImpl<T>(propertyMetadata));
        if (propertyMetadata.getTypeParameters() != null) {
            PojoBuilderHelper.specializePropertyModelBuilder(propertyModelBuilder, propertyMetadata);
        }
        return propertyModelBuilder;
    }

    private static TypeParameterMap getTypeParameterMap(List<String> genericTypeNames, Type propertyType) {
        int classParamIndex = genericTypeNames.indexOf(propertyType.toString());
        TypeParameterMap.Builder builder = TypeParameterMap.builder();
        if (classParamIndex != -1) {
            builder.addIndex(classParamIndex);
        } else if (propertyType instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)propertyType;
            for (int i = 0; i < pt.getActualTypeArguments().length; ++i) {
                classParamIndex = genericTypeNames.indexOf(pt.getActualTypeArguments()[i].toString());
                if (classParamIndex == -1) continue;
                builder.addIndex(i, classParamIndex);
            }
        }
        return builder.build();
    }

    private static <V> void specializePropertyModelBuilder(PropertyModelBuilder<V> propertyModelBuilder, PropertyMetadata<V> propertyMetadata) {
        if (propertyMetadata.getTypeParameterMap().hasTypeParameters() && !propertyMetadata.getTypeParameters().isEmpty()) {
            TypeData<Object> specializedFieldType = propertyModelBuilder.getTypeData();
            Map<Integer, Integer> fieldToClassParamIndexMap = propertyMetadata.getTypeParameterMap().getPropertyToClassParamIndexMap();
            Integer classTypeParamRepresentsWholeField = fieldToClassParamIndexMap.get(-1);
            if (classTypeParamRepresentsWholeField != null) {
                specializedFieldType = propertyMetadata.getTypeParameters().get(classTypeParamRepresentsWholeField);
            } else {
                TypeData.Builder<V> builder = TypeData.builder(propertyModelBuilder.getTypeData().getType());
                ArrayList typeParameters = new ArrayList(propertyModelBuilder.getTypeData().getTypeParameters());
                for (int i = 0; i < typeParameters.size(); ++i) {
                    for (Map.Entry<Integer, Integer> mapping : fieldToClassParamIndexMap.entrySet()) {
                        if (!mapping.getKey().equals(i)) continue;
                        typeParameters.set(i, propertyMetadata.getTypeParameters().get(mapping.getValue()));
                    }
                }
                builder.addTypeParameters(typeParameters);
                specializedFieldType = builder.build();
            }
            propertyModelBuilder.typeData(specializedFieldType);
        }
    }

    static <V> V stateNotNull(String property, V value) {
        if (value == null) {
            throw new IllegalStateException(String.format("%s cannot be null", property));
        }
        return value;
    }

    static boolean isSetter(Method method) {
        if (method.getName().startsWith(SET_PREFIX) && method.getName().length() > SET_PREFIX.length() && method.getParameterTypes().length == 1) {
            return Character.isUpperCase(method.getName().charAt(SET_PREFIX.length()));
        }
        return false;
    }

    static boolean isGetter(Method method) {
        if (method.getParameterTypes().length > 0) {
            return false;
        }
        if (method.getName().startsWith(GET_PREFIX) && method.getName().length() > GET_PREFIX.length()) {
            return Character.isUpperCase(method.getName().charAt(GET_PREFIX.length()));
        }
        if (method.getName().startsWith(IS_PREFIX) && method.getName().length() > IS_PREFIX.length()) {
            return Character.isUpperCase(method.getName().charAt(IS_PREFIX.length()));
        }
        return false;
    }

    static boolean isPropertyMethod(Method method) {
        return PojoBuilderHelper.isGetter(method) || PojoBuilderHelper.isSetter(method);
    }

    static String toPropertyName(String name) {
        String propertyName = name.substring(name.startsWith(IS_PREFIX) ? 2 : 3, name.length());
        char[] chars = propertyName.toCharArray();
        chars[0] = Character.toLowerCase(chars[0]);
        return new String(chars);
    }

    private PojoBuilderHelper() {
    }
}

