/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.gem;

import java.util.HashMap;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.mapstruct.ap.internal.gem.ElementGem;
import org.mapstruct.ap.shaded.org.mapstruct.tools.gem.Gem;
import org.mapstruct.ap.shaded.org.mapstruct.tools.gem.GemValue;

public class AnnotateWithGem
implements Gem {
    private final GemValue<TypeMirror> value;
    private final GemValue<List<ElementGem>> elements;
    private final boolean isValid;
    private final AnnotationMirror mirror;

    private AnnotateWithGem(BuilderImpl builder) {
        this.value = builder.value;
        this.elements = builder.elements;
        this.isValid = this.value != null && this.value.isValid() && this.elements != null && this.elements.isValid();
        this.mirror = builder.mirror;
    }

    public GemValue<TypeMirror> value() {
        return this.value;
    }

    public GemValue<List<ElementGem>> elements() {
        return this.elements;
    }

    @Override
    public AnnotationMirror mirror() {
        return this.mirror;
    }

    @Override
    public boolean isValid() {
        return this.isValid;
    }

    public static AnnotateWithGem instanceOn(Element element) {
        return AnnotateWithGem.build(element, new BuilderImpl());
    }

    public static AnnotateWithGem instanceOn(AnnotationMirror mirror) {
        return AnnotateWithGem.build(mirror, new BuilderImpl());
    }

    public static <T> T build(Element element, Builder<T> builder) {
        AnnotationMirror mirror = element.getAnnotationMirrors().stream().filter(a -> "org.mapstruct.AnnotateWith".contentEquals(((TypeElement)a.getAnnotationType().asElement()).getQualifiedName())).findAny().orElse(null);
        return AnnotateWithGem.build(mirror, builder);
    }

    public static <T> T build(AnnotationMirror mirror, Builder<T> builder) {
        if (mirror == null || builder == null) {
            return null;
        }
        List<ExecutableElement> enclosed = ElementFilter.methodsIn(mirror.getAnnotationType().asElement().getEnclosedElements());
        HashMap defaultValues = new HashMap(enclosed.size());
        enclosed.forEach(e -> defaultValues.put(e.getSimpleName().toString(), e.getDefaultValue()));
        HashMap values = new HashMap(enclosed.size());
        mirror.getElementValues().entrySet().forEach(e -> values.put(((ExecutableElement)e.getKey()).getSimpleName().toString(), (AnnotationValue)e.getValue()));
        for (String methodName : defaultValues.keySet()) {
            if ("value".equals(methodName)) {
                builder.setValue(GemValue.create((AnnotationValue)values.get(methodName), (AnnotationValue)defaultValues.get(methodName), TypeMirror.class));
                continue;
            }
            if (!"elements".equals(methodName)) continue;
            builder.setElements(GemValue.createArray((AnnotationValue)values.get(methodName), (AnnotationValue)defaultValues.get(methodName), ElementGem::instanceOn));
        }
        builder.setMirror(mirror);
        return builder.build();
    }

    private static class BuilderImpl
    implements Builder<AnnotateWithGem> {
        private GemValue<TypeMirror> value;
        private GemValue<List<ElementGem>> elements;
        private AnnotationMirror mirror;

        private BuilderImpl() {
        }

        @Override
        public Builder setValue(GemValue<TypeMirror> value) {
            this.value = value;
            return this;
        }

        @Override
        public Builder setElements(GemValue<List<ElementGem>> elements) {
            this.elements = elements;
            return this;
        }

        @Override
        public Builder setMirror(AnnotationMirror mirror) {
            this.mirror = mirror;
            return this;
        }

        @Override
        public AnnotateWithGem build() {
            return new AnnotateWithGem(this);
        }
    }

    public static interface Builder<T> {
        public Builder setValue(GemValue<TypeMirror> var1);

        public Builder setElements(GemValue<List<ElementGem>> var1);

        public Builder setMirror(AnnotationMirror var1);

        public T build();
    }
}

