/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.aws.s3;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.services.s3.model.Bucket;
import com.amazonaws.services.s3.model.ListObjectsRequest;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.amazonaws.services.s3.transfer.TransferManager;
import com.amazonaws.services.s3.transfer.Upload;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.kuali.common.aws.s3.AccountSummary;
import org.kuali.common.aws.s3.AccountSummaryContext;
import org.kuali.common.aws.s3.BaseCase;
import org.kuali.common.aws.s3.BucketComparator;
import org.kuali.common.aws.s3.BucketDisplay;
import org.kuali.common.aws.s3.BucketPrefixSummary;
import org.kuali.common.aws.s3.BucketSummary;
import org.kuali.common.aws.s3.S3PrefixContext;
import org.kuali.common.aws.s3.SimpleFormatter;
import org.kuali.common.aws.s3.Size;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3Utils {
    private static final Logger log = LoggerFactory.getLogger(S3Utils.class);
    public static final long MULTI_PART_UPLOAD_THRESHOLD = Size.MB.getValue() * 100L;
    private static final String PREFIX = "prefix";
    private static final String COUNT = "count";
    private static final String SIZE = "size";
    SimpleFormatter formatter = new SimpleFormatter();
    private static S3Utils instance;

    public static synchronized S3Utils getInstance() {
        if (instance == null) {
            instance = new S3Utils();
        }
        return instance;
    }

    protected S3Utils() {
    }

    public AWSCredentials getCredentials(String accessKey, String secretKey) {
        return new BasicAWSCredentials(accessKey, secretKey);
    }

    public AmazonS3Client getClient(String accessKey, String secretKey) {
        AWSCredentials credentials = this.getCredentials(accessKey, secretKey);
        return new AmazonS3Client(credentials);
    }

    public void upload(File file, PutObjectRequest request, AmazonS3Client client, TransferManager manager) {
        if (file.length() < MULTI_PART_UPLOAD_THRESHOLD) {
            client.putObject(request);
        } else {
            log.debug("Blocking multi-part upload: " + file.getAbsolutePath());
            this.blockingMultiPartUpload(request, manager);
        }
    }

    public void blockingMultiPartUpload(PutObjectRequest request, TransferManager manager) {
        Upload upload = manager.upload(request);
        try {
            upload.waitForCompletion();
        }
        catch (Exception e) {
            throw new AmazonS3Exception("Unexpected error uploading file", e);
        }
    }

    public ListObjectsRequest getListObjectsRequest(String bucketName, String prefix, String delimiter, Integer maxKeys) {
        ListObjectsRequest request = new ListObjectsRequest();
        request.setBucketName(bucketName);
        request.setDelimiter(delimiter);
        request.setPrefix(prefix);
        request.setMaxKeys(maxKeys);
        return request;
    }

    public ListObjectsRequest getListObjectsRequest(String bucketName, String prefix, String delimiter) {
        return this.getListObjectsRequest(bucketName, prefix, delimiter, null);
    }

    public ListObjectsRequest getListObjectsRequest(String bucketName, String prefix) {
        return this.getListObjectsRequest(bucketName, prefix, null);
    }

    public ListObjectsRequest getListObjectsRequest(String bucketName) {
        return this.getListObjectsRequest(bucketName, null);
    }

    public List<DefaultMutableTreeNode> getLeaves(DefaultMutableTreeNode node) {
        Enumeration<TreeNode> e = node.breadthFirstEnumeration();
        ArrayList<DefaultMutableTreeNode> leaves = new ArrayList<DefaultMutableTreeNode>();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode element = (DefaultMutableTreeNode)e.nextElement();
            if (!element.isLeaf()) continue;
            leaves.add(element);
        }
        return leaves;
    }

    public DefaultMutableTreeNode buildTree(List<String> prefixes, String delimiter) {
        HashMap<String, DefaultMutableTreeNode> map = new HashMap<String, DefaultMutableTreeNode>();
        for (String prefix : prefixes) {
            BucketPrefixSummary summary = new BucketPrefixSummary(prefix);
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(summary);
            if (prefix != null) {
                String parentKey = this.getParentPrefix(prefix, delimiter);
                DefaultMutableTreeNode parent = (DefaultMutableTreeNode)map.get(parentKey);
                parent.add(node);
            }
            map.put(prefix, node);
        }
        return (DefaultMutableTreeNode)map.get(null);
    }

    public String getParentPrefix(String prefix, String delimiter) {
        String[] tokens = StringUtils.split((String)prefix, (String)delimiter);
        if (tokens.length == 1) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < tokens.length - 1; ++i) {
            sb.append(tokens[i] + delimiter);
        }
        return sb.toString();
    }

    public void buildPrefixList(AmazonS3Client client, String bucketName, List<String> prefixes, String prefix, String delimiter, BaseCase baseCase) {
        log.info(prefix);
        prefixes.add(prefix);
        ListObjectsRequest request = this.getListObjectsRequest(bucketName, prefix, delimiter);
        ObjectListing listing = client.listObjects(request);
        List commonPrefixes = listing.getCommonPrefixes();
        for (String commonPrefix : commonPrefixes) {
            if (baseCase.isBaseCase(commonPrefix)) continue;
            this.buildPrefixList(client, bucketName, prefixes, commonPrefix, delimiter, baseCase);
        }
    }

    public void summarize(AmazonS3Client client, String bucketName, DefaultMutableTreeNode node) {
        List<DefaultMutableTreeNode> leaves = this.getLeaves(node);
        for (DefaultMutableTreeNode leaf : leaves) {
            BucketPrefixSummary summary = (BucketPrefixSummary)leaf.getUserObject();
            this.summarize(client, bucketName, summary);
        }
        this.fillInSummaries(node);
    }

    public List<BucketPrefixSummary> getBucketSummaryLeafs(DefaultMutableTreeNode node) {
        List<DefaultMutableTreeNode> leaves = this.getLeaves(node);
        ArrayList<BucketPrefixSummary> summaries = new ArrayList<BucketPrefixSummary>();
        for (DefaultMutableTreeNode leaf : leaves) {
            BucketPrefixSummary summary = (BucketPrefixSummary)leaf.getUserObject();
            summaries.add(summary);
        }
        Collections.sort(summaries);
        return summaries;
    }

    public void fillInSummaries(DefaultMutableTreeNode node) {
        BucketPrefixSummary summary = (BucketPrefixSummary)node.getUserObject();
        List<DefaultMutableTreeNode> children = this.getChildren(node);
        for (DefaultMutableTreeNode child : children) {
            this.fillInSummaries(child);
            BucketPrefixSummary childSummary = (BucketPrefixSummary)child.getUserObject();
            long count = childSummary.getCount();
            long size = childSummary.getSize();
            summary.setCount(summary.getCount() + count);
            summary.setSize(summary.getSize() + size);
        }
    }

    public List<DefaultMutableTreeNode> getChildren(DefaultMutableTreeNode node) {
        Enumeration<TreeNode> e = node.children();
        ArrayList<DefaultMutableTreeNode> children = new ArrayList<DefaultMutableTreeNode>();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)e.nextElement();
            children.add(child);
        }
        return children;
    }

    public AccountSummary getAccountSummary(AccountSummaryContext context) {
        AmazonS3Client client = this.getClient(context.getAccessKey(), context.getSecretKey());
        List<Bucket> buckets = this.getBuckets(client, context.getIncludes(), context.getExcludes());
        List<BucketSummary> summaries = this.getBucketSummaries(client, buckets);
        AccountSummary summary = new AccountSummary();
        summary.setAccessKey(context.getAccessKey());
        summary.setBucketSummaries(summaries);
        this.updateAccountSummary(summary);
        return summary;
    }

    public AccountSummary getAccountSummary(String accessKey, String secretKey, List<String> includes, List<String> excludes) {
        AccountSummaryContext context = new AccountSummaryContext();
        context.setAccessKey(accessKey);
        context.setSecretKey(secretKey);
        context.setIncludes(includes);
        context.setExcludes(excludes);
        return this.getAccountSummary(context);
    }

    public List<BucketSummary> getBucketSummaries(AmazonS3Client client, List<Bucket> buckets) {
        ArrayList<BucketSummary> summaries = new ArrayList<BucketSummary>();
        int count = 1;
        for (Bucket bucket : buckets) {
            long start = System.currentTimeMillis();
            System.out.print("[INFO] " + count + " - " + bucket.getName() + " - ");
            BucketSummary summary = this.getBucketSummary(client, bucket);
            System.out.println(this.formatter.getTime(System.currentTimeMillis() - start));
            summaries.add(summary);
            ++count;
        }
        return summaries;
    }

    public BucketSummary getBucketSummary(AmazonS3Client client, Bucket bucket) {
        BucketSummary summary = new BucketSummary();
        summary.setBucket(bucket);
        ListObjectsRequest request = this.getListObjectsRequest(bucket.getName());
        ObjectListing current = client.listObjects(request);
        this.updateBucketSummary(summary, current.getObjectSummaries());
        while (current.isTruncated()) {
            current = client.listNextBatchOfObjects(current);
            this.updateBucketSummary(summary, current.getObjectSummaries());
        }
        log.debug("Completed summary for '{}'", (Object)bucket.getName());
        return summary;
    }

    public BucketPrefixSummary summarize(AmazonS3Client client, String bucketName) {
        BucketPrefixSummary summary = new BucketPrefixSummary();
        ListObjectsRequest request = this.getListObjectsRequest(bucketName);
        ObjectListing current = client.listObjects(request);
        this.summarize(summary, current.getObjectSummaries());
        while (current.isTruncated()) {
            current = client.listNextBatchOfObjects(current);
            this.summarize(summary, current.getObjectSummaries());
        }
        log.debug("Completed summary for '{}'", (Object)bucketName);
        return summary;
    }

    public BucketPrefixSummary summarize(AmazonS3Client client, String bucketName, BucketPrefixSummary summary) {
        ListObjectsRequest request = this.getListObjectsRequest(bucketName, summary.getPrefix());
        ObjectListing current = client.listObjects(request);
        this.summarize(summary, current.getObjectSummaries());
        while (current.isTruncated()) {
            current = client.listNextBatchOfObjects(current);
            this.summarize(summary, current.getObjectSummaries());
        }
        log.debug("Completed summary for prefix '{}'", (Object)summary.getPrefix());
        return summary;
    }

    public void updateBucketSummary(BucketSummary summary, List<S3ObjectSummary> summaries) {
        for (S3ObjectSummary element : summaries) {
            summary.setSize(summary.getSize() + element.getSize());
            summary.setCount(summary.getCount() + 1L);
        }
    }

    public void summarize(BucketPrefixSummary summary, List<S3ObjectSummary> summaries) {
        for (S3ObjectSummary element : summaries) {
            summary.setSize(summary.getSize() + element.getSize());
            summary.setCount(summary.getCount() + 1L);
            if (!log.isDebugEnabled()) continue;
            log.debug(summary.getCount() + " - " + element.getKey() + " - " + this.formatter.getSize(element.getSize()));
        }
        if (log.isDebugEnabled()) {
            String prefix = summary.getPrefix();
            long count = summary.getCount();
            long bytes = summary.getSize();
            log.debug(this.rpad(prefix, 40) + " Total Count: " + this.lpad(count + "", 3) + " Total Size: " + this.lpad(this.formatter.getSize(bytes), 9));
        }
    }

    public String toString(DefaultMutableTreeNode node) {
        return this.toString(node, null, null);
    }

    public String toString(DefaultMutableTreeNode node, Size size) {
        return this.toString(node, size, null);
    }

    public String toString(DefaultMutableTreeNode node, Comparator<BucketPrefixSummary> comparator) {
        return this.toString(node, null, comparator);
    }

    public List<BucketPrefixSummary> getBucketSummaryList(DefaultMutableTreeNode node, Comparator<BucketPrefixSummary> comparator) {
        ArrayList<BucketPrefixSummary> list = new ArrayList<BucketPrefixSummary>();
        Enumeration<TreeNode> e = node.breadthFirstEnumeration();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode element = (DefaultMutableTreeNode)e.nextElement();
            BucketPrefixSummary summary = (BucketPrefixSummary)element.getUserObject();
            list.add(summary);
        }
        if (comparator == null) {
            Collections.sort(list);
        } else {
            Collections.sort(list, comparator);
        }
        return list;
    }

    public List<BucketDisplay> getBucketDisplayList(List<BucketPrefixSummary> summaries, Size size) {
        ArrayList<BucketDisplay> list = new ArrayList<BucketDisplay>();
        for (BucketPrefixSummary summary : summaries) {
            BucketDisplay display = new BucketDisplay();
            display.setPrefix(summary.getPrefix() == null ? "/" : summary.getPrefix());
            display.setCount(summary.getCount());
            display.setSize(this.formatter.getSize(summary.getSize(), size));
            list.add(display);
        }
        return list;
    }

    public List<S3PrefixContext> getS3PrefixContexts(AmazonS3Client client, String bucketName, List<BucketPrefixSummary> summaries) {
        ArrayList<S3PrefixContext> contexts = new ArrayList<S3PrefixContext>();
        for (BucketPrefixSummary summary : summaries) {
            S3PrefixContext context = new S3PrefixContext();
            context.setClient(client);
            context.setBucketName(bucketName);
            context.setSummary(summary);
            contexts.add(context);
        }
        return contexts;
    }

    public String toString(DefaultMutableTreeNode node, Size size, Comparator<BucketPrefixSummary> comparator) {
        List<BucketPrefixSummary> bucketSummaryList = this.getBucketSummaryList(node, comparator);
        List<BucketDisplay> list = this.getBucketDisplayList(bucketSummaryList, size);
        int maxPrefixLength = PREFIX.length();
        int maxCountLength = COUNT.length();
        int maxSizeLength = SIZE.length();
        for (BucketDisplay display : list) {
            maxPrefixLength = Math.max(maxPrefixLength, display.getPrefix().length());
            maxCountLength = Math.max(maxCountLength, (display.getCount() + "").length());
            maxSizeLength = Math.max(maxSizeLength, display.getSize().length());
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.rpad(PREFIX, maxPrefixLength) + " " + this.lpad(COUNT, maxCountLength) + " " + this.lpad(SIZE, maxSizeLength) + "\n");
        for (BucketDisplay display : list) {
            sb.append(this.rpad(display.getPrefix(), maxPrefixLength));
            sb.append(" ");
            sb.append(this.lpad(display.getCount() + "", maxCountLength));
            sb.append(" ");
            sb.append(this.lpad(display.getSize(), maxSizeLength));
            sb.append("\n");
        }
        return sb.toString();
    }

    public int[] getColumnLengths(List<String> columns, List<String[]> rows) {
        int[] columnLengths = new int[columns.size()];
        for (int i = 0; i < columnLengths.length; ++i) {
            columnLengths[i] = columns.get(i).length();
        }
        for (String[] row : rows) {
            for (int i = 0; i < columns.size(); ++i) {
                columnLengths[i] = Math.max(columnLengths[i], row[i].length());
            }
        }
        return columnLengths;
    }

    public List<String> toList(String csv) {
        if (StringUtils.isBlank((String)csv)) {
            return new ArrayList<String>();
        }
        String[] tokens = StringUtils.split((String)csv, (String)",");
        return this.toList(tokens);
    }

    public List<String> toList(String[] tokens) {
        ArrayList<String> list = new ArrayList<String>();
        for (String token : tokens) {
            list.add(token);
        }
        return list;
    }

    public void updateAccountSummary(AccountSummary summary) {
        long size = 0L;
        long files = 0L;
        for (BucketSummary bucketSummary : summary.getBucketSummaries()) {
            size += bucketSummary.getSize();
            files += bucketSummary.getCount();
        }
        summary.setSize(size);
        summary.setCount(files);
    }

    public String toString(AccountSummary summary) {
        List<String> columns = this.getBucketSummaryColumns();
        List<String[]> rows = this.getRows(summary.getBucketSummaries());
        rows.add(new String[]{"", "", ""});
        rows.add(new String[]{"Totals", this.formatter.getCount(summary.getCount()), this.formatter.getSize(summary.getSize())});
        return this.toString(columns, rows);
    }

    public String toCSV(AccountSummary summary) {
        return this.toCSV(summary, true);
    }

    public String toCSV(AccountSummary summary, boolean printColumnHeaders) {
        List<String> columns = this.getAccountSummaryCSVColumns();
        List<String[]> rows = this.getAccountSummaryCSVRows(summary.getBucketSummaries(), new Date());
        return this.toCSV(columns, rows, printColumnHeaders);
    }

    public String toCSV(List<String> columns, List<String[]> rows, boolean printColumnHeaders) {
        int i;
        StringBuilder sb = new StringBuilder();
        if (printColumnHeaders) {
            for (i = 0; i < columns.size(); ++i) {
                if (i != 0) {
                    sb.append(",");
                }
                String column = columns.get(i);
                sb.append(column);
            }
            sb.append("\n");
        }
        for (i = 0; i < rows.size(); ++i) {
            String[] row = rows.get(i);
            for (int j = 0; j < row.length; ++j) {
                if (j != 0) {
                    sb.append(",");
                }
                sb.append(row[j]);
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public String toString(List<String> columns, List<String[]> rows) {
        int i;
        int[] columnLengths = this.getColumnLengths(columns, rows);
        StringBuilder sb = new StringBuilder();
        for (i = 0; i < columnLengths.length; ++i) {
            if (i != 0) {
                sb.append("  ");
            }
            String name = columns.get(i);
            sb.append(this.lpad(name, columnLengths[i]));
        }
        sb.append("\n");
        for (i = 0; i < rows.size(); ++i) {
            String[] row = rows.get(i);
            for (int j = 0; j < row.length; ++j) {
                if (j != 0) {
                    sb.append("  ");
                }
                int columnLength = columnLengths[j];
                sb.append(this.lpad(row[j], columnLength));
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public List<Bucket> getBuckets(AmazonS3Client client, List<String> includes, List<String> excludes) {
        List buckets = client.listBuckets();
        int originalSize = buckets.size();
        log.info("Located " + buckets.size() + " total buckets");
        Iterator itr = buckets.iterator();
        while (itr.hasNext()) {
            Bucket bucket = (Bucket)itr.next();
            String bucketName = bucket.getName();
            if (this.include(bucketName, includes, excludes)) continue;
            log.info("Excluding '" + bucket.getName() + "'");
            itr.remove();
        }
        if (originalSize != buckets.size()) {
            log.info("Trimmed bucket list contains " + buckets.size() + " buckets");
        }
        Collections.sort(buckets, new BucketComparator());
        return buckets;
    }

    public boolean include(String bucketName, List<String> includes, List<String> excludes) {
        if (excludes.contains(bucketName)) {
            return false;
        }
        return includes.size() == 0 || includes.contains(bucketName);
    }

    public String lpad(String s, int size) {
        return StringUtils.leftPad((String)s, (int)size, (String)" ");
    }

    public String rpad(String s, int size) {
        return StringUtils.rightPad((String)s, (int)size, (String)" ");
    }

    public List<String> getBucketSummaryColumns() {
        ArrayList<String> columns = new ArrayList<String>();
        columns.add("Bucket");
        columns.add("Files");
        columns.add("Size");
        return columns;
    }

    public List<String[]> getRows(List<BucketSummary> summaries) {
        ArrayList<String[]> rows = new ArrayList<String[]>();
        for (BucketSummary summary : summaries) {
            rows.add(this.getRow(summary));
        }
        return rows;
    }

    protected String[] getRow(BucketSummary summary) {
        String[] row = new String[]{summary.getBucket().getName(), this.formatter.getCount(summary.getCount()), this.formatter.getSize(summary.getSize())};
        return row;
    }

    public List<String> getAccountSummaryCSVColumns() {
        ArrayList<String> columns = new ArrayList<String>();
        columns.add("bucket");
        columns.add("files");
        columns.add("bytes");
        columns.add("date");
        return columns;
    }

    protected List<String[]> getAccountSummaryCSVRows(List<BucketSummary> summaries, Date date) {
        ArrayList<String[]> rows = new ArrayList<String[]>();
        for (BucketSummary summary : summaries) {
            String[] row = this.getAccountSummaryCSVRow(summary, date);
            rows.add(row);
        }
        return rows;
    }

    protected String[] getAccountSummaryCSVRow(BucketSummary summary, Date date) {
        String[] row = new String[]{summary.getBucket().getName(), summary.getCount() + "", summary.getSize() + "", this.formatter.getDate(date)};
        return row;
    }

    public void write(File file, String data, boolean append) {
        try {
            FileUtils.write((File)file, (CharSequence)data, (boolean)append);
        }
        catch (IOException e) {
            throw new AmazonS3Exception("Error writing to file", (Exception)e);
        }
    }
}

