/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services;

import java.util.HashMap;
import java.util.Map;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.keycloak.Config;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.provider.Provider;
import org.keycloak.provider.ProviderFactory;
import org.keycloak.provider.Spi;
import org.keycloak.services.DefaultKeycloakSessionFactory;

public class DefaultKeycloakSessionFactoryTest {
    private DummyConfigurationProvider config;
    private DummySpi spi;

    @Before
    public void before() {
        this.config = new DummyConfigurationProvider();
        Config.init((Config.ConfigProvider)this.config);
    }

    @After
    public void after() {
        Config.init((Config.ConfigProvider)new Config.SystemPropertiesConfigProvider());
    }

    @Test
    public void defaultProviderFromConfigTest() {
        HashMap<String, DummyProviderFactory> map = new HashMap<String, DummyProviderFactory>(Map.of("two", new DummyProviderFactory("two", 2), "one", new DummyProviderFactory("one", 0), "three", new DummyProviderFactory("three", 3)));
        this.spi = new DummySpi();
        this.config.defaultProvider = "one";
        Assert.assertEquals((Object)"one", (Object)DefaultKeycloakSessionFactory.resolveDefaultProvider(map, (Spi)this.spi));
        this.config.defaultProvider = null;
        Assert.assertEquals((Object)"three", (Object)DefaultKeycloakSessionFactory.resolveDefaultProvider(map, (Spi)this.spi));
        map.values().stream().forEach(p -> {
            ((DummyProviderFactory)p).order = 0;
        });
        Assert.assertNull((Object)DefaultKeycloakSessionFactory.resolveDefaultProvider(map, (Spi)this.spi));
        map.put("default", new DummyProviderFactory("default", 0));
        Assert.assertEquals((Object)"default", (Object)DefaultKeycloakSessionFactory.resolveDefaultProvider(map, (Spi)this.spi));
        map.remove("default");
        map.remove("two");
        map.remove("three");
        Assert.assertEquals((Object)"one", (Object)DefaultKeycloakSessionFactory.resolveDefaultProvider(map, (Spi)this.spi));
        this.config.defaultProvider = "nosuch";
        try {
            DefaultKeycloakSessionFactory.resolveDefaultProvider(map, (Spi)this.spi);
            Assert.fail((String)"Expected exception");
        }
        catch (RuntimeException e) {
            Assert.assertEquals((Object)"Failed to find provider nosuch for dummy", (Object)e.getMessage());
        }
    }

    private class DummyConfigurationProvider
    implements Config.ConfigProvider {
        String defaultProvider;

        private DummyConfigurationProvider() {
        }

        public String getProvider(String spi) {
            return null;
        }

        public String getDefaultProvider(String spi) {
            return this.defaultProvider;
        }

        public Config.Scope scope(String ... scope) {
            return null;
        }
    }

    private class DummyProviderFactory
    implements ProviderFactory {
        private String id;
        private int order;

        public DummyProviderFactory(String id, int order) {
            this.id = id;
            this.order = order;
        }

        public Provider create(KeycloakSession session) {
            return null;
        }

        public void init(Config.Scope config) {
        }

        public void postInit(KeycloakSessionFactory factory) {
        }

        public void close() {
        }

        public String getId() {
            return this.id;
        }

        public int order() {
            return this.order;
        }
    }

    private class DummySpi
    implements Spi {
        private DummySpi() {
        }

        public boolean isInternal() {
            return false;
        }

        public String getName() {
            return "dummy";
        }

        public Class<? extends Provider> getProviderClass() {
            return null;
        }

        public Class<? extends ProviderFactory> getProviderFactoryClass() {
            return null;
        }
    }
}

