/*
 * Decompiled with CFR 0.152.
 */
package netx.jnlp.services;

import java.io.IOException;
import java.net.URL;
import javax.jnlp.BasicService;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import netx.jnlp.JARDesc;
import netx.jnlp.JNLPFile;
import netx.jnlp.Launcher;
import netx.jnlp.runtime.ApplicationInstance;
import netx.jnlp.runtime.JNLPRuntime;
import netx.jnlp.util.PropertiesFile;

class XBasicService
implements BasicService {
    private String command = null;
    private boolean initialized = false;

    protected XBasicService() {
    }

    public URL getCodeBase() {
        ApplicationInstance app = JNLPRuntime.getApplication();
        if (app != null) {
            JNLPFile file = app.getJNLPFile();
            if (file.getCodeBase() != null) {
                return file.getCodeBase();
            }
            JARDesc mainJar = file.getResources().getMainJAR();
            if (mainJar != null) {
                return mainJar.getLocation();
            }
        }
        return null;
    }

    public boolean isOffline() {
        return false;
    }

    public boolean isWebBrowserSupported() {
        this.initialize();
        return this.command != null;
    }

    public boolean showDocument(URL url) {
        block6: {
            this.initialize();
            if (url.toString().endsWith(".jnlp")) {
                try {
                    new Launcher().launchExternal(url);
                    return true;
                }
                catch (Exception ex) {
                    return false;
                }
            }
            if (this.command != null) {
                try {
                    Runtime.getRuntime().exec(this.command + url.toString());
                    return true;
                }
                catch (IOException ex) {
                    if (!JNLPRuntime.isDebug()) break block6;
                    ex.printStackTrace();
                }
            }
        }
        return false;
    }

    private void initialize() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        if (this.isWindows()) {
            this.command = "rundll32 url.dll,FileProtocolHandler ";
        } else {
            PropertiesFile props = JNLPRuntime.getProperties();
            this.command = props.getProperty("browser.command");
            if (this.command == null) {
                this.command = this.promptForCommand(null);
                if (this.command != null) {
                    props.setProperty("browser.command", this.command);
                    props.store();
                }
            }
        }
    }

    private boolean isWindows() {
        String os = System.getProperty("os.name");
        return os != null && os.startsWith("Windows");
    }

    private String promptForCommand(String cmd) {
        return JOptionPane.showInputDialog(new JPanel(), "Browser Location:", "Specify Browser Location", -1);
    }
}

