/*
 * Decompiled with CFR 0.152.
 */
package org.jtwig.reflection.model.java;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jtwig.reflection.model.java.JavaClass;
import org.jtwig.reflection.model.java.JavaClassFactory;

public class JavaClassManager {
    private static JavaClassManager INSTANCE = new JavaClassManager(new JavaClassFactory(), new ConcurrentHashMap<Class, JavaClass>());
    private final JavaClassFactory javaClassFactory;
    private final ConcurrentMap<Class, JavaClass> javaClassMap;

    public static JavaClassManager classManager() {
        return INSTANCE;
    }

    public JavaClassManager(JavaClassFactory javaClassFactory, ConcurrentMap<Class, JavaClass> javaClassMap) {
        this.javaClassFactory = javaClassFactory;
        this.javaClassMap = javaClassMap;
    }

    public JavaClass metadata(Class type) {
        if (!this.javaClassMap.containsKey(type)) {
            this.javaClassMap.put(type, this.javaClassFactory.create(type));
        }
        return (JavaClass)this.javaClassMap.get(type);
    }
}

