/*
 * Decompiled with CFR 0.152.
 */
package org.jtwig.reflection.extractor;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import org.jtwig.reflection.model.bean.BeanMethod;
import org.jtwig.reflection.model.java.JavaMethod;

public class BeanMethodExtractor {
    public Collection<BeanMethod> extract(Object bean, Predicate<JavaMethod> predicate) {
        ArrayList<BeanMethod> result = new ArrayList<BeanMethod>();
        for (Method method : bean.getClass().getMethods()) {
            JavaMethod javaMethod = new JavaMethod(method);
            if (!predicate.apply((Object)javaMethod)) continue;
            result.add(new BeanMethod(bean, javaMethod));
        }
        return result;
    }

    public Collection<BeanMethod> extract(Object bean) {
        return this.extract(bean, (Predicate<JavaMethod>)Predicates.alwaysTrue());
    }
}

