/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.meta.duckdb;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.jooq.DataType;
import org.jooq.Field;
import org.jooq.Name;
import org.jooq.Record1;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.jooq.impl.DefaultDataType;
import org.jooq.impl.ParserException;
import org.jooq.impl.QOM;
import org.jooq.meta.AbstractUDTDefinition;
import org.jooq.meta.AttributeDefinition;
import org.jooq.meta.DefaultAttributeDefinition;
import org.jooq.meta.DefaultDataTypeDefinition;
import org.jooq.meta.RoutineDefinition;
import org.jooq.meta.SchemaDefinition;
import org.jooq.meta.duckdb.system.main.Tables;
import org.jooq.tools.JooqLogger;

public class DuckDBUDTDefinition
extends AbstractUDTDefinition {
    private static final JooqLogger log = JooqLogger.getLogger(DuckDBUDTDefinition.class);

    public DuckDBUDTDefinition(SchemaDefinition schema, String name, String comment) {
        super(schema, null, name, comment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List<AttributeDefinition> getElements0() throws SQLException {
        ArrayList<AttributeDefinition> result = new ArrayList<AttributeDefinition>();
        String currentSchema = (String)this.create().fetchValue((SelectField)DSL.currentSchema());
        Name name = DSL.unquotedName((String)("dummy_" + Math.abs(new Random().nextInt())));
        try {
            this.create().setSchema(this.getSchema().getName()).execute();
            this.create().createTable(name).column("dummy", (DataType)new DefaultDataType(null, Object.class, this.getName())).execute();
            String struct = (String)((Record1)this.create().select(Tables.DUCKDB_COLUMNS.DATA_TYPE).from((TableLike)Tables.DUCKDB_COLUMNS).where(Tables.DUCKDB_COLUMNS.TABLE_NAME.eq((Object)name.last())).fetchSingle()).value1();
            try {
                QOM.CreateType ct = (QOM.CreateType)this.create().parser().parseQuery("create type t as " + struct);
                int i = 1;
                for (Field a : ct.$attributes()) {
                    SchemaDefinition typeSchema = null;
                    Name qualifiedName = a.getDataType().getQualifiedName();
                    if (qualifiedName.qualified()) {
                        typeSchema = this.getDatabase().getSchema(qualifiedName.qualifier().last());
                    }
                    DefaultDataTypeDefinition type = new DefaultDataTypeDefinition(this.getDatabase(), typeSchema == null ? this.getSchema() : typeSchema, qualifiedName.last(), a.getDataType().length(), a.getDataType().precision(), a.getDataType().scale(), a.getDataType().nullable(), a.getDataType().defaulted() ? a.getDataType().default_().toString() : null, DSL.name((String[])new String[]{qualifiedName.qualified() ? qualifiedName.qualifier().last() : null, qualifiedName.last()}));
                    result.add(new DefaultAttributeDefinition(this, a.getName(), i++, type));
                }
            }
            catch (ParserException e) {
                log.info((Object)"Error while parsing UDT. DuckDB UDTs cannot be reverse engineered reliably very easily without sufficient information in the information_schema. Please upvote this feature request to improve support for nested UDTs, etc: https://github.com/duckdb/duckdb/discussions/8832", (Throwable)e);
            }
        }
        finally {
            this.create().setSchema(currentSchema).execute();
            this.create().dropTableIfExists(name).execute();
        }
        return result;
    }

    @Override
    protected List<RoutineDefinition> getRoutines0() {
        return Collections.emptyList();
    }
}

