/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.util.pngj.chunks;

import jogamp.opengl.util.pngj.ImageInfo;
import jogamp.opengl.util.pngj.PngHelper;
import jogamp.opengl.util.pngj.PngjException;
import jogamp.opengl.util.pngj.chunks.ChunkRaw;
import jogamp.opengl.util.pngj.chunks.PngChunk;

public class PngChunkBKGD
extends PngChunk {
    private int gray;
    private int red;
    private int green;
    private int blue;
    private int paletteIndex;

    public PngChunkBKGD(ImageInfo imageInfo) {
        super("bKGD", imageInfo);
    }

    @Override
    public boolean mustGoBeforeIDAT() {
        return true;
    }

    @Override
    public boolean mustGoAfterPLTE() {
        return true;
    }

    @Override
    public ChunkRaw createChunk() {
        ChunkRaw chunkRaw = null;
        if (this.imgInfo.greyscale) {
            chunkRaw = this.createEmptyChunk(2, true);
            PngHelper.writeInt2tobytes(this.gray, chunkRaw.data, 0);
        } else if (this.imgInfo.indexed) {
            chunkRaw = this.createEmptyChunk(1, true);
            chunkRaw.data[0] = (byte)this.paletteIndex;
        } else {
            chunkRaw = this.createEmptyChunk(6, true);
            PngHelper.writeInt2tobytes(this.red, chunkRaw.data, 0);
            PngHelper.writeInt2tobytes(this.green, chunkRaw.data, 0);
            PngHelper.writeInt2tobytes(this.blue, chunkRaw.data, 0);
        }
        return chunkRaw;
    }

    @Override
    public void parseFromChunk(ChunkRaw chunkRaw) {
        if (this.imgInfo.greyscale) {
            this.gray = PngHelper.readInt2fromBytes(chunkRaw.data, 0);
        } else if (this.imgInfo.indexed) {
            this.paletteIndex = chunkRaw.data[0] & 0xFF;
        } else {
            this.red = PngHelper.readInt2fromBytes(chunkRaw.data, 0);
            this.green = PngHelper.readInt2fromBytes(chunkRaw.data, 2);
            this.blue = PngHelper.readInt2fromBytes(chunkRaw.data, 4);
        }
    }

    @Override
    public void cloneDataFromRead(PngChunk pngChunk) {
        PngChunkBKGD pngChunkBKGD = (PngChunkBKGD)pngChunk;
        this.gray = pngChunkBKGD.gray;
        this.red = pngChunkBKGD.red;
        this.green = pngChunkBKGD.red;
        this.blue = pngChunkBKGD.red;
        this.paletteIndex = pngChunkBKGD.paletteIndex;
    }

    public void setGray(int n) {
        if (!this.imgInfo.greyscale) {
            throw new PngjException("only gray images support this");
        }
        this.gray = n;
    }

    public int getGray() {
        if (!this.imgInfo.greyscale) {
            throw new PngjException("only gray images support this");
        }
        return this.gray;
    }

    public void setPaletteIndex(int n) {
        if (!this.imgInfo.indexed) {
            throw new PngjException("only indexed (pallete) images support this");
        }
        this.paletteIndex = n;
    }

    public int getPaletteIndex() {
        if (!this.imgInfo.indexed) {
            throw new PngjException("only indexed (pallete) images support this");
        }
        return this.paletteIndex;
    }

    public void setRGB(int n, int n2, int n3) {
        if (this.imgInfo.greyscale || this.imgInfo.indexed) {
            throw new PngjException("only rgb or rgba images support this");
        }
        this.red = n;
        this.green = n2;
        this.blue = n3;
    }

    public int[] getRGB() {
        if (this.imgInfo.greyscale || this.imgInfo.indexed) {
            throw new PngjException("only rgb or rgba images support this");
        }
        return new int[]{this.red, this.green, this.blue};
    }
}

