/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.AbstractBundle;
import com.intellij.CommonBundle;
import com.intellij.diagnostic.PluginException;
import com.intellij.ide.plugins.ContainerDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.OptimizedPluginBean;
import com.intellij.ide.plugins.PluginDependency;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.ProductDescriptor;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentConfig;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.OldComponentConfig;
import com.intellij.openapi.components.ServiceDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.extensions.impl.ExtensionsAreaImpl;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SafeJdomFactory;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSetInterner;
import com.intellij.util.containers.Interner;
import com.intellij.util.messages.ListenerDescriptor;
import com.intellij.util.xmlb.BeanBinding;
import com.intellij.util.xmlb.JDOMXIncluder;
import com.intellij.util.xmlb.XmlSerializer;
import gnu.trove.THashMap;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IdeaPluginDescriptorImpl
implements IdeaPluginDescriptor {
    public static final IdeaPluginDescriptorImpl[] EMPTY_ARRAY = new IdeaPluginDescriptorImpl[0];
    private static final Logger LOG = Logger.getInstance("#com.intellij.ide.plugins.PluginDescriptor");
    static final List<String> SERVICE_QUALIFIED_ELEMENT_NAMES = Arrays.asList("com.intellij.applicationService", "com.intellij.projectService", "com.intellij.moduleService");
    private final File myPath;
    private final boolean myBundled;
    private String myName;
    private PluginId myId;
    private final NullableLazyValue<String> myDescription;
    @Nullable
    private String myProductCode;
    @Nullable
    private Date myReleaseDate;
    private int myReleaseVersion;
    private String myResourceBundleBaseName;
    private String myChangeNotes;
    private String myVersion;
    private String myVendor;
    private String myVendorEmail;
    private String myVendorUrl;
    private String myVendorLogoPath;
    private String myCategory;
    private String myUrl;
    private PluginId[] myDependencies;
    private PluginId[] myOptionalDependencies;
    private Map<PluginId, List<String>> myOptionalConfigs;
    private Map<PluginId, List<IdeaPluginDescriptorImpl>> myOptionalDescriptors;
    @Nullable
    private List<Element> myActionElements;
    @Nullable
    private THashMap<String, List<Element>> myExtensions;
    private final ContainerDescriptor myAppContainerDescriptor;
    private final ContainerDescriptor myProjectContainerDescriptor;
    private final ContainerDescriptor myModuleContainerDescriptor;
    private List<String> myModules;
    private ClassLoader myLoader;
    private String myDescriptionChildText;
    private boolean myUseIdeaClassLoader;
    private boolean myUseCoreClassLoader;
    private boolean myAllowBundledUpdate;
    private boolean myImplementationDetail;
    private String mySinceBuild;
    private String myUntilBuild;
    private boolean myEnabled;
    private boolean myExtensionsCleared;
    public static final Pattern EXPLICIT_BIG_NUMBER_PATTERN = Pattern.compile("(.*)\\.(9{4,}+|10{4,}+)");

    public IdeaPluginDescriptorImpl(@NotNull File pluginPath, boolean bundled) {
        if (pluginPath == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(0);
        }
        this.myDescription = NullableLazyValue.createValue(() -> this.computeDescription());
        this.myDependencies = PluginId.EMPTY_ARRAY;
        this.myOptionalDependencies = PluginId.EMPTY_ARRAY;
        this.myAppContainerDescriptor = new ContainerDescriptor();
        this.myProjectContainerDescriptor = new ContainerDescriptor();
        this.myModuleContainerDescriptor = new ContainerDescriptor();
        this.myEnabled = true;
        this.myExtensionsCleared = false;
        this.myPath = pluginPath;
        this.myBundled = bundled;
    }

    @Override
    public File getPath() {
        return this.myPath;
    }

    public void readExternal(@NotNull Element element, @NotNull URL url, @NotNull JDOMXIncluder.PathResolver pathResolver, @Nullable Interner<String> stringInterner, boolean ignoreDisabled) throws InvalidDataException, MalformedURLException {
        Application app;
        if (element == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(4);
        }
        if (url == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(5);
        }
        if (pathResolver == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(6);
        }
        this.readExternal(element, url, (app = ApplicationManager.getApplication()) != null && app.isUnitTestMode(), pathResolver, stringInterner, ignoreDisabled);
    }

    public void loadFromFile(@NotNull File file2, @Nullable SafeJdomFactory factory2, boolean ignoreMissingInclude, boolean ignoreDisabledPlugins) throws IOException, JDOMException {
        if (file2 == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(8);
        }
        this.readExternal(JDOMUtil.load(file2, factory2), file2.toURI().toURL(), ignoreMissingInclude, JDOMXIncluder.DEFAULT_PATH_RESOLVER, factory2 == null ? null : factory2.stringInterner(), ignoreDisabledPlugins);
    }

    private void readExternal(@NotNull Element element, @NotNull URL url, boolean ignoreMissingInclude, @NotNull JDOMXIncluder.PathResolver pathResolver, @Nullable Interner<String> stringInterner, boolean ignoreDisabledPlugins) throws InvalidDataException, MalformedURLException {
        if (element == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(9);
        }
        if (url == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(10);
        }
        if (pathResolver == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(11);
        }
        if (JDOMUtil.isEmpty(element)) {
            return;
        }
        String pluginId = element.getChildTextTrim("id");
        if (pluginId == null) {
            pluginId = element.getChildTextTrim("name");
        }
        if (pluginId == null || !PluginManagerCore.disabledPlugins().contains(pluginId) || ignoreDisabledPlugins) {
            JDOMXIncluder.resolveNonXIncludeElement(element, url, ignoreMissingInclude, pathResolver);
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Skipping resolving of " + pluginId + " from " + url);
        }
        this.readExternal(element, stringInterner);
    }

    private void readExternal(@NotNull Element element, @Nullable Interner<String> stringInterner) {
        if (element == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(12);
        }
        OptimizedPluginBean pluginBean = XmlSerializer.deserialize(element, OptimizedPluginBean.class);
        this.myUrl = pluginBean.url;
        String idString = StringUtil.nullize(pluginBean.id, true);
        String nameString = StringUtil.nullize(pluginBean.name, true);
        this.myId = idString != null ? PluginId.getId(idString) : (nameString != null ? PluginId.getId(nameString) : null);
        this.myName = ObjectUtils.chooseNotNull(nameString, idString);
        ProductDescriptor pd = pluginBean.productDescriptor;
        this.myProductCode = pd != null ? pd.code : null;
        this.myReleaseDate = IdeaPluginDescriptorImpl.parseReleaseDate(pluginBean);
        this.myReleaseVersion = pd != null ? pd.releaseVersion : 0;
        String internalVersionString = pluginBean.formatVersion;
        if (internalVersionString != null) {
            try {
                Integer.parseInt(internalVersionString);
            }
            catch (NumberFormatException e) {
                LOG.error(new PluginException("Invalid value in plugin.xml format version: '" + internalVersionString + "'", e, this.myId));
            }
        }
        this.myUseIdeaClassLoader = pluginBean.useIdeaClassLoader;
        this.myAllowBundledUpdate = pluginBean.allowBundledUpdate;
        this.myImplementationDetail = pluginBean.implementationDetail;
        if (pluginBean.ideaVersion != null) {
            this.mySinceBuild = pluginBean.ideaVersion.sinceBuild;
            this.myUntilBuild = IdeaPluginDescriptorImpl.convertExplicitBigNumberInUntilBuildToStar(pluginBean.ideaVersion.untilBuild);
        }
        this.myResourceBundleBaseName = pluginBean.resourceBundle;
        this.myDescriptionChildText = pluginBean.description;
        this.myChangeNotes = pluginBean.changeNotes;
        this.myVersion = pluginBean.pluginVersion;
        if (this.myVersion == null) {
            this.myVersion = PluginManagerCore.getBuildNumber().asStringWithoutProductCode();
        }
        this.myCategory = pluginBean.category;
        if (pluginBean.vendor != null) {
            this.myVendor = pluginBean.vendor.name;
            this.myVendorEmail = pluginBean.vendor.email;
            this.myVendorUrl = pluginBean.vendor.url;
            this.myVendorLogoPath = pluginBean.vendor.logo;
        }
        LinkedHashSet<PluginId> dependentPlugins = new LinkedHashSet<PluginId>();
        LinkedHashSet<PluginId> nonOptionalDependentPlugins = new LinkedHashSet<PluginId>();
        if (pluginBean.dependencies != null) {
            this.myOptionalConfigs = new LinkedHashMap<PluginId, List<String>>();
            for (PluginDependency dependency : pluginBean.dependencies) {
                String text2 = dependency.pluginId;
                if (StringUtil.isEmptyOrSpaces(text2)) continue;
                PluginId id2 = PluginId.getId(text2);
                dependentPlugins.add(id2);
                if (dependency.optional) {
                    if (StringUtil.isEmptyOrSpaces(dependency.configFile)) continue;
                    this.myOptionalConfigs.computeIfAbsent(id2, it -> new SmartList()).add(dependency.configFile);
                    continue;
                }
                nonOptionalDependentPlugins.add(id2);
            }
        }
        this.myDependencies = dependentPlugins.isEmpty() ? PluginId.EMPTY_ARRAY : dependentPlugins.toArray(PluginId.EMPTY_ARRAY);
        this.myOptionalDependencies = nonOptionalDependentPlugins.size() == dependentPlugins.size() ? PluginId.EMPTY_ARRAY : ContainerUtil.filter(dependentPlugins, id -> !nonOptionalDependentPlugins.contains(id)).toArray(PluginId.EMPTY_ARRAY);
        Ref<BeanBinding> oldComponentConfigBeanBinding = new Ref<BeanBinding>();
        if (stringInterner == null) {
            stringInterner = new HashSetInterner<String>(SERVICE_QUALIFIED_ELEMENT_NAMES);
        }
        THashMap epNameToExtensions = this.myExtensions;
        for (Content content : element.getContent()) {
            if (!(content instanceof Element)) continue;
            Element child = (Element)content;
            switch (child.getName()) {
                case "extensions": {
                    String ns = child.getAttributeValue("defaultExtensionNs");
                    for (Element extensionElement : child.getChildren()) {
                        ContainerDescriptor containerDescriptor;
                        String qualifiedExtensionPointName;
                        String os = extensionElement.getAttributeValue("os");
                        if (os != null) {
                            extensionElement.removeAttribute("os");
                            if (!IdeaPluginDescriptorImpl.isComponentSuitableForOs(os)) continue;
                        }
                        if ((qualifiedExtensionPointName = stringInterner.intern(ExtensionsAreaImpl.extractPointName(extensionElement, ns))).equals("com.intellij.applicationService")) {
                            containerDescriptor = this.myAppContainerDescriptor;
                        } else if (qualifiedExtensionPointName.equals("com.intellij.projectService")) {
                            containerDescriptor = this.myProjectContainerDescriptor;
                        } else if (qualifiedExtensionPointName.equals("com.intellij.moduleService")) {
                            containerDescriptor = this.myModuleContainerDescriptor;
                        } else {
                            SmartList<Element> list2;
                            if (epNameToExtensions == null) {
                                this.myExtensions = epNameToExtensions = new THashMap();
                            }
                            if ((list2 = (SmartList<Element>)epNameToExtensions.get((Object)qualifiedExtensionPointName)) == null) {
                                list2 = new SmartList<Element>();
                                epNameToExtensions.put((Object)qualifiedExtensionPointName, list2);
                            }
                            list2.add(extensionElement);
                            continue;
                        }
                        containerDescriptor.addService(IdeaPluginDescriptorImpl.readServiceDescriptor(extensionElement));
                    }
                    break;
                }
                case "extensionPoints": {
                    for (Element extensionPoint : child.getChildren()) {
                        String area = extensionPoint.getAttributeValue("area");
                        ContainerDescriptor containerDescriptor = this.getContainerDescriptorByExtensionArea(area);
                        if (containerDescriptor == null) {
                            LOG.error("Unknown area: " + area);
                            continue;
                        }
                        List<Element> result2 = containerDescriptor.extensionsPoints;
                        if (result2 == null) {
                            containerDescriptor.extensionsPoints = result2 = new ArrayList<Element>();
                        }
                        result2.add(extensionPoint);
                    }
                    break;
                }
                case "actions": {
                    if (this.myActionElements == null) {
                        this.myActionElements = new ArrayList<Element>(child.getChildren());
                        break;
                    }
                    this.myActionElements.addAll(child.getChildren());
                    break;
                }
                case "module": {
                    String moduleName = child.getAttributeValue("value");
                    if (moduleName == null) break;
                    if (this.myModules == null) {
                        this.myModules = new SmartList<String>();
                    }
                    this.myModules.add(moduleName);
                    break;
                }
                case "application-components": {
                    IdeaPluginDescriptorImpl.readComponents(child, oldComponentConfigBeanBinding, this.myAppContainerDescriptor);
                    break;
                }
                case "project-components": {
                    IdeaPluginDescriptorImpl.readComponents(child, oldComponentConfigBeanBinding, this.myProjectContainerDescriptor);
                    break;
                }
                case "module-components": {
                    IdeaPluginDescriptorImpl.readComponents(child, oldComponentConfigBeanBinding, this.myModuleContainerDescriptor);
                    break;
                }
                case "applicationListeners": {
                    this.readListeners(child, this.myAppContainerDescriptor);
                    break;
                }
                case "projectListeners": {
                    this.readListeners(child, this.myProjectContainerDescriptor);
                }
            }
            child.getContent().clear();
        }
    }

    private void readListeners(@NotNull Element list2, @NotNull ContainerDescriptor containerDescriptor) {
        if (list2 == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(13);
        }
        if (containerDescriptor == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(14);
        }
        List<Content> content = list2.getContent();
        List<ListenerDescriptor> result2 = containerDescriptor.listeners;
        if (result2 == null) {
            containerDescriptor.listeners = result2 = new ArrayList<ListenerDescriptor>(content.size());
        } else {
            ((ArrayList)result2).ensureCapacity(result2.size() + content.size());
        }
        for (Content item : content) {
            if (!(item instanceof Element)) continue;
            Element child = (Element)item;
            String listenerClassName = child.getAttributeValue("class");
            String topicClassName = child.getAttributeValue("topic");
            if (listenerClassName == null || topicClassName == null) {
                LOG.error("Listener descriptor is not correct: " + JDOMUtil.writeElement(child));
                continue;
            }
            result2.add(new ListenerDescriptor(listenerClassName, topicClassName, IdeaPluginDescriptorImpl.getBoolean("activeInTestMode", child), IdeaPluginDescriptorImpl.getBoolean("activeInHeadlessMode", child), this));
        }
    }

    private static boolean getBoolean(@NotNull String name, @NotNull Element child) {
        String value2;
        if (name == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(15);
        }
        if (child == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(16);
        }
        return (value2 = child.getAttributeValue(name)) == null || Boolean.parseBoolean(value2);
    }

    @NotNull
    private static ServiceDescriptor readServiceDescriptor(@NotNull Element element) {
        if (element == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(17);
        }
        ServiceDescriptor descriptor2 = new ServiceDescriptor();
        descriptor2.serviceInterface = element.getAttributeValue("serviceInterface");
        descriptor2.serviceImplementation = StringUtil.nullize(element.getAttributeValue("serviceImplementation"));
        descriptor2.testServiceImplementation = StringUtil.nullize(element.getAttributeValue("testServiceImplementation"));
        descriptor2.headlessImplementation = StringUtil.nullize(element.getAttributeValue("headlessImplementation"));
        descriptor2.configurationSchemaKey = element.getAttributeValue("configurationSchemaKey");
        String preload = element.getAttributeValue("preload");
        if (preload != null) {
            if (preload.equals("true")) {
                descriptor2.preload = ServiceDescriptor.PreloadMode.TRUE;
            } else if (preload.equals("await")) {
                descriptor2.preload = ServiceDescriptor.PreloadMode.AWAIT;
            } else if (preload.equals("notHeadless")) {
                descriptor2.preload = ServiceDescriptor.PreloadMode.NOT_HEADLESS;
            } else {
                LOG.error("Unknown preload mode value: " + JDOMUtil.writeElement(element));
            }
        }
        descriptor2.overrides = Boolean.parseBoolean(element.getAttributeValue("overrides"));
        ServiceDescriptor serviceDescriptor = descriptor2;
        if (serviceDescriptor == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(18);
        }
        return serviceDescriptor;
    }

    private static void readComponents(@NotNull Element parent2, @NotNull Ref<BeanBinding> oldComponentConfigBean, @NotNull ContainerDescriptor containerDescriptor) {
        List<Content> content;
        int contentSize;
        if (parent2 == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(19);
        }
        if (oldComponentConfigBean == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(20);
        }
        if (containerDescriptor == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(21);
        }
        if ((contentSize = (content = parent2.getContent()).size()) == 0) {
            return;
        }
        List<ComponentConfig> result2 = containerDescriptor.getComponentListToAdd(contentSize);
        for (Content child : content) {
            Element componentElement;
            if (!(child instanceof Element) || !(componentElement = (Element)child).getName().equals("component")) continue;
            OldComponentConfig componentConfig = new OldComponentConfig();
            BeanBinding beanBinding = oldComponentConfigBean.get();
            if (beanBinding == null) {
                beanBinding = XmlSerializer.getBeanBinding(componentConfig);
                oldComponentConfigBean.set(beanBinding);
            }
            beanBinding.deserializeInto(componentConfig, componentElement);
            Map options = componentConfig.options;
            if (options != null && !IdeaPluginDescriptorImpl.isComponentSuitableForOs((String)options.get("os"))) continue;
            result2.add(componentConfig);
        }
    }

    @Nullable
    private static Date parseReleaseDate(@NotNull OptimizedPluginBean bean) {
        ProductDescriptor pd;
        String dateStr;
        if (bean == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(22);
        }
        String string2 = dateStr = (pd = bean.productDescriptor) != null ? pd.releaseDate : null;
        if (dateStr != null) {
            try {
                return new SimpleDateFormat("yyyyMMdd", Locale.US).parse(dateStr);
            }
            catch (ParseException e) {
                LOG.info("Error parse release date from plugin descriptor for plugin " + bean.name + " {" + bean.id + "}: " + e.getMessage());
            }
        }
        return null;
    }

    public static String convertExplicitBigNumberInUntilBuildToStar(@Nullable String build2) {
        if (build2 == null) {
            return null;
        }
        Matcher matcher2 = EXPLICIT_BIG_NUMBER_PATTERN.matcher(build2);
        if (matcher2.matches()) {
            return matcher2.group(1) + ".*";
        }
        return build2;
    }

    void registerExtensionPoints(@NotNull ExtensionsAreaImpl area, @NotNull ComponentManager componentManager) {
        if (area == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(23);
        }
        if (componentManager == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(24);
        }
        ContainerDescriptor containerDescriptor = componentManager.getPicoContainer().getParent() == null ? this.myAppContainerDescriptor : (componentManager.getPicoContainer().getParent().getParent() == null ? this.myProjectContainerDescriptor : this.myModuleContainerDescriptor);
        List<Element> extensionsPoints = containerDescriptor.extensionsPoints;
        if (extensionsPoints != null) {
            area.registerExtensionPoints(this, extensionsPoints, componentManager);
        }
    }

    @Nullable
    private ContainerDescriptor getContainerDescriptorByExtensionArea(@Nullable String area) {
        if (area == null) {
            return this.myAppContainerDescriptor;
        }
        if ("IDEA_PROJECT".equals(area)) {
            return this.myProjectContainerDescriptor;
        }
        if ("IDEA_MODULE".equals(area)) {
            return this.myModuleContainerDescriptor;
        }
        return null;
    }

    @ApiStatus.Internal
    public void registerExtensions(@NotNull ExtensionsAreaImpl area, @NotNull ComponentManager componentManager, boolean notifyListeners) {
        THashMap<String, List<Element>> extensions;
        if (area == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(28);
        }
        if (componentManager == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(29);
        }
        if (componentManager.getPicoContainer().getParent() == null) {
            extensions = this.myAppContainerDescriptor.extensions;
            if (extensions == null) {
                if (this.myExtensions == null) {
                    return;
                }
                this.myExtensions.retainEntries((name, list2) -> {
                    if (area.registerExtensions((String)name, (List<? extends Element>)list2, this, componentManager, notifyListeners)) {
                        if (this.myAppContainerDescriptor.extensions == null) {
                            this.myAppContainerDescriptor.extensions = new THashMap();
                        }
                        IdeaPluginDescriptorImpl.addExtensionList(this.myAppContainerDescriptor.extensions, name, list2);
                        return false;
                    }
                    return true;
                });
                this.myExtensionsCleared = true;
                if (this.myExtensions.isEmpty()) {
                    this.myExtensions = null;
                }
                return;
            }
        } else {
            extensions = this.myExtensions;
            if (extensions == null) {
                return;
            }
        }
        extensions.forEachEntry((name, list2) -> {
            area.registerExtensions((String)name, (List<? extends Element>)list2, this, componentManager, notifyListeners);
            return true;
        });
    }

    @Override
    public String getName() {
        return this.myName;
    }

    @Override
    @NotNull
    public PluginId[] getDependentPluginIds() {
        if (this.myDependencies == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(30);
        }
        return this.myDependencies;
    }

    @Override
    @NotNull
    public PluginId[] getOptionalDependentPluginIds() {
        if (this.myOptionalDependencies == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(31);
        }
        return this.myOptionalDependencies;
    }

    @Override
    public String getVendor() {
        return this.myVendor;
    }

    @Override
    public String getVersion() {
        return this.myVersion;
    }

    @Override
    public String getCategory() {
        return this.myCategory;
    }

    @NotNull
    public List<File> getClassPath() {
        if (this.myPath.isDirectory()) {
            File[] files2;
            ArrayList<File> result2 = new ArrayList<File>();
            File classesDir = new File(this.myPath, "classes");
            if (classesDir.exists()) {
                result2.add(classesDir);
            }
            if ((files2 = new File(this.myPath, "lib").listFiles()) != null && files2.length > 0) {
                for (File f : files2) {
                    if (f.isFile()) {
                        String name = f.getName();
                        if (!StringUtil.endsWithIgnoreCase(name, ".jar") && !StringUtil.endsWithIgnoreCase(name, ".zip")) continue;
                        result2.add(f);
                        continue;
                    }
                    result2.add(f);
                }
            }
            ArrayList<File> arrayList = result2;
            if (arrayList == null) {
                IdeaPluginDescriptorImpl.$$$reportNull$$$0(32);
            }
            return arrayList;
        }
        List<File> list2 = Collections.singletonList(this.myPath);
        if (list2 == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(33);
        }
        return list2;
    }

    public void setLoader(ClassLoader loader) {
        this.myLoader = loader;
    }

    @Override
    public PluginId getPluginId() {
        return this.myId;
    }

    @Override
    public ClassLoader getPluginClassLoader() {
        return this.myLoader != null ? this.myLoader : this.getClass().getClassLoader();
    }

    @Override
    public boolean getUseIdeaClassLoader() {
        return this.myUseIdeaClassLoader;
    }

    boolean isUseCoreClassLoader() {
        return this.myUseCoreClassLoader;
    }

    void setUseCoreClassLoader(boolean useCoreClassLoader) {
        this.myUseCoreClassLoader = useCoreClassLoader;
    }

    private String computeDescription() {
        ResourceBundle bundle = null;
        if (this.myResourceBundleBaseName != null) {
            try {
                bundle = AbstractBundle.getResourceBundle(this.myResourceBundleBaseName, this.getPluginClassLoader());
            }
            catch (MissingResourceException e) {
                LOG.info("Cannot find plugin " + this.myId + " resource-bundle: " + this.myResourceBundleBaseName);
            }
        }
        if (bundle == null) {
            return this.myDescriptionChildText;
        }
        return CommonBundle.messageOrDefault(bundle, "plugin." + this.myId + ".description", StringUtil.notNullize(this.myDescriptionChildText), new Object[0]);
    }

    void insertDependency(@NotNull IdeaPluginDescriptor d) {
        if (d == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(34);
        }
        PluginId[] deps = new PluginId[this.getDependentPluginIds().length + 1];
        deps[0] = d.getPluginId();
        System.arraycopy(this.myDependencies, 0, deps, 1, deps.length - 1);
        this.myDependencies = deps;
    }

    @Override
    public boolean isEnabled() {
        return this.myEnabled;
    }

    @Override
    public void setEnabled(boolean enabled2) {
        this.myEnabled = enabled2;
    }

    @Override
    public String getSinceBuild() {
        return this.mySinceBuild;
    }

    @Override
    public String getUntilBuild() {
        return this.myUntilBuild;
    }

    Map<PluginId, List<String>> getOptionalConfigs() {
        return this.myOptionalConfigs;
    }

    @Nullable
    Map<PluginId, List<IdeaPluginDescriptorImpl>> getOptionalDescriptors() {
        return this.myOptionalDescriptors;
    }

    void setOptionalDescriptors(@Nullable Map<PluginId, List<IdeaPluginDescriptorImpl>> optionalDescriptors) {
        this.myOptionalDescriptors = optionalDescriptors;
    }

    void mergeOptionalConfig(@NotNull IdeaPluginDescriptorImpl descriptor2) {
        if (descriptor2 == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(35);
        }
        if (this.myExtensions == null) {
            this.myExtensions = descriptor2.myExtensions;
        } else if (descriptor2.myExtensions != null) {
            descriptor2.myExtensions.forEachEntry((name, list2) -> {
                IdeaPluginDescriptorImpl.addExtensionList(this.myExtensions, name, list2);
                return true;
            });
        }
        if (this.myActionElements == null) {
            this.myActionElements = descriptor2.myActionElements;
        } else if (descriptor2.myActionElements != null) {
            this.myActionElements.addAll(descriptor2.myActionElements);
        }
        this.myAppContainerDescriptor.merge(descriptor2.myAppContainerDescriptor);
        this.myProjectContainerDescriptor.merge(descriptor2.myProjectContainerDescriptor);
        this.myModuleContainerDescriptor.merge(descriptor2.myModuleContainerDescriptor);
    }

    private static void addExtensionList(@NotNull Map<String, List<Element>> map2, @NotNull String name, @NotNull List<Element> list2) {
        List<Element> myList;
        if (map2 == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(36);
        }
        if (name == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(37);
        }
        if (list2 == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(38);
        }
        if ((myList = map2.get(name)) == null) {
            map2.put(name, list2);
        } else {
            myList.addAll(list2);
        }
    }

    @Override
    public boolean isBundled() {
        return this.myBundled;
    }

    @Override
    public boolean isImplementationDetail() {
        return this.myImplementationDetail;
    }

    @NotNull
    public List<String> getModules() {
        List<String> list2 = ContainerUtil.notNullize(this.myModules);
        if (list2 == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(39);
        }
        return list2;
    }

    public boolean equals(Object o) {
        return this == o || o instanceof IdeaPluginDescriptorImpl && this.myId == ((IdeaPluginDescriptorImpl)o).myId;
    }

    public int hashCode() {
        return Objects.hashCode(this.myId);
    }

    public String toString() {
        return "PluginDescriptor(name=" + this.myName + ", classpath=" + this.myPath + ")";
    }

    private static boolean isComponentSuitableForOs(@Nullable String os) {
        if (StringUtil.isEmpty(os)) {
            return true;
        }
        if (os.equals(OS.mac.name())) {
            return SystemInfo.isMac;
        }
        if (os.equals(OS.linux.name())) {
            return SystemInfo.isLinux;
        }
        if (os.equals(OS.windows.name())) {
            return SystemInfo.isWindows;
        }
        if (os.equals(OS.unix.name())) {
            return SystemInfo.isUnix;
        }
        if (os.equals(OS.freebsd.name())) {
            return SystemInfo.isFreeBSD;
        }
        throw new IllegalArgumentException("Unknown OS '" + os + "'");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 18: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 39: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 18: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 39: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginPath";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 18: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/plugins/IdeaPluginDescriptorImpl";
                break;
            }
            case 4: 
            case 9: 
            case 12: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathResolver";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 13: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 14: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containerDescriptor";
                break;
            }
            case 15: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldComponentConfigBean";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bean";
                break;
            }
            case 23: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "area";
                break;
            }
            case 24: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentManager";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "d";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/plugins/IdeaPluginDescriptorImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getApp";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getModule";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "readServiceDescriptor";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getAppContainerDescriptor";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectContainerDescriptor";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleContainerDescriptor";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependentPluginIds";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionalDependentPluginIds";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassPath";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getModules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 18: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 39: {
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "loadFromFile";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "readListeners";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getBoolean";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "readServiceDescriptor";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "readComponents";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "parseReleaseDate";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "registerExtensionPoints";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "registerExtensions";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "insertDependency";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "mergeOptionalConfig";
                break;
            }
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "addExtensionList";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "processExtensionPoints";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 18: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 39: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum OS {
        mac,
        linux,
        windows,
        unix,
        freebsd;

    }
}

