/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.se.discovery;

import java.net.URL;
import org.jboss.weld.environment.se.discovery.SEWeldDiscovery;
import org.jboss.weld.environment.se.discovery.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractScanner
implements Scanner {
    private static final Logger log = LoggerFactory.getLogger(Scanner.class);
    private final ClassLoader classLoader;
    private final SEWeldDiscovery webBeanDiscovery;

    public AbstractScanner(ClassLoader classLoader, SEWeldDiscovery webBeanDiscovery) {
        this.classLoader = classLoader;
        this.webBeanDiscovery = webBeanDiscovery;
    }

    protected void handle(String name, URL url) {
        if (name.endsWith(".class")) {
            String className = AbstractScanner.filenameToClassname(name);
            try {
                this.webBeanDiscovery.getWbClasses().add(this.getClassLoader().loadClass(className));
            }
            catch (NoClassDefFoundError e) {
                log.error("Error loading " + name, e);
            }
            catch (ClassNotFoundException e) {
                log.error("Error loading " + name, e);
            }
        } else if (name.endsWith("beans.xml")) {
            this.webBeanDiscovery.getWbUrls().add(url);
        }
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public static String filenameToClassname(String filename) {
        return filename.substring(0, filename.lastIndexOf(".class")).replace('/', '.').replace('\\', '.');
    }
}

