/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.conversation;

import java.io.Serializable;
import javax.enterprise.context.Conversation;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.inject.Default;
import javax.inject.Inject;
import javax.inject.Named;
import org.jboss.weld.Container;
import org.jboss.weld.context.ContextLifecycle;
import org.jboss.weld.context.ContextNotActiveException;
import org.jboss.weld.conversation.ConversationIdGenerator;
import org.jboss.weld.conversation.ConversationInactivityTimeout;
import org.jboss.weld.exceptions.ForbiddenStateException;
import org.jboss.weld.logging.Category;
import org.jboss.weld.logging.LoggerFactory;
import org.jboss.weld.logging.messages.BeanManagerMessage;
import org.jboss.weld.logging.messages.ConversationMessage;
import org.slf4j.cal10n.LocLogger;

@RequestScoped
@Named(value="javax.enterprise.context.conversation")
@Default
public class ConversationImpl
implements Conversation,
Serializable {
    private static final long serialVersionUID = 5262382965141841363L;
    private static final LocLogger log = LoggerFactory.loggerFactory().getLogger(Category.CONVERSATION);
    private String id;
    private String originalId;
    private boolean _transient = true;
    private long timeout;

    public ConversationImpl() {
    }

    protected void checkConversationActive() {
        if (!Container.instance().services().get(ContextLifecycle.class).getConversationContext().isActive()) {
            throw new ContextNotActiveException(BeanManagerMessage.CONTEXT_NOT_ACTIVE, "@ConversationScoped");
        }
    }

    public ConversationImpl(ConversationImpl conversation) {
        this.id = conversation.getUnderlyingId();
        this._transient = conversation.isTransient();
        this.timeout = conversation.getTimeout();
    }

    @Inject
    public void init(ConversationIdGenerator conversationIdGenerator, @ConversationInactivityTimeout long timeout) {
        this.id = conversationIdGenerator.nextId();
        this.timeout = timeout;
        this._transient = true;
    }

    public void begin() {
        this.checkConversationActive();
        if (!this.isTransient()) {
            throw new ForbiddenStateException(ConversationMessage.BEGIN_CALLED_ON_LONG_RUNNING_CONVERSATION, new Object[0]);
        }
        log.debug(ConversationMessage.PROMOTED_TRANSIENT, this.id);
        this._transient = false;
    }

    public void begin(String id) {
        this.checkConversationActive();
        if (this.originalId == null) {
            this.originalId = id;
        }
        this.id = id;
        this.begin();
    }

    public void end() {
        this.checkConversationActive();
        if (this.isTransient()) {
            throw new ForbiddenStateException(ConversationMessage.END_CALLED_ON_TRANSIENT_CONVERSATION, new Object[0]);
        }
        log.debug(ConversationMessage.DEMOTED_LRC, this.id);
        this._transient = true;
    }

    public String getId() {
        this.checkConversationActive();
        if (!this.isTransient()) {
            return this.id;
        }
        return null;
    }

    public String getUnderlyingId() {
        return this.id;
    }

    public long getTimeout() {
        this.checkConversationActive();
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.checkConversationActive();
        this.timeout = timeout;
    }

    public void switchTo(ConversationImpl conversation) {
        log.debug(ConversationMessage.SWITCHED_CONVERSATION, this, conversation);
        this.id = conversation.id;
        this._transient = conversation._transient;
        this.timeout = conversation.timeout;
    }

    public String toString() {
        return "ID: " + this.id + ", transient: " + this.isTransient() + ", timeout: " + this.timeout + "ms";
    }

    public String getOriginalId() {
        return this.originalId;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ConversationImpl) {
            ConversationImpl that = (ConversationImpl)obj;
            return this.id == null || that.getUnderlyingId() == null ? false : this.id.equals(that.getUnderlyingId());
        }
        return false;
    }

    public int hashCode() {
        return this.id == null ? super.hashCode() : this.id.hashCode();
    }

    public boolean isTransient() {
        this.checkConversationActive();
        return this._transient;
    }
}

