/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.transport.rmi;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.SocketTimeoutException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.net.SocketFactory;
import org.jboss.logging.Logger;
import org.jboss.remoting.AbstractInvoker;
import org.jboss.remoting.CannotConnectException;
import org.jboss.remoting.ConnectionFailedException;
import org.jboss.remoting.Home;
import org.jboss.remoting.InvocationRequest;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.RemoteClientInvoker;
import org.jboss.remoting.marshal.Marshaller;
import org.jboss.remoting.marshal.MarshallerDecorator;
import org.jboss.remoting.marshal.UnMarshaller;
import org.jboss.remoting.marshal.UnMarshallerDecorator;
import org.jboss.remoting.marshal.VersionedMarshaller;
import org.jboss.remoting.marshal.VersionedUnMarshaller;
import org.jboss.remoting.marshal.rmi.RMIMarshaller;
import org.jboss.remoting.marshal.rmi.RMIUnMarshaller;
import org.jboss.remoting.serialization.SerializationManager;
import org.jboss.remoting.serialization.SerializationStreamFactory;
import org.jboss.remoting.transport.rmi.RMIServerInvoker;
import org.jboss.remoting.transport.rmi.RMIServerInvokerInf;
import org.jboss.remoting.transport.rmi.RemotingRMIClientSocketFactory;
import org.jboss.util.threadpool.BasicThreadPool;
import org.jboss.util.threadpool.BlockingMode;
import org.jboss.util.threadpool.RunnableTaskWrapper;
import org.jboss.util.threadpool.TaskWrapper;
import org.jboss.util.threadpool.ThreadPool;

public class RMIClientInvoker
extends RemoteClientInvoker {
    public static final String MAX_NUM_TIMEOUT_THREADS = "maxNumTimeoutThreads";
    public static final String MAX_TIMEOUT_QUEUE_SIZE = "maxTimeoutQueueSize";
    public static final int MAX_NUM_TIMEOUT_THREADS_DEFAULT = 10;
    private static final Logger log = Logger.getLogger((Class)RMIClientInvoker.class);
    private static final boolean isTraceEnabled = log.isTraceEnabled();
    private RMIServerInvokerInf server;
    private Object timeoutThreadPoolLock = new Object();
    private ThreadPool timeoutThreadPool;
    protected boolean rmiOnewayMarshalling;
    private boolean connected = false;

    public RMIClientInvoker(InvokerLocator locator) {
        super(locator);
        this.configureParameters();
    }

    public RMIClientInvoker(InvokerLocator locator, Map configuration) {
        super(locator, configuration);
        this.configureParameters();
    }

    protected void configureParameters() {
        Map params = this.configuration;
        if (params == null) {
            return;
        }
        Object val = params.get(RMIServerInvoker.RMI_ONEWAY_MARSHALLING);
        if (val instanceof String) {
            try {
                this.rmiOnewayMarshalling = Boolean.valueOf((String)val);
                log.debug((Object)(this + " setting rmiOnewayMarshalling to " + this.rmiOnewayMarshalling));
            }
            catch (Exception e) {
                log.warn((Object)(this + " could not convert " + RMIServerInvoker.RMI_ONEWAY_MARSHALLING + " value of " + val + " to a boolean value.  Defaulting to false"));
            }
        } else if (val != null) {
            log.warn((Object)(this + " value of " + RMIServerInvoker.RMI_ONEWAY_MARSHALLING + " (" + val + ") must be a String.  Defaulting to false"));
        }
    }

    private int getRegistryPort(InvokerLocator locator) {
        String value;
        int port = 3455;
        Map params = locator.getParameters();
        if (params != null && (value = (String)params.get("registryPort")) != null) {
            try {
                port = Integer.parseInt(value);
                log.debug((Object)("Using port " + port + " for rmi registry."));
            }
            catch (NumberFormatException e) {
                log.error((Object)("Can not set the RMIServerInvoker RMI registry to port " + value + ".  This is not a valid port number."));
            }
        }
        return port;
    }

    public void setServerStub(RMIServerInvokerInf server) {
        this.server = server;
        log.trace((Object)this.server);
    }

    public RMIServerInvokerInf getServerStub() {
        return this.server;
    }

    protected void handleConnect() throws ConnectionFailedException {
        int registryPort = this.getRegistryPort(this.locator);
        Home home = null;
        Exception savedException = null;
        Iterator it = this.getConnectHomes().iterator();
        while (it.hasNext()) {
            try {
                home = (Home)it.next();
                String host = home.host;
                int port = home.port;
                this.locator.setHomeInUse(home);
                this.storeLocalConfig(this.configuration);
                log.debug((Object)(this + " looking up registry: " + host + "," + port));
                Registry registry = LocateRegistry.getRegistry(host, registryPort);
                log.debug((Object)(this + " trying to connect to: " + home));
                Remote remoteObj = null;
                remoteObj = registry.lookup("remoting/RMIServerInvoker/" + port);
                log.debug((Object)("Remote RMI Stub: " + remoteObj));
                this.setServerStub((RMIServerInvokerInf)remoteObj);
                this.connected = true;
                break;
            }
            catch (Exception e) {
                savedException = e;
                this.connected = false;
                RemotingRMIClientSocketFactory.removeLocalConfiguration(this.locator);
                log.trace((Object)("Unable to connect RMI invoker client to " + home), (Throwable)e);
            }
        }
        if (this.server == null) {
            String message = this + " unable to connect RMI invoker client";
            log.debug((Object)message);
            throw new CannotConnectException(message, savedException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Home getUsableAddress() {
        InvokerLocator savedLocator = this.locator;
        String protocol = savedLocator.getProtocol();
        String path = savedLocator.getPath();
        Map params = savedLocator.getParameters();
        List homes = this.locator.getConnectHomeList();
        Home home = null;
        Iterator it = homes.iterator();
        while (it.hasNext()) {
            Object var10_10;
            try {
                home = (Home)it.next();
                this.locator = new InvokerLocator(protocol, home.host, home.port, path, params);
                this.invoke(new InvocationRequest(null, null, "$ECHO$", null, null, null));
                if (log.isTraceEnabled()) {
                    log.trace((Object)(this + " able to contact server at: " + home));
                }
                Home home2 = home;
                var10_10 = null;
                this.locator = savedLocator;
                return home2;
            }
            catch (Throwable e) {
                try {
                    log.debug((Object)(this + " unable to contact server at: " + home));
                    var10_10 = null;
                    this.locator = savedLocator;
                }
                catch (Throwable throwable) {
                    var10_10 = null;
                    this.locator = savedLocator;
                    throw throwable;
                }
            }
        }
        return home;
    }

    protected void handleDisconnect() {
        RemotingRMIClientSocketFactory.removeLocalConfiguration(this.locator);
    }

    protected String getDefaultDataType() {
        return "rmi";
    }

    protected void storeLocalConfig(Map config) {
        HashMap<String, SocketFactory> localConfig = new HashMap<String, SocketFactory>(config);
        if (this.socketFactory != null && !this.socketFactoryCreatedFromSSLParameters && AbstractInvoker.isCompleteSocketFactory(this.socketFactory)) {
            localConfig.put("customSocketFactory", this.socketFactory);
        }
        RemotingRMIClientSocketFactory.addLocalConfiguration(this.locator, localConfig);
    }

    protected Object transport(String sessionId, Object invocation, Map metadata, Marshaller marshaller, UnMarshaller unmarshaller) throws IOException, ConnectionFailedException {
        if (this.server == null) {
            log.debug((Object)"Server stub has not been set in RMI invoker client.  See previous errors for details.");
            throw new CannotConnectException("Server stub has not been set.");
        }
        try {
            Object result;
            int simulatedTimeout;
            Object payload = invocation;
            if (marshaller != null && !(marshaller instanceof RMIMarshaller)) {
                if (marshaller instanceof MarshallerDecorator) {
                    payload = ((MarshallerDecorator)((Object)marshaller)).addDecoration(payload);
                } else {
                    ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
                    if (marshaller instanceof VersionedMarshaller) {
                        ((VersionedMarshaller)marshaller).write(payload, byteOut, this.getVersion());
                    } else {
                        marshaller.write(payload, byteOut);
                    }
                    byteOut.close();
                    if (this.rmiOnewayMarshalling) {
                        ByteArrayInputStream bais = new ByteArrayInputStream(byteOut.toByteArray());
                        SerializationManager manager = SerializationStreamFactory.getManagerInstance(this.getSerializationType());
                        ObjectInputStream ois = manager.createInput(bais, this.getClassLoader());
                        try {
                            byteOut.close();
                            payload = ois.readObject();
                            ois.close();
                        }
                        catch (ClassNotFoundException e) {
                            log.debug((Object)("Could not marshall invocation payload object " + payload), (Throwable)e);
                            throw new IOException(e.getMessage());
                        }
                    } else {
                        payload = byteOut.toByteArray();
                    }
                }
            }
            if ((simulatedTimeout = this.getSimulatedTimeout(this.configuration, metadata)) <= 0) {
                Object result2 = this.server.transport(payload);
                return this.unmarshal(result2, unmarshaller, metadata);
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)("using simulated timeout: " + simulatedTimeout));
            }
            class Holder {
                public Object value;

                Holder() {
                }
            }
            final Holder resultHolder = new Holder();
            final Object finalPayload = payload;
            Runnable r = new Runnable(){
                {
                }

                public void run() {
                    block3: {
                        try {
                            resultHolder.value = RMIClientInvoker.this.server.transport(finalPayload);
                            if (log.isTraceEnabled()) {
                                log.trace((Object)("result: " + resultHolder.value));
                            }
                        }
                        catch (Exception e) {
                            resultHolder.value = e;
                            if (!log.isTraceEnabled()) break block3;
                            log.trace((Object)("exception: " + e));
                        }
                    }
                }
            };
            Thread.interrupted();
            ThreadPool pool = this.getTimeoutThreadPool();
            WaitingTaskWrapper wrapper = new WaitingTaskWrapper(r, simulatedTimeout);
            if (log.isTraceEnabled()) {
                log.trace((Object)"starting task in thread pool");
            }
            pool.runTaskWrapper((TaskWrapper)wrapper);
            if (log.isTraceEnabled()) {
                log.trace((Object)"task finished in thread pool");
            }
            if ((result = this.unmarshal(resultHolder.value, unmarshaller, metadata)) == null) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)"invocation timed out");
                }
                SocketTimeoutException cause = new SocketTimeoutException("timed out");
                throw new CannotConnectException("Can not connect http client invoker.", cause);
            }
            if (result instanceof IOException) {
                throw (IOException)result;
            }
            if (result instanceof RuntimeException) {
                throw (RuntimeException)result;
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)("returning result: " + result));
            }
            return result;
        }
        catch (RemoteException e) {
            log.debug((Object)"Error making invocation in RMI client invoker.", (Throwable)e);
            throw new CannotConnectException("Error making invocation in RMI client invoker.", e);
        }
    }

    private int getSimulatedTimeout(Map configuration, Map metadata) {
        int timeout = -1;
        String connectionTimeout = (String)configuration.get("timeout");
        String invocationTimeout = null;
        if (metadata != null) {
            invocationTimeout = (String)metadata.get("timeout");
        }
        if (invocationTimeout != null && invocationTimeout.length() > 0) {
            try {
                timeout = Integer.parseInt(invocationTimeout);
            }
            catch (NumberFormatException e) {
                log.warn((Object)("Could not set timeout for current invocation because value (" + invocationTimeout + ") is not a number."));
            }
        }
        if (timeout < 0 && connectionTimeout != null && connectionTimeout.length() > 0) {
            try {
                timeout = Integer.parseInt(connectionTimeout);
            }
            catch (NumberFormatException e) {
                log.warn((Object)("Could not set timeout for http client connection because value (" + connectionTimeout + ") is not a number."));
            }
        }
        if (timeout < 0) {
            timeout = 0;
        }
        return timeout;
    }

    protected Object unmarshal(Object o, UnMarshaller unmarshaller, Map metadata) throws IOException {
        Object result = o;
        if (unmarshaller != null && !(unmarshaller instanceof RMIUnMarshaller) && !this.rmiOnewayMarshalling) {
            if (unmarshaller instanceof UnMarshallerDecorator) {
                result = ((UnMarshallerDecorator)((Object)unmarshaller)).removeDecoration(o);
            } else {
                byte[] byteIn = (byte[])o;
                ByteArrayInputStream is = new ByteArrayInputStream(byteIn);
                try {
                    result = unmarshaller instanceof VersionedUnMarshaller ? ((VersionedUnMarshaller)unmarshaller).read(is, metadata, this.getVersion()) : unmarshaller.read(is, metadata);
                }
                catch (ClassNotFoundException e) {
                    log.debug((Object)("Could not unmarshall invocation response" + o), (Throwable)e);
                    throw new IOException(e.getMessage());
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ThreadPool getTimeoutThreadPool() {
        Object object = this.timeoutThreadPoolLock;
        synchronized (object) {
            if (this.timeoutThreadPool == null) {
                int maxNumberThreads = 10;
                int maxTimeoutQueueSize = -1;
                BasicThreadPool pool = new BasicThreadPool("HTTP timeout");
                log.debug((Object)(this + " created new simulated timeout thread pool: " + pool));
                Object param = this.configuration.get(MAX_NUM_TIMEOUT_THREADS);
                if (param instanceof String) {
                    try {
                        maxNumberThreads = Integer.parseInt((String)param);
                    }
                    catch (NumberFormatException e) {
                        log.warn((Object)("maxNumberThreads parameter has invalid format: " + param));
                    }
                } else if (param != null) {
                    log.warn((Object)("maxNumberThreads parameter must be a string in integer format: " + param));
                }
                if ((param = this.configuration.get(MAX_TIMEOUT_QUEUE_SIZE)) instanceof String) {
                    try {
                        maxTimeoutQueueSize = Integer.parseInt((String)param);
                    }
                    catch (NumberFormatException e) {
                        log.warn((Object)("maxTimeoutQueueSize parameter has invalid format: " + param));
                    }
                } else if (param != null) {
                    log.warn((Object)("maxTimeoutQueueSize parameter must be a string in integer format: " + param));
                }
                pool.setMaximumPoolSize(maxNumberThreads);
                if (maxTimeoutQueueSize > 0) {
                    pool.setMaximumQueueSize(maxTimeoutQueueSize);
                }
                pool.setBlockingMode(BlockingMode.RUN);
                this.timeoutThreadPool = pool;
            }
        }
        return this.timeoutThreadPool;
    }

    static class WaitingTaskWrapper
    extends RunnableTaskWrapper {
        long completeTimeout;

        public WaitingTaskWrapper(Runnable runnable, long completeTimeout) {
            super(runnable, 0L, completeTimeout);
            this.completeTimeout = completeTimeout;
        }

        public int getTaskWaitType() {
            return 2;
        }

        public String toString() {
            return "WaitingTaskWrapper[" + this.completeTimeout + "]";
        }
    }
}

