/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.maven.plugins.qstools.checkers;

import java.util.List;
import java.util.Map;
import javax.xml.xpath.XPathConstants;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.jboss.maven.plugins.qstools.QSChecker;
import org.jboss.maven.plugins.qstools.Violation;
import org.jboss.maven.plugins.qstools.checkers.AbstractProjectChecker;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

@Component(role=QSChecker.class, hint="LicenseChecker")
public class LicenseChecker
extends AbstractProjectChecker {
    @Override
    public String getCheckerDescription() {
        return "Check if a POM.xml contains Apache License";
    }

    @Override
    public void processProject(MavenProject project, Document doc, Map<String, List<Violation>> results) throws Exception {
        Node licenseURL = (Node)this.getxPath().evaluate("/project/licenses/license/url", doc, XPathConstants.NODE);
        if (licenseURL == null || !licenseURL.getTextContent().contains("apache")) {
            this.addViolation(project.getFile(), results, 0, "File doesn't the 'Apache License, Version 2.0' license");
        }
    }
}

