/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.maven.plugins.qstools;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.List;
import java.util.Scanner;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.io.IOUtils;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.jboss.jdf.stacks.client.StacksClient;
import org.jboss.jdf.stacks.model.Bom;
import org.jboss.jdf.stacks.model.Stacks;
import org.jboss.maven.plugins.qstools.DependencyProvider;
import org.jboss.maven.plugins.qstools.maven.MavenDependency;
import org.jboss.maven.plugins.qstools.xml.PositionalXMLReader;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Mojo(name="updateBoms", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.COMPILE, requiresProject=true, threadSafe=true, aggregator=true)
public class BomUpdaterMojo
extends AbstractMojo {
    @Parameter(property="reactorProjects", readonly=true, required=true)
    private List<MavenProject> reactorProjects;
    @Parameter(property="qstools.stacks.url")
    private URL stacksUrl;
    @Component
    private DependencyProvider dependencyProvider;
    private XPath xPath = XPathFactory.newInstance().newXPath();
    private StacksClient stacksClient;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            this.stacksClient = new StacksClient();
            if (this.stacksUrl != null) {
                this.stacksClient.getActualConfiguration().setUrl(this.stacksUrl);
            }
            this.getLog().info((CharSequence)("Using the following Stacks YML file: " + this.stacksClient.getActualConfiguration().getUrl()));
            this.getLog().warn((CharSequence)"Running this plugin CAN MODIFY your pom.xml files. Make sure to have your changes commited before running this plugin");
            this.getLog().info((CharSequence)"Do you want to continue[yes/no]");
            String answer = new Scanner(System.in).nextLine();
            if (answer.equalsIgnoreCase("yes")) {
                for (MavenProject project : this.reactorProjects) {
                    this.processProject(project);
                }
            } else {
                this.getLog().info((CharSequence)"Aborted");
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    private void processProject(MavenProject project) throws Exception {
        Stacks stacks = this.stacksClient.getStacks();
        this.getLog().debug((CharSequence)("Processing " + project.getArtifactId()));
        Document doc = PositionalXMLReader.readXML(new FileInputStream(project.getFile()));
        NodeList dependencies = (NodeList)this.xPath.evaluate("/project/dependencyManagement/dependencies/dependency", doc, XPathConstants.NODESET);
        for (int x = 0; x < dependencies.getLength(); ++x) {
            Node dependency = dependencies.item(x);
            MavenDependency mavenDependency = this.dependencyProvider.getDependencyFromNode(project, dependency);
            Bom bomUsed = null;
            for (Bom bom : stacks.getAvailableBoms()) {
                if (!bom.getGroupId().equals(mavenDependency.getGroupId()) || !bom.getArtifactId().equals(mavenDependency.getArtifactId())) continue;
                bomUsed = bom;
            }
            if (bomUsed == null || mavenDependency.getInterpoledVersion().equals(bomUsed.getRecommendedVersion())) continue;
            this.getLog().debug((CharSequence)String.format("Project [%s] - Dependency [%s:%s:%s] isnt'using the recommended version [%s]", project.getArtifactId(), mavenDependency.getGroupId(), mavenDependency.getArtifactId(), mavenDependency.getInterpoledVersion(), bomUsed.getRecommendedVersion()));
            DefaultArtifactVersion recommendedVersion = new DefaultArtifactVersion(bomUsed.getRecommendedVersion());
            DefaultArtifactVersion usedVersion = new DefaultArtifactVersion(mavenDependency.getInterpoledVersion());
            if (recommendedVersion.compareTo((ArtifactVersion)usedVersion) > 0) {
                this.updateVersion(project.getFile(), mavenDependency.getInterpoledVersion(), bomUsed.getRecommendedVersion());
                continue;
            }
            this.getLog().warn((CharSequence)String.format("Project [%s] will not be updated because it uses a newer BOM [%s:%s:%s] version than the recommended [%s]", project.getArtifactId(), mavenDependency.getGroupId(), mavenDependency.getArtifactId(), mavenDependency.getInterpoledVersion(), bomUsed.getRecommendedVersion()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateVersion(File file, String usedVersion, String recommendedVersion) throws Exception {
        this.getLog().info((CharSequence)String.format("Updating from %s to %s in file %s", usedVersion, recommendedVersion, file));
        String content = IOUtils.toString((InputStream)new FileInputStream(file));
        content = content.replaceAll(usedVersion, recommendedVersion);
        FileOutputStream fos = new FileOutputStream(file);
        try {
            IOUtils.write((String)content, (OutputStream)new FileOutputStream(file));
        }
        finally {
            fos.close();
        }
    }
}

