/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.maven.plugins.qstools.common;

import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.jboss.maven.plugins.qstools.config.Rules;
import org.jboss.maven.plugins.qstools.xml.PositionalXMLReader;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Component(role=UnusedPropertiesUtil.class)
public class UnusedPropertiesUtil {
    protected XPath xPath = XPathFactory.newInstance().newXPath();
    private Set<String> usedProperties = new HashSet<String>();

    public List<PomInformation> findUnusedProperties(List<MavenProject> reactorProjects, Rules rules) throws Exception {
        ArrayList<PomInformation> unusedPropertyInfo = new ArrayList<PomInformation>();
        HashMap declaredProperties = new HashMap();
        for (MavenProject mavenProject : reactorProjects) {
            Document doc = PositionalXMLReader.readXML(new FileInputStream(mavenProject.getFile()));
            NodeList propertiesNodes = (NodeList)this.xPath.evaluate("/project/properties/*", doc, XPathConstants.NODESET);
            NodeList allNodes = (NodeList)this.xPath.evaluate("//*", doc, XPathConstants.NODESET);
            for (int x = 0; x < propertiesNodes.getLength(); ++x) {
                Node property = propertiesNodes.item(x);
                String propertyName = property.getNodeName();
                int lineNumber = (Integer)property.getUserData("beginLineNumber");
                PomInformation pi = new PomInformation(mavenProject, lineNumber, property.getNodeName());
                if (declaredProperties.get(propertyName) == null) {
                    declaredProperties.put(propertyName, new ArrayList());
                }
                ((List)declaredProperties.get(propertyName)).add(pi);
            }
            Pattern p = Pattern.compile("\\$\\{\\w+(.\\w+)*(-\\w+)*\\}");
            for (int x = 0; x < allNodes.getLength(); ++x) {
                Node node = allNodes.item(x);
                String nodeContent = node.getTextContent();
                if (!p.matcher(nodeContent).matches()) continue;
                String usedProperty = node.getTextContent().replaceAll("[${}]", "");
                this.usedProperties.add(usedProperty);
            }
        }
        for (String declared : declaredProperties.keySet()) {
            if (declared.startsWith("project") || rules.getIgnoredUnusedProperties().contains(declared) || this.usedProperties.contains(declared)) continue;
            unusedPropertyInfo.addAll((Collection)declaredProperties.get(declared));
        }
        return unusedPropertyInfo;
    }

    public class PomInformation {
        private MavenProject project;
        private int line;
        private String property;

        public PomInformation(MavenProject project, int line, String property) {
            this.project = project;
            this.line = line;
            this.property = property;
        }

        public MavenProject getProject() {
            return this.project;
        }

        public int getLine() {
            return this.line;
        }

        public String getProperty() {
            return this.property;
        }
    }
}

