/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager.handlers;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import org.jboss.logmanager.ExtLogRecord;
import org.jboss.logmanager.handlers.FileHandler;

public class SizeRotatingFileHandler
extends FileHandler {
    private long rotateSize = 655360L;
    private long currentSize;
    private int maxBackupIndex = 1;

    public SizeRotatingFileHandler() {
    }

    public SizeRotatingFileHandler(File file) throws FileNotFoundException {
        super(file);
    }

    public SizeRotatingFileHandler(File file, boolean append) throws FileNotFoundException {
        super(file, append);
    }

    public SizeRotatingFileHandler(String fileName) throws FileNotFoundException {
        super(fileName);
    }

    public SizeRotatingFileHandler(String fileName, boolean append) throws FileNotFoundException {
        super(fileName, append);
    }

    public SizeRotatingFileHandler(long rotateSize, int maxBackupIndex) {
        this.rotateSize = rotateSize;
        this.maxBackupIndex = maxBackupIndex;
    }

    public SizeRotatingFileHandler(File file, long rotateSize, int maxBackupIndex) throws FileNotFoundException {
        super(file);
        this.rotateSize = rotateSize;
        this.maxBackupIndex = maxBackupIndex;
    }

    public SizeRotatingFileHandler(File file, boolean append, long rotateSize, int maxBackupIndex) throws FileNotFoundException {
        super(file, append);
        this.rotateSize = rotateSize;
        this.maxBackupIndex = maxBackupIndex;
    }

    public void setOutputStream(OutputStream outputStream) {
        super.setOutputStream(outputStream == null ? null : new CountingOutputStream(outputStream));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFile(File file) throws FileNotFoundException {
        Object object = this.outputLock;
        synchronized (object) {
            super.setFile(file);
            this.currentSize = file == null ? 0L : file.length();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRotateSize(long rotateSize) {
        SizeRotatingFileHandler.checkAccess();
        Object object = this.outputLock;
        synchronized (object) {
            this.rotateSize = rotateSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxBackupIndex(int maxBackupIndex) {
        SizeRotatingFileHandler.checkAccess();
        Object object = this.outputLock;
        synchronized (object) {
            this.maxBackupIndex = maxBackupIndex;
        }
    }

    protected void preWrite(ExtLogRecord record) {
        int maxBackupIndex = this.maxBackupIndex;
        if (this.currentSize > this.rotateSize && maxBackupIndex > 0) {
            try {
                File file = this.getFile();
                if (file == null) {
                    return;
                }
                this.setFile(null);
                new File(file.getAbsolutePath() + "." + maxBackupIndex).delete();
                for (int i = maxBackupIndex - 1; i > 1; --i) {
                    new File(file.getAbsolutePath() + "." + i).renameTo(new File(file.getAbsolutePath() + "." + (i - 1)));
                }
                file.renameTo(new File(file.getAbsolutePath() + ".1"));
                this.setFile(file);
            }
            catch (FileNotFoundException e) {
                this.reportError("Unable to rotate log file", e, 4);
            }
        }
    }

    private final class CountingOutputStream
    extends OutputStream {
        private final OutputStream delegate;

        private CountingOutputStream(OutputStream delegate) {
            this.delegate = delegate;
        }

        public void write(int b) throws IOException {
            this.delegate.write(b);
            SizeRotatingFileHandler.this.currentSize++;
        }

        public void write(byte[] b) throws IOException {
            this.delegate.write(b);
            SizeRotatingFileHandler.this.currentSize += b.length;
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.delegate.write(b, off, len);
            SizeRotatingFileHandler.this.currentSize += len;
        }

        public void flush() throws IOException {
            this.delegate.flush();
        }

        public void close() throws IOException {
            this.delegate.close();
        }
    }
}

