/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.management.views;

import java.util.Collection;
import java.util.HashSet;
import org.jboss.deployers.client.spi.main.MainDeployer;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.management.KnownDeploymentTypes;
import org.jboss.logging.Logger;
import org.jboss.managed.api.DeploymentState;
import org.jboss.managed.api.ManagedDeployment;
import org.jboss.managed.plugins.ManagedDeploymentImpl;
import org.jboss.profileservice.management.ManagedOperationProxyFactory;
import org.jboss.profileservice.management.views.AbstractProfileView;
import org.jboss.profileservice.spi.Profile;
import org.jboss.profileservice.spi.ProfileDeployment;
import org.jboss.profileservice.spi.ProfileKey;
import org.jboss.system.server.profileservice.repository.AbstractProfileDeployment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProfileView
extends AbstractProfileView {
    private static final Logger log = Logger.getLogger(ProfileView.class);
    private final MainDeployer mainDeployer;
    private final ProfileKey key;
    private final long lastModified;

    public ProfileView(Profile profile, ManagedOperationProxyFactory proxyFactory, MainDeployer mainDeployer) {
        super(proxyFactory);
        if (profile == null) {
            throw new IllegalArgumentException("null profile");
        }
        if (profile.getKey() == null) {
            throw new IllegalArgumentException("null profile key");
        }
        if (mainDeployer == null) {
            throw new IllegalArgumentException("null main deployer");
        }
        this.key = profile.getKey();
        this.mainDeployer = mainDeployer;
        this.lastModified = profile.getLastModified();
        this.load(profile.getDeployments());
    }

    @Override
    public ProfileKey getProfileKey() {
        return this.key;
    }

    protected void load(Collection<ProfileDeployment> deployments) {
        if (deployments == null) {
            throw new IllegalArgumentException("null deployments.");
        }
        boolean trace = log.isTraceEnabled();
        for (ProfileDeployment deployment : deployments) {
            try {
                try {
                    ManagedDeployment md = this.mainDeployer.getManagedDeployment(deployment.getName());
                    this.processRootManagedDeployment(md, trace);
                    if (md.getTypes() == null || md.getTypes().isEmpty()) continue;
                    ((AbstractProfileDeployment)deployment).addTransientAttachment(KnownDeploymentTypes.class.getName(), (Object)md.getTypes());
                }
                catch (DeploymentException e) {
                    ManagedDeployment md = this.createStoppedManagedDeployment(deployment);
                    this.processManagedDeployment(md, DeploymentState.STOPPED, 0, trace);
                }
            }
            catch (Exception e) {
                log.debug((Object)("Failed to create ManagedDeployment for: " + deployment.getName()), (Throwable)e);
            }
        }
    }

    protected ManagedDeployment createStoppedManagedDeployment(ProfileDeployment deployment) {
        String deploymentName = deployment.getName();
        ManagedDeploymentImpl md = new ManagedDeploymentImpl(deploymentName, deployment.getRoot().getName());
        Collection deploymentTypes = (Collection)((AbstractProfileDeployment)deployment).getTransientAttachment(KnownDeploymentTypes.class.getName(), Collection.class);
        if (deploymentTypes != null && !deploymentTypes.isEmpty()) {
            md.setTypes(new HashSet(deploymentTypes));
        } else {
            int i = deploymentName.lastIndexOf(".");
            if (i != -1 && i + 1 < deploymentName.length()) {
                String guessedType = deploymentName.substring(i + 1, deploymentName.length());
                if (guessedType.endsWith("/")) {
                    guessedType = guessedType.substring(0, guessedType.length() - 1);
                }
                md.setTypes(new HashSet(1));
                md.addType(guessedType);
            }
        }
        return md;
    }

    @Override
    protected void processManagedDeployment(ManagedDeployment md, DeploymentState state, int level, boolean trace) throws Exception {
        super.processManagedDeployment(md, state, level, trace);
        md.setAttachment(ProfileKey.class.getName(), (Object)this.getProfileKey());
    }

    @Override
    public boolean hasBeenModified(Profile profile) {
        if (profile == null) {
            throw new IllegalArgumentException("null profile.");
        }
        return this.lastModified < profile.getLastModified();
    }
}

