/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.management.upload;

import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.jboss.deployers.spi.management.deploy.DeploymentID;
import org.jboss.profileservice.spi.DeploymentOption;
import org.jboss.profileservice.spi.ProfileKey;

public class SerializableDeploymentID
implements DeploymentID,
Serializable {
    private static final long serialVersionUID = 1L;
    private transient InputStream contentIS;
    private Set<DeploymentOption> options;
    private String[] deploymentNames;
    private String[] repositoryNames;
    private ProfileKey profileKey;
    private String description;
    private URL contentURL;
    private boolean copyContent;

    public SerializableDeploymentID(DeploymentID deployment) {
        this(deployment.getNames(), deployment.getProfile(), deployment.getDescription());
    }

    public SerializableDeploymentID(String name, ProfileKey profileKey, String description) {
        this(new String[]{name}, profileKey, description);
    }

    public SerializableDeploymentID(String[] names, ProfileKey profileKey, String description) {
        this.deploymentNames = names;
        this.profileKey = profileKey;
        this.description = description;
        this.copyContent = true;
        this.options = new HashSet<DeploymentOption>();
    }

    public String[] getNames() {
        return this.deploymentNames;
    }

    public String[] getRepositoryNames() {
        if (this.repositoryNames == null) {
            this.repositoryNames = this.deploymentNames;
        }
        return this.repositoryNames;
    }

    public void setRepositoryNames(String[] names) {
        this.repositoryNames = names;
    }

    public ProfileKey getProfile() {
        return this.profileKey;
    }

    public String getDescription() {
        return this.description;
    }

    public URL getContentURL() {
        return this.contentURL;
    }

    public void setContentURL(URL contentURL) {
        this.contentURL = contentURL;
    }

    public boolean isCopyContent() {
        return this.copyContent;
    }

    public void setCopyContent(boolean copyContent) {
        this.copyContent = copyContent;
    }

    public InputStream getContentIS() {
        return this.contentIS;
    }

    public void setContentIS(InputStream contentIS) {
        this.contentIS = contentIS;
    }

    public void addDeploymentOption(DeploymentOption option) {
        if (option == null) {
            throw new IllegalArgumentException("null option");
        }
        this.options.add(option);
    }

    public DeploymentOption[] getDeploymentOptions() {
        return this.options.toArray(new DeploymentOption[this.options.size()]);
    }

    public boolean hasDeploymentOption(DeploymentOption option) {
        if (option == null) {
            throw new IllegalArgumentException("null option");
        }
        return this.options.contains(option);
    }

    public boolean removeDeploymentOption(DeploymentOption option) {
        return this.options.remove(option);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("names=").append(Arrays.toString(this.getNames()));
        if (this.getRepositoryNames() != this.getNames()) {
            buffer.append(", repositoryNames=").append(Arrays.toString(this.getRepositoryNames()));
        }
        buffer.append(", copyContent=").append(this.copyContent);
        if (this.description != null) {
            buffer.append(", description=").append(this.description);
        }
        return buffer.toString();
    }
}

