/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.management;

import java.lang.reflect.UndeclaredThrowableException;
import java.util.Arrays;
import javax.management.Attribute;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.deployers.spi.management.ContextStateMapper;
import org.jboss.managed.api.ManagedOperation;
import org.jboss.managed.api.ManagedParameter;
import org.jboss.managed.api.ManagedProperty;
import org.jboss.metatype.api.values.EnumValueSupport;
import org.jboss.metatype.api.values.MetaValue;
import org.jboss.metatype.api.values.MetaValueFactory;
import org.jboss.metatype.spi.values.MetaMapper;
import org.jboss.profileservice.management.AbstractRuntimeComponentDispatcher;
import org.jboss.profileservice.spi.types.ControllerStateMetaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MBeanRuntimeComponentDispatcher
extends AbstractRuntimeComponentDispatcher {
    private final MBeanServer mbeanServer;

    public MBeanRuntimeComponentDispatcher(MBeanServer mbeanServer) {
        this(mbeanServer, null);
    }

    public MBeanRuntimeComponentDispatcher(MBeanServer mbeanServer, MetaValueFactory valueFactory) {
        super(valueFactory);
        if (mbeanServer == null) {
            throw new IllegalArgumentException("Null MBean Server");
        }
        this.mbeanServer = mbeanServer;
    }

    public void start() {
    }

    public MetaValue get(Object componentName, String propertyName) {
        ManagedProperty prop = AbstractRuntimeComponentDispatcher.getActiveProperty();
        if (propertyName.equals("state") && prop.getMetaType().equals(ControllerStateMetaType.TYPE)) {
            String stateString = this.getState(componentName);
            EnumValueSupport state = new EnumValueSupport(ControllerStateMetaType.TYPE, stateString);
            return state;
        }
        try {
            Object value = this.mbeanServer.getAttribute(new ObjectName(componentName.toString()), propertyName);
            MetaValue mvalue = null;
            if (value != null) {
                MetaMapper mapper;
                mvalue = prop != null ? ((mapper = (MetaMapper)prop.getTransientAttachment(MetaMapper.class)) != null ? mapper.createMetaValue(prop.getMetaType(), value) : this.create(value)) : this.create(value);
            }
            return mvalue;
        }
        catch (Throwable t) {
            throw new UndeclaredThrowableException(t, "Failed to get property '" + propertyName + "' on component '" + componentName + "'.");
        }
    }

    public void set(Object componentName, String propertyName, MetaValue value) {
        try {
            MetaMapper mapper;
            ManagedProperty prop = AbstractRuntimeComponentDispatcher.getActiveProperty();
            Object uvalue = null;
            uvalue = prop != null ? ((mapper = (MetaMapper)prop.getTransientAttachment(MetaMapper.class)) != null ? mapper.unwrapMetaValue(value) : this.unwrap(value)) : this.unwrap(value);
            this.mbeanServer.setAttribute(new ObjectName(componentName.toString()), new Attribute(propertyName, uvalue));
        }
        catch (Throwable t) {
            throw new UndeclaredThrowableException(t, "Failed to set property '" + propertyName + "' on component '" + componentName + "' to value [" + value + "].");
        }
    }

    public Object invoke(Object componentName, String methodName, MetaValue ... param) {
        try {
            ManagedOperation op = AbstractRuntimeComponentDispatcher.getActiveOperation();
            String[] sig = new String[param.length];
            Object[] args = new Object[param.length];
            if (op != null) {
                ManagedParameter[] params = op.getParameters();
                if (params != null && params.length == param.length) {
                    for (int i = 0; i < param.length; ++i) {
                        ManagedParameter mp = params[i];
                        MetaMapper mapper = (MetaMapper)mp.getTransientAttachment(MetaMapper.class);
                        args[i] = mapper != null ? mapper.unwrapMetaValue(param[i]) : this.unwrap(param[i]);
                        sig[i] = mp.getMetaType().getTypeName();
                    }
                } else {
                    args = this.toArguments(param);
                    sig = MBeanRuntimeComponentDispatcher.toSignature(param);
                }
            } else {
                args = this.toArguments(param);
                sig = MBeanRuntimeComponentDispatcher.toSignature(param);
            }
            Object value = this.mbeanServer.invoke(new ObjectName(componentName.toString()), methodName, args, sig);
            MetaValue mvalue = null;
            if (value != null) {
                MetaMapper returnTypeMapper = (MetaMapper)op.getTransientAttachment(MetaMapper.class);
                mvalue = returnTypeMapper != null ? returnTypeMapper.createMetaValue(op.getReturnType(), value) : this.create(value);
            }
            return mvalue;
        }
        catch (Throwable t) {
            throw new UndeclaredThrowableException(t, "Failed to invoke method '" + methodName + "' on component '" + componentName + "' with parameters " + Arrays.asList(param) + ".");
        }
    }

    @Override
    public String getState(Object name) {
        try {
            if (this.mbeanServer.isRegistered(new ObjectName(name.toString()))) {
                return ControllerState.INSTALLED.getStateString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ControllerState.NOT_INSTALLED.getStateString();
    }

    @Override
    public <T extends Enum<?>> T mapControllerState(Object name, ContextStateMapper<T> mapper) {
        if (name == null) {
            throw new IllegalArgumentException("null name");
        }
        if (mapper == null) {
            throw new IllegalArgumentException("null mapper");
        }
        ControllerState current = ControllerState.NOT_INSTALLED;
        try {
            if (this.mbeanServer.isRegistered(new ObjectName(name.toString()))) {
                current = ControllerState.INSTALLED;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return (T)mapper.map(current, ControllerState.INSTALLED);
    }
}

