/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.server.ServerMessages;
import org.jboss.as.server.deployment.DeploymentHandlerUtil;
import org.jboss.dmr.ModelNode;

abstract class AbstractDeploymentHandler {
    protected static final List<String> CONTENT_ADDITION_PARAMETERS = Arrays.asList("input-stream-index", "bytes", "url");

    AbstractDeploymentHandler() {
    }

    protected static String asString(ModelNode node, String name) {
        return node.has(name) ? node.require(name).asString() : null;
    }

    protected static OperationFailedException createFailureException(String msg) {
        return new OperationFailedException(new ModelNode(msg));
    }

    protected static OperationFailedException createFailureException(Throwable cause, String msg) {
        return new OperationFailedException(cause, new ModelNode(msg));
    }

    protected static DeploymentHandlerUtil.ContentItem[] getContents(ModelNode contentNode) {
        List nodes = contentNode.asList();
        DeploymentHandlerUtil.ContentItem[] contents = new DeploymentHandlerUtil.ContentItem[nodes.size()];
        for (int i = 0; i < contents.length; ++i) {
            ModelNode node = (ModelNode)nodes.get(i);
            contents[i] = node.has("hash") ? new DeploymentHandlerUtil.ContentItem(node.require("hash").asBytes()) : new DeploymentHandlerUtil.ContentItem(node.require("path").asString(), AbstractDeploymentHandler.asString(node, "relative-to"), node.require("archive").asBoolean());
        }
        return contents;
    }

    protected static InputStream getInputStream(OperationContext context, ModelNode operation) throws OperationFailedException {
        InputStream in = null;
        if (operation.hasDefined("input-stream-index")) {
            int maxIndex;
            int streamIndex = operation.get("input-stream-index").asInt();
            if (streamIndex > (maxIndex = context.getAttachmentStreamCount())) {
                throw ServerMessages.MESSAGES.invalidStreamIndex("input-stream-index", streamIndex, maxIndex);
            }
            in = context.getAttachmentStream(streamIndex);
        } else {
            if (operation.hasDefined("bytes")) {
                try {
                    in = new ByteArrayInputStream(operation.get("bytes").asBytes());
                }
                catch (IllegalArgumentException iae) {
                    throw ServerMessages.MESSAGES.invalidStreamBytes("bytes");
                }
            }
            if (operation.hasDefined("url")) {
                String urlSpec = operation.get("url").asString();
                try {
                    in = new URL(urlSpec).openStream();
                }
                catch (MalformedURLException e) {
                    throw ServerMessages.MESSAGES.invalidStreamURL(e, urlSpec);
                }
                catch (IOException e) {
                    throw ServerMessages.MESSAGES.invalidStreamURL(e, urlSpec);
                }
            }
        }
        if (in == null) {
            throw new IllegalStateException();
        }
        return in;
    }

    protected static boolean hasValidContentAdditionParameterDefined(ModelNode operation) {
        for (String s : CONTENT_ADDITION_PARAMETERS) {
            if (!operation.hasDefined(s)) continue;
            return true;
        }
        return false;
    }

    protected static void validateOnePieceOfContent(ModelNode content) throws OperationFailedException {
        if (content.asList().size() != 1) {
            throw ServerMessages.MESSAGES.multipleContentItemsNotSupported();
        }
    }
}

