/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import org.jboss.as.domain.management.AuthenticationMechanism;
import org.jboss.as.domain.management.DomainManagementMessages;
import org.jboss.as.domain.management.security.CallbackHandlerService;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;

class LocalCallbackHandlerService
implements Service<CallbackHandlerService>,
CallbackHandlerService,
CallbackHandler {
    public static final String SERVICE_SUFFIX = "local";
    private final String defaultUser;
    private final String allowedUsers;
    private boolean allowAll;
    private final Set<String> allowedUsersSet = new HashSet<String>();

    LocalCallbackHandlerService(String defaultUser, String allowedUsers) {
        this.defaultUser = defaultUser;
        this.allowedUsers = allowedUsers;
    }

    @Override
    public AuthenticationMechanism getPreferredMechanism() {
        return AuthenticationMechanism.LOCAL;
    }

    @Override
    public Set<AuthenticationMechanism> getSupplementaryMechanisms() {
        return Collections.emptySet();
    }

    @Override
    public Map<String, String> getConfigurationOptions() {
        if (this.defaultUser != null) {
            return Collections.singletonMap("org.jboss.as.domain.management.local.default_user", this.defaultUser);
        }
        return Collections.emptyMap();
    }

    @Override
    public boolean isReady() {
        return true;
    }

    @Override
    public CallbackHandler getCallbackHandler(Map<String, Object> sharedState) {
        return this;
    }

    public CallbackHandlerService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public void start(StartContext context) throws StartException {
        if (this.defaultUser != null) {
            this.allowedUsersSet.add(this.defaultUser);
        }
        if (this.allowedUsers != null) {
            if ("*".equals(this.allowedUsers)) {
                this.allowAll = true;
            } else {
                String[] users;
                for (String current : users = this.allowedUsers.split(",")) {
                    this.allowedUsersSet.add(current);
                }
            }
        }
    }

    public void stop(StopContext context) {
        this.allowAll = false;
        this.allowedUsersSet.clear();
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (Callback current : callbacks) {
            if (current instanceof NameCallback) {
                NameCallback ncb = (NameCallback)current;
                String userName = ncb.getDefaultName();
                if (this.allowAll || this.allowedUsersSet.contains(userName)) continue;
                throw DomainManagementMessages.MESSAGES.invalidLocalUser(userName);
            }
            if (current instanceof AuthorizeCallback) {
                AuthorizeCallback acb = (AuthorizeCallback)current;
                acb.setAuthorized(acb.getAuthenticationID().equals(acb.getAuthorizationID()));
                continue;
            }
            throw new UnsupportedCallbackException(current);
        }
    }
}

