/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.service;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Observable;
import java.util.Observer;
import java.util.concurrent.atomic.AtomicLong;
import java.util.jar.Manifest;
import org.jboss.as.osgi.OSGiLogger;
import org.jboss.as.osgi.OSGiMessages;
import org.jboss.as.osgi.parser.SubsystemState;
import org.jboss.as.osgi.service.ModuleIdentityArtifactProvider;
import org.jboss.as.osgi.service.RepositoryProvider;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.as.server.ServerEnvironmentService;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.service.AbstractService;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.deployment.deployer.DeploymentFactory;
import org.jboss.osgi.framework.AutoInstallProvider;
import org.jboss.osgi.framework.BundleManagerService;
import org.jboss.osgi.framework.Services;
import org.jboss.osgi.metadata.OSGiMetaData;
import org.jboss.osgi.metadata.OSGiMetaDataBuilder;
import org.jboss.osgi.resolver.v2.MavenCoordinates;
import org.jboss.osgi.resolver.v2.XIdentityCapability;
import org.jboss.osgi.resolver.v2.XRequirementBuilder;
import org.jboss.osgi.spi.BundleInfo;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.resource.Requirement;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.service.repository.Repository;
import org.osgi.service.startlevel.StartLevel;

class AutoInstallIntegration
extends AbstractService<AutoInstallProvider>
implements AutoInstallProvider,
Observer {
    final InjectedValue<BundleManagerService> injectedBundleManager = new InjectedValue();
    final InjectedValue<ServerEnvironment> injectedEnvironment = new InjectedValue();
    final InjectedValue<Repository> injectedRepository = new InjectedValue();
    final InjectedValue<Bundle> injectedSystemBundle = new InjectedValue();
    final InjectedValue<PackageAdmin> injectedPackageAdmin = new InjectedValue();
    final InjectedValue<StartLevel> injectedStartLevel = new InjectedValue();
    final InjectedValue<SubsystemState> injectedSubsystemState = new InjectedValue();
    ServiceController<?> serviceController;
    private File bundlesDir;
    private ServiceTarget serviceTarget;
    private final AtomicLong updateServiceIdCounter = new AtomicLong();

    static ServiceController<?> addService(ServiceTarget target) {
        AutoInstallIntegration service = new AutoInstallIntegration();
        ServiceBuilder builder = target.addService(Services.AUTOINSTALL_PROVIDER, (Service)service);
        builder.addDependency(ServerEnvironmentService.SERVICE_NAME, ServerEnvironment.class, service.injectedEnvironment);
        builder.addDependency(SubsystemState.SERVICE_NAME, SubsystemState.class, service.injectedSubsystemState);
        builder.addDependency(RepositoryProvider.SERVICE_NAME, Repository.class, service.injectedRepository);
        builder.addDependency(Services.BUNDLE_MANAGER, BundleManagerService.class, service.injectedBundleManager);
        builder.addDependency(Services.PACKAGE_ADMIN, PackageAdmin.class, service.injectedPackageAdmin);
        builder.addDependency(Services.SYSTEM_BUNDLE, Bundle.class, service.injectedSystemBundle);
        builder.addDependency(Services.START_LEVEL, StartLevel.class, service.injectedStartLevel);
        builder.addDependency(Services.FRAMEWORK_INIT);
        builder.setInitialMode(ServiceController.Mode.ON_DEMAND);
        return builder.install();
    }

    AutoInstallIntegration() {
    }

    public synchronized void start(StartContext context) throws StartException {
        this.serviceController = context.getController();
        OSGiLogger.ROOT_LOGGER.debugf("Starting: %s in mode %s", this.serviceController.getName(), this.serviceController.getMode());
        final LinkedHashMap<ServiceName, SubsystemState.OSGiCapability> installedServices = new LinkedHashMap<ServiceName, SubsystemState.OSGiCapability>();
        final LinkedHashSet<ServiceName> resolvableServices = new LinkedHashSet<ServiceName>();
        BundleContext syscontext = ((Bundle)this.injectedSystemBundle.getValue()).getBundleContext();
        String slstr = syscontext.getProperty("org.osgi.framework.startlevel.beginning");
        Integer beginningStartLevel = Integer.parseInt(slstr != null ? slstr : "1");
        try {
            BundleManagerService bundleManager = (BundleManagerService)this.injectedBundleManager.getValue();
            final ServiceContainer serviceContainer = this.serviceController.getServiceContainer();
            this.serviceTarget = context.getChildTarget();
            ServerEnvironment serverEnvironment = (ServerEnvironment)this.injectedEnvironment.getValue();
            this.bundlesDir = serverEnvironment.getBundlesDir();
            if (!this.bundlesDir.isDirectory()) {
                throw OSGiMessages.MESSAGES.cannotFindBundleDir(this.bundlesDir);
            }
            ((SubsystemState)this.injectedSubsystemState.getValue()).addObserver(this);
            ArrayList<SubsystemState.OSGiCapability> configcaps = new ArrayList<SubsystemState.OSGiCapability>();
            configcaps.add(new SubsystemState.OSGiCapability("org.osgi.enterprise", null));
            configcaps.addAll(((SubsystemState)this.injectedSubsystemState.getValue()).getCapabilities());
            for (SubsystemState.OSGiCapability moduleMetaData : configcaps) {
                ServiceName serviceName = this.installModule(bundleManager, moduleMetaData);
                if (serviceName == null) continue;
                installedServices.put(serviceName, moduleMetaData);
                if (moduleMetaData.getStartLevel() > beginningStartLevel) continue;
                resolvableServices.add(serviceName);
            }
            ServiceBuilder builder = this.serviceTarget.addService(Services.AUTOINSTALL_PROVIDER_COMPLETE, (Service)new AbstractService<Void>(){

                public void start(StartContext context) throws StartException {
                    LinkedHashSet<Bundle> resolvableBundles = new LinkedHashSet<Bundle>();
                    for (ServiceName serviceName : resolvableServices) {
                        ServiceController requiredService = serviceContainer.getRequiredService(serviceName);
                        resolvableBundles.add((Bundle)requiredService.getValue());
                    }
                    Bundle[] bundleArr = resolvableBundles.toArray(new Bundle[resolvableBundles.size()]);
                    PackageAdmin packageAdmin = (PackageAdmin)AutoInstallIntegration.this.injectedPackageAdmin.getValue();
                    packageAdmin.resolveBundles(bundleArr);
                    for (ServiceName serviceName : resolvableServices) {
                        SubsystemState.OSGiCapability moduleMetaData = (SubsystemState.OSGiCapability)installedServices.get(serviceName);
                        AutoInstallIntegration.this.startBundle(serviceContainer, serviceName, moduleMetaData);
                    }
                    OSGiLogger.ROOT_LOGGER.debugf("Auto bundles bundles started", new Object[0]);
                }
            });
            ServiceName[] serviceNameArray = resolvableServices.toArray(new ServiceName[resolvableServices.size()]);
            builder.addDependencies(serviceNameArray);
            builder.install();
        }
        catch (Exception ex) {
            throw new StartException(OSGiMessages.MESSAGES.failedToCreateAutoInstallList(), (Throwable)ex);
        }
    }

    ServiceName installModule(BundleManagerService bundleManager, SubsystemState.OSGiCapability moduleMetaData) throws Exception {
        MavenCoordinates mavenId;
        Requirement req;
        Repository repository;
        Collection caps;
        String identifier = moduleMetaData.getIdentifier();
        Integer startLevel = moduleMetaData.getStartLevel();
        if (this.isValidModuleIdentifier(identifier)) {
            ModuleIdentifier moduleId = ModuleIdentifier.fromString((String)identifier);
            File bundleFile = ModuleIdentityArtifactProvider.getRepositoryEntry(this.bundlesDir, moduleId);
            if (bundleFile != null) {
                URL bundleURL = bundleFile.toURI().toURL();
                return this.installBundleFromURL(bundleManager, bundleURL, startLevel);
            }
            try {
                ModuleLoader moduleLoader = Module.getBootModuleLoader();
                Module module = moduleLoader.loadModule(moduleId);
                OSGiMetaData metadata = this.getModuleMetadata(module);
                return bundleManager.registerModule(this.serviceTarget, module, metadata);
            }
            catch (ModuleLoadException e) {
                OSGiLogger.ROOT_LOGGER.debugf("Cannot load module: %s", moduleId);
            }
        }
        if (this.isValidMavenIdentifier(identifier) && !(caps = (repository = (Repository)this.injectedRepository.getValue()).findProviders(req = XRequirementBuilder.createArtifactRequirement((MavenCoordinates)(mavenId = MavenCoordinates.parse((String)identifier))))).isEmpty()) {
            XIdentityCapability icap = (XIdentityCapability)caps.iterator().next();
            URL bundleURL = (URL)icap.getAttribute("content.url");
            return this.installBundleFromURL(bundleManager, bundleURL, startLevel);
        }
        OSGiLogger.ROOT_LOGGER.cannotResolveCapability(identifier);
        return null;
    }

    private boolean isValidModuleIdentifier(String identifier) {
        try {
            ModuleIdentifier.fromString((String)identifier);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    private boolean isValidMavenIdentifier(String identifier) {
        try {
            MavenCoordinates.parse((String)identifier);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    private ServiceName installBundleFromURL(BundleManagerService bundleManager, URL bundleURL, Integer startLevel) throws Exception {
        BundleInfo info = BundleInfo.createBundleInfo((URL)bundleURL);
        Deployment dep = DeploymentFactory.createDeployment((BundleInfo)info);
        if (startLevel != null) {
            dep.setStartLevel(Integer.valueOf(startLevel));
        }
        return bundleManager.installBundle(this.serviceTarget, dep);
    }

    void startBundle(ServiceContainer serviceContainer, ServiceName serviceName, SubsystemState.OSGiCapability moduleMetaData) {
        ServiceController controller = serviceContainer.getRequiredService(serviceName);
        Bundle bundle2 = (Bundle)controller.getValue();
        StartLevel startLevel = (StartLevel)this.injectedStartLevel.getValue();
        startLevel.setBundleStartLevel(bundle2, moduleMetaData.getStartLevel().intValue());
        try {
            bundle2.start();
        }
        catch (BundleException ex) {
            OSGiLogger.ROOT_LOGGER.cannotStart(ex, bundle2);
        }
    }

    public synchronized AutoInstallIntegration getValue() throws IllegalStateException {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OSGiMetaData getModuleMetadata(Module module) throws IOException {
        URL manifestURL = module.getClassLoader().getResource("META-INF/MANIFEST.MF");
        if (manifestURL != null) {
            InputStream input = manifestURL.openStream();
            try {
                Manifest manifest = new Manifest(input);
                if (BundleInfo.isValidBundleManifest((Manifest)manifest)) {
                    OSGiMetaData oSGiMetaData = OSGiMetaDataBuilder.load((Manifest)manifest);
                    return oSGiMetaData;
                }
            }
            finally {
                input.close();
            }
        }
        File modulesDir = ((ServerEnvironment)this.injectedEnvironment.getValue()).getModulesDir();
        ModuleIdentifier identifier = module.getIdentifier();
        String identifierPath = identifier.getName().replace('.', File.separatorChar) + File.separator + identifier.getSlot();
        File entryFile = new File(modulesDir + File.separator + identifierPath + File.separator + "jbosgi-xservice.properties");
        if (!entryFile.exists()) {
            OSGiLogger.ROOT_LOGGER.debugf("Cannot obtain OSGi metadata file: %s", entryFile);
            return null;
        }
        FileInputStream input = new FileInputStream(entryFile);
        try {
            OSGiMetaData oSGiMetaData = OSGiMetaDataBuilder.load((InputStream)input);
            return oSGiMetaData;
        }
        finally {
            input.close();
        }
    }

    @Override
    public void update(Observable o, Object arg) {
        if (!(arg instanceof SubsystemState.ChangeEvent)) {
            return;
        }
        SubsystemState.ChangeEvent event = (SubsystemState.ChangeEvent)arg;
        if (event.getType() != SubsystemState.ChangeType.CAPABILITY) {
            return;
        }
        if (!event.isRemoved()) {
            try {
                for (final SubsystemState.OSGiCapability module : ((SubsystemState)this.injectedSubsystemState.getValue()).getCapabilities()) {
                    if (!module.getIdentifier().toString().equals(event.getId())) continue;
                    final ServiceName serviceName = this.installModule((BundleManagerService)this.injectedBundleManager.getValue(), module);
                    if (serviceName != null) {
                        ServiceBuilder builder = this.serviceController.getServiceContainer().addService(ServiceName.of((ServiceName)Services.AUTOINSTALL_PROVIDER, (String[])new String[]{"ModuleUpdater", "" + this.updateServiceIdCounter.incrementAndGet()}), (Service)new AbstractService<Void>(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void start(StartContext context) throws StartException {
                                try {
                                    AutoInstallIntegration.this.startBundle(AutoInstallIntegration.this.serviceController.getServiceContainer(), serviceName, module);
                                }
                                finally {
                                    context.getController().setMode(ServiceController.Mode.REMOVE);
                                }
                            }
                        });
                        builder.addDependency(serviceName);
                        builder.install();
                    }
                    return;
                }
            }
            catch (Exception e) {
                OSGiLogger.ROOT_LOGGER.errorAddingModule(e, event.getId());
                return;
            }
            OSGiLogger.ROOT_LOGGER.moduleNotFound(event.getId());
        }
    }
}

