/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.extensions.xop;

import java.awt.Image;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.ResourceBundle;
import javax.activation.DataHandler;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.Source;
import org.jboss.logging.Logger;
import org.jboss.ws.WSException;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.ws.common.Constants;
import org.jboss.ws.common.DOMUtils;
import org.jboss.ws.common.JavaUtils;
import org.jboss.ws.core.CommonMessageContext;
import org.jboss.ws.core.MessageAbstraction;
import org.jboss.ws.core.soap.MessageContextAssociation;
import org.jboss.ws.core.soap.SOAPElementImpl;
import org.jboss.ws.core.soap.SOAPMessageImpl;
import org.jboss.ws.core.utils.MimeUtils;
import org.jboss.ws.extensions.xop.CreateAttachmentVisitor;
import org.jboss.ws.extensions.xop.RestoreXOPElementVisitor;
import org.jboss.ws.extensions.xop.jaxrpc.XOPMarshallerImpl;
import org.jboss.xb.binding.SimpleTypeBindings;
import org.jboss.xb.binding.sunday.xop.XOPObject;
import org.w3c.dom.Node;

public class XOPContext {
    private static final ResourceBundle bundle = BundleUtils.getBundle(XOPContext.class);
    private static final Logger log = Logger.getLogger(XOPContext.class);
    private static final String NS_XOP_JBOSSWS = "http://org.jboss.ws/xop";
    private static final String NS_XOP_JBOSSWS_CONTENT_TYPE = "http://org.jboss.ws/xop:content-type";

    public static boolean isXOPMessage() {
        boolean isXOP = false;
        CommonMessageContext msgContext = MessageContextAssociation.peekMessageContext();
        if (msgContext != null) {
            SOAPMessageImpl soapMessage = (SOAPMessageImpl)msgContext.getSOAPMessage();
            isXOP = soapMessage != null && soapMessage.isXOPMessage();
        }
        return isXOP;
    }

    public static boolean isSWARefMessage() {
        boolean isSWARef = false;
        CommonMessageContext msgContext = MessageContextAssociation.peekMessageContext();
        if (msgContext != null) {
            SOAPMessageImpl soapMessage = (SOAPMessageImpl)msgContext.getSOAPMessage();
            isSWARef = soapMessage != null && soapMessage.isSWARefMessage();
        }
        return isSWARef;
    }

    public static boolean isXOPEncodedRequest() {
        MessageAbstraction message;
        String[] contentType;
        boolean isMultippartXOP = false;
        CommonMessageContext msgContext = MessageContextAssociation.peekMessageContext();
        if (msgContext != null && (contentType = (message = msgContext.getMessageAbstraction()).getMimeHeaders().getHeader("content-type")) != null) {
            for (String value : contentType) {
                if (value.indexOf("application/xop+xml") == -1) continue;
                isMultippartXOP = true;
                break;
            }
        }
        return isMultippartXOP;
    }

    public static boolean isMTOMEnabled() {
        CommonMessageContext msgContext = MessageContextAssociation.peekMessageContext();
        Boolean mtomEnabled = (Boolean)msgContext.get("org.jboss.ws.mtom.enabled");
        return Boolean.TRUE.equals(mtomEnabled);
    }

    public static void setMTOMEnabled(boolean b) {
        CommonMessageContext msgContext = MessageContextAssociation.peekMessageContext();
        msgContext.put("org.jboss.ws.mtom.enabled", (Object)b);
    }

    public static void inlineXOPData(SOAPElement xopElement) {
        String ns = xopElement.getNamespaceURI() != null ? xopElement.getNamespaceURI() : "";
        String localName = xopElement.getLocalName();
        if (ns.equals("http://www.w3.org/2004/08/xop/include") && localName.equals("Include")) {
            XOPContext.replaceXOPInclude(xopElement.getParentElement(), xopElement);
        } else {
            Iterator it = DOMUtils.getChildElements((Node)xopElement);
            while (it.hasNext()) {
                SOAPElement childElement = (SOAPElement)it.next();
                String childNS = childElement.getNamespaceURI() != null ? childElement.getNamespaceURI() : "";
                String childName = childElement.getLocalName();
                if (childNS.equals("http://www.w3.org/2004/08/xop/include") && childName.equals("Include")) {
                    XOPContext.replaceXOPInclude(xopElement, childElement);
                    continue;
                }
                XOPContext.inlineXOPData(childElement);
            }
        }
    }

    private static void setXOPMessage(boolean isXOPMessage) {
        CommonMessageContext msgContext = MessageContextAssociation.peekMessageContext();
        SOAPMessageImpl soapMsg = (SOAPMessageImpl)msgContext.getSOAPMessage();
        soapMsg.setXOPMessage(isXOPMessage);
    }

    public static void eagerlyCreateAttachments() {
        if (!XOPContext.isXOPMessage() && !XOPContext.isSWARefMessage()) {
            return;
        }
        try {
            SOAPBody body;
            CommonMessageContext msgContext = MessageContextAssociation.peekMessageContext();
            SOAPMessage soapMessage = msgContext != null ? msgContext.getSOAPMessage() : null;
            SOAPBody sOAPBody = body = soapMessage != null ? soapMessage.getSOAPBody() : null;
            if (body != null) {
                CreateAttachmentVisitor visitor = new CreateAttachmentVisitor();
                visitor.visitXOPElements((SOAPElementImpl)body);
            }
        }
        catch (SOAPException e) {
            throw new WSException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"FAILED_TO_EAGERLY_CREATE_XOP_ATTACHMENTS", (Object[])new Object[0]), e);
        }
    }

    public static void visitAndRestoreXOPData() {
        try {
            if (!XOPContext.isXOPMessage() && XOPContext.isMTOMEnabled()) {
                CommonMessageContext msgContext = MessageContextAssociation.peekMessageContext();
                SOAPBody body = msgContext.getSOAPMessage().getSOAPBody();
                RestoreXOPElementVisitor visitor = new RestoreXOPElementVisitor();
                visitor.visitXOPElements((SOAPElementImpl)body);
            }
        }
        catch (SOAPException e) {
            throw new WSException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"FAILED_TO_RESTORE_XOP_DATA", (Object[])new Object[0]), e);
        }
    }

    public static void restoreXOPDataDOM(SOAPElement xopElement) {
        String contentType = (String)xopElement.getUserData(NS_XOP_JBOSSWS_CONTENT_TYPE);
        if (contentType != null && contentType.length() > 0) {
            XOPContext.replaceBase64Representation(xopElement, contentType);
            xopElement.setUserData(NS_XOP_JBOSSWS_CONTENT_TYPE, null, null);
        } else {
            Iterator it = DOMUtils.getChildElements((Node)xopElement);
            while (it.hasNext()) {
                SOAPElement childElement = (SOAPElement)it.next();
                XOPContext.restoreXOPDataDOM(childElement);
            }
        }
    }

    private static void replaceBase64Representation(SOAPElement xopElement, String contentType) {
        SOAPElement parentElement = xopElement.getParentElement();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Replace base64 representation on element [xmlName=" + parentElement.getLocalName() + "]"));
        }
        String base64 = xopElement.getValue();
        byte[] data = SimpleTypeBindings.unmarshalBase64((String)base64);
        MimeUtils.ByteArrayConverter converter = MimeUtils.getConverterForContentType(contentType);
        Object converted = converter.readFrom(new ByteArrayInputStream(data));
        XOPObject xopObject = new XOPObject(converted);
        xopObject.setContentType(contentType);
        XOPMarshallerImpl xopMarshaller = new XOPMarshallerImpl();
        String cid = xopMarshaller.addMtomAttachment(xopObject, xopElement.getNamespaceURI(), xopElement.getLocalName());
        Node child = xopElement.getFirstChild();
        xopElement.removeChild(child);
        try {
            SOAPElement xopInclude = xopElement.addChildElement(Constants.NAME_XOP_INCLUDE);
            xopInclude.setAttribute("href", cid);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Restored xop:Include element on [xmlName=" + xopElement.getLocalName() + "]"));
            }
            XOPContext.setXOPMessage(true);
        }
        catch (SOAPException e) {
            throw new WSException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"FAILED_TO_CREATE_XOP_INCLUDE_ELEMENT", (Object[])new Object[0]), e);
        }
    }

    private static void replaceXOPInclude(SOAPElement parent, SOAPElement xopIncludeElement) {
        AttachmentPart removedPart;
        byte[] data;
        String contentType;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Replace xop:Include on element [xmlName=" + parent.getLocalName() + "]"));
        }
        String cid = xopIncludeElement.getAttribute("href");
        try {
            AttachmentPart part = XOPContext.getAttachmentByCID(cid);
            DataHandler dh = part.getDataHandler();
            contentType = dh.getContentType();
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            dh.writeTo((OutputStream)bout);
            data = bout.toByteArray();
        }
        catch (Exception e) {
            throw new WSException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"FAILED_TO_INLINE_XOP_DATA", (Object[])new Object[0]), e);
        }
        String base64 = SimpleTypeBindings.marshalBase64((byte[])data);
        parent.removeChild((Node)xopIncludeElement);
        parent.setValue(base64);
        parent.setUserData(NS_XOP_JBOSSWS_CONTENT_TYPE, (Object)contentType, null);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Created base64 representation for content-type " + contentType));
        }
        CommonMessageContext msgContext = MessageContextAssociation.peekMessageContext();
        SOAPMessageImpl soapMessage = (SOAPMessageImpl)msgContext.getSOAPMessage();
        if (cid.startsWith("cid:")) {
            cid = cid.substring(4);
        }
        if (null == (removedPart = soapMessage.removeAttachmentByContentId(cid = '<' + cid + '>'))) {
            throw new WSException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"UNABLE_TO_REMOVE_ATTACHMENT_PART", (Object[])new Object[]{cid}));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Removed attachment part " + cid));
        }
        XOPContext.setXOPMessage(false);
    }

    public static AttachmentPart getAttachmentByCID(String cid) throws SOAPException {
        AttachmentPart part;
        CommonMessageContext msgContext = MessageContextAssociation.peekMessageContext();
        SOAPMessageImpl soapMessage = (SOAPMessageImpl)msgContext.getSOAPMessage();
        if (cid.startsWith("cid:")) {
            cid = cid.substring(4);
        }
        if ((part = soapMessage.getAttachmentByContentId(cid = '<' + cid + '>')) == null) {
            throw new WSException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANNOT_FIND_ATTACHMENT_PART", (Object[])new Object[]{cid}));
        }
        return part;
    }

    public static DataHandler createDataHandler(XOPObject xopObject) {
        Object o = xopObject.getContent();
        DataHandler dataHandler = o instanceof DataHandler ? (DataHandler)o : (xopObject.getContentType() != null ? new DataHandler(o, xopObject.getContentType()) : new DataHandler(o, XOPContext.getContentTypeForClazz(o.getClass())));
        return dataHandler;
    }

    public static String getContentTypeForClazz(Class clazz) {
        if (JavaUtils.isAssignableFrom(Image.class, (Class)clazz)) {
            return "image/jpeg";
        }
        if (JavaUtils.isAssignableFrom(Source.class, (Class)clazz)) {
            return "application/xml";
        }
        if (JavaUtils.isAssignableFrom(String.class, (Class)clazz)) {
            return "text/plain";
        }
        return "application/octet-stream";
    }
}

