/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Blob;
import java.sql.SQLException;
import org.hibernate.engine.jdbc.BlobImplementer;
import org.hibernate.type.descriptor.java.BinaryStreamImpl;
import org.hibernate.type.descriptor.java.DataHelper;

public class BlobProxy
implements InvocationHandler {
    private static final Class[] PROXY_INTERFACES = new Class[]{Blob.class, BlobImplementer.class};
    private InputStream stream;
    private long length;
    private boolean needsReset = false;

    private BlobProxy(byte[] bytes) {
        this.stream = new BinaryStreamImpl(bytes);
        this.length = bytes.length;
    }

    private BlobProxy(InputStream stream, long length) {
        this.stream = stream;
        this.length = length;
    }

    private long getLength() {
        return this.length;
    }

    private InputStream getStream() throws SQLException {
        try {
            if (this.needsReset) {
                this.stream.reset();
            }
        }
        catch (IOException ioe) {
            throw new SQLException("could not reset reader");
        }
        this.needsReset = true;
        return this.stream;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        int argCount = method.getParameterTypes().length;
        if ("length".equals(methodName) && argCount == 0) {
            return this.getLength();
        }
        if ("getBinaryStream".equals(methodName)) {
            if (argCount == 0) {
                return this.getStream();
            }
            if (argCount == 2) {
                long start = (Long)args[0];
                if (start < 1L) {
                    throw new SQLException("Start position 1-based; must be 1 or more.");
                }
                if (start > this.getLength()) {
                    throw new SQLException("Start position [" + start + "] cannot exceed overall CLOB length [" + this.getLength() + "]");
                }
                int length = (Integer)args[1];
                if (length < 0) {
                    throw new SQLException("Length must be great-than-or-equal to zero.");
                }
                return DataHelper.subStream(this.getStream(), start - 1L, length);
            }
        }
        if ("getBytes".equals(methodName) && argCount == 2) {
            long start = (Long)args[0];
            if (start < 1L) {
                throw new SQLException("Start position 1-based; must be 1 or more.");
            }
            int length = (Integer)args[1];
            if (length < 0) {
                throw new SQLException("Length must be great-than-or-equal to zero.");
            }
            return DataHelper.extractBytes(this.getStream(), start - 1L, length);
        }
        if ("free".equals(methodName) && argCount == 0) {
            this.stream.close();
            return null;
        }
        if ("toString".equals(methodName) && argCount == 0) {
            return this.toString();
        }
        if ("equals".equals(methodName) && argCount == 1) {
            return proxy == args[0];
        }
        if ("hashCode".equals(methodName) && argCount == 0) {
            return this.hashCode();
        }
        throw new UnsupportedOperationException("Blob may not be manipulated from creating session");
    }

    public static Blob generateProxy(byte[] bytes) {
        return (Blob)Proxy.newProxyInstance(BlobProxy.getProxyClassLoader(), PROXY_INTERFACES, (InvocationHandler)new BlobProxy(bytes));
    }

    public static Blob generateProxy(InputStream stream, long length) {
        return (Blob)Proxy.newProxyInstance(BlobProxy.getProxyClassLoader(), PROXY_INTERFACES, (InvocationHandler)new BlobProxy(stream, length));
    }

    private static ClassLoader getProxyClassLoader() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = BlobImplementer.class.getClassLoader();
        }
        return cl;
    }
}

