/*
 * Decompiled with CFR 0.152.
 */
package org.apache.naming.resources;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import javax.naming.CompositeName;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import org.apache.naming.NamingContextBindingsEnumeration;
import org.apache.naming.NamingContextEnumeration;
import org.apache.naming.NamingEntry;
import org.apache.naming.resources.BaseDirContext;
import org.apache.naming.resources.Resource;
import org.apache.naming.resources.ResourceAttributes;
import org.jboss.logging.Logger;

public class JARDirContext
extends BaseDirContext {
    private static Logger log = Logger.getLogger(JARDirContext.class);
    protected JarFile base = null;
    protected Entry entries = null;
    protected String prefix = null;

    public JARDirContext() {
    }

    public JARDirContext(Hashtable env) {
        super(env);
    }

    protected JARDirContext(JarFile base, Entry entries) {
        this.base = base;
        this.entries = entries;
    }

    public void setJarFile(JarFile jarFile, String prefix) {
        if (jarFile == null) {
            throw new IllegalArgumentException(this.sm.getString("resources.null"));
        }
        this.prefix = prefix;
        if (prefix.startsWith("/")) {
            this.prefix = prefix.substring(1);
        }
        this.base = jarFile;
        this.loadEntries();
    }

    @Override
    public void release() {
        this.entries = null;
        this.base = null;
        super.release();
    }

    @Override
    public Object lookup(String name) throws NamingException {
        return this.lookup(new CompositeName(name));
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        if (name.isEmpty()) {
            return this;
        }
        Entry entry = this.treeLookup(name);
        if (entry == null) {
            throw new NamingException(this.sm.getString("resources.notFound", name));
        }
        JarEntry zipEntry = entry.getEntry();
        if (zipEntry.isDirectory()) {
            return new JARDirContext(this.base, entry);
        }
        return new JARResource(entry.getEntry());
    }

    @Override
    public void unbind(String name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public void rename(String oldName, String newName) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public NamingEnumeration list(String name) throws NamingException {
        return this.list(new CompositeName(name));
    }

    @Override
    public NamingEnumeration list(Name name) throws NamingException {
        if (name.isEmpty()) {
            return new NamingContextEnumeration(this.list(this.entries).iterator());
        }
        Entry entry = this.treeLookup(name);
        if (entry == null) {
            throw new NamingException(this.sm.getString("resources.notFound", name));
        }
        return new NamingContextEnumeration(this.list(entry).iterator());
    }

    @Override
    public NamingEnumeration listBindings(String name) throws NamingException {
        return this.listBindings(new CompositeName(name));
    }

    @Override
    public NamingEnumeration listBindings(Name name) throws NamingException {
        if (name.isEmpty()) {
            return new NamingContextBindingsEnumeration(this.list(this.entries).iterator(), this);
        }
        Entry entry = this.treeLookup(name);
        if (entry == null) {
            throw new NamingException(this.sm.getString("resources.notFound", name));
        }
        return new NamingContextBindingsEnumeration(this.list(entry).iterator(), this);
    }

    @Override
    public void destroySubcontext(String name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public Object lookupLink(String name) throws NamingException {
        return this.lookup(name);
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        return this.docBase;
    }

    @Override
    public Attributes getAttributes(String name, String[] attrIds) throws NamingException {
        return this.getAttributes(new CompositeName(name), attrIds);
    }

    @Override
    public Attributes getAttributes(Name name, String[] attrIds) throws NamingException {
        Entry entry = null;
        entry = name.isEmpty() ? this.entries : this.treeLookup(name);
        if (entry == null) {
            throw new NamingException(this.sm.getString("resources.notFound", name));
        }
        JarEntry zipEntry = entry.getEntry();
        ResourceAttributes attrs = new ResourceAttributes();
        attrs.setCreationDate(new Date(zipEntry.getTime()));
        attrs.setName(entry.getName());
        if (!zipEntry.isDirectory()) {
            attrs.setResourceType("");
        }
        attrs.setContentLength(zipEntry.getSize());
        attrs.setLastModified(zipEntry.getTime());
        return attrs;
    }

    @Override
    public void modifyAttributes(String name, int mod_op, Attributes attrs) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public void modifyAttributes(String name, ModificationItem[] mods) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public void bind(String name, Object obj, Attributes attrs) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public void rebind(String name, Object obj, Attributes attrs) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public DirContext createSubcontext(String name, Attributes attrs) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public DirContext getSchema(String name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public DirContext getSchemaClassDefinition(String name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public NamingEnumeration search(String name, Attributes matchingAttributes, String[] attributesToReturn) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public NamingEnumeration search(String name, Attributes matchingAttributes) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public NamingEnumeration search(String name, String filter, SearchControls cons) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public NamingEnumeration search(String name, String filterExpr, Object[] filterArgs, SearchControls cons) throws NamingException {
        throw new OperationNotSupportedException();
    }

    protected String normalize(ZipEntry entry) {
        String result = "/" + entry.getName();
        if (entry.isDirectory()) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    protected void loadEntries() {
        try {
            Enumeration<JarEntry> entryList = this.base.entries();
            this.entries = new Entry("/", new JarEntry(this.prefix + "/"));
            while (entryList.hasMoreElements()) {
                JarEntry entry = entryList.nextElement();
                String name = this.normalize(entry);
                if (this.prefix != null && !name.startsWith(this.prefix)) continue;
                int pos = name.lastIndexOf(47);
                int currentPos = -1;
                int lastPos = 0;
                while ((currentPos = name.indexOf(47, lastPos)) != -1) {
                    CompositeName parentName = new CompositeName(name.substring(this.prefix.length(), lastPos));
                    CompositeName childName = new CompositeName(name.substring(this.prefix.length(), currentPos));
                    String entryName = name.substring(lastPos, currentPos);
                    Entry parent = this.treeLookup(parentName);
                    Entry child = this.treeLookup(childName);
                    if (child == null) {
                        String zipName = name.substring(1, currentPos) + "/";
                        child = new Entry(entryName, new JarEntry(zipName));
                        if (parent != null) {
                            parent.addChild(child);
                        }
                    }
                    lastPos = currentPos + 1;
                }
                String entryName = name.substring(pos + 1, name.length());
                CompositeName compositeName = new CompositeName(name.substring(0, pos));
                Entry parent = this.treeLookup(compositeName);
                Entry child = new Entry(entryName, entry);
                if (parent == null) continue;
                parent.addChild(child);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected Entry treeLookup(Name name) {
        if (name.isEmpty()) {
            return this.entries;
        }
        Entry currentEntry = this.entries;
        for (int i = 0; i < name.size(); ++i) {
            if (name.get(i).length() == 0 || (currentEntry = currentEntry.getChild(name.get(i))) != null) continue;
            return null;
        }
        return currentEntry;
    }

    protected ArrayList list(Entry entry) {
        ArrayList<NamingEntry> entries = new ArrayList<NamingEntry>();
        Object[] children = entry.getChildren();
        Arrays.sort(children);
        NamingEntry namingEntry = null;
        for (int i = 0; i < children.length; ++i) {
            JarEntry current = ((Entry)children[i]).getEntry();
            Object object = null;
            object = current.isDirectory() ? new JARDirContext(this.base, (Entry)children[i]) : new JARResource(current);
            namingEntry = new NamingEntry(((Entry)children[i]).getName(), object, 0);
            entries.add(namingEntry);
        }
        return entries;
    }

    protected class JARResource
    extends Resource {
        protected JarEntry entry;

        public JARResource(JarEntry entry) {
            this.entry = entry;
        }

        @Override
        public InputStream streamContent() throws IOException {
            try {
                if (this.binaryContent == null) {
                    this.inputStream = JARDirContext.this.base.getInputStream(this.entry);
                }
            }
            catch (ZipException e) {
                throw new IOException(e.getMessage());
            }
            return super.streamContent();
        }
    }

    protected class Entry
    implements Comparable {
        protected String name = null;
        protected JarEntry entry = null;
        protected Entry[] children = new Entry[0];

        public Entry(String name, JarEntry entry) {
            this.name = name;
            this.entry = entry;
        }

        public int compareTo(Object o) {
            if (!(o instanceof Entry)) {
                return 1;
            }
            return this.name.compareTo(((Entry)o).getName());
        }

        public JarEntry getEntry() {
            return this.entry;
        }

        public String getName() {
            return this.name;
        }

        public void addChild(Entry entry) {
            Entry[] newChildren = new Entry[this.children.length + 1];
            for (int i = 0; i < this.children.length; ++i) {
                newChildren[i] = this.children[i];
            }
            newChildren[this.children.length] = entry;
            this.children = newChildren;
        }

        public Entry[] getChildren() {
            return this.children;
        }

        public Entry getChild(String name) {
            for (int i = 0; i < this.children.length; ++i) {
                if (!this.children[i].name.equals(name)) continue;
                return this.children[i];
            }
            return null;
        }
    }
}

