/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicLong;
import org.jboss.logging.Logger;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.modules.ModuleLoadException;
import org.jboss.msc.service.AbstractService;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.framework.Services;
import org.jboss.osgi.framework.internal.AbstractBundleRevision;
import org.jboss.osgi.framework.internal.AbstractBundleState;
import org.jboss.osgi.framework.internal.AbstractPluginService;
import org.jboss.osgi.framework.internal.BundleManager;
import org.jboss.osgi.framework.internal.FrameworkEventsPlugin;
import org.jboss.osgi.framework.internal.InternalServices;
import org.jboss.osgi.framework.internal.ModuleManagerPlugin;
import org.jboss.osgi.framework.internal.SecurityActions;
import org.jboss.osgi.framework.internal.ServiceReferenceComparator;
import org.jboss.osgi.framework.internal.ServiceState;
import org.jboss.osgi.framework.util.NoFilter;
import org.jboss.osgi.framework.util.RemoveOnlyCollection;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.hooks.service.FindHook;
import org.osgi.framework.hooks.service.ListenerHook;

final class ServiceManagerPlugin
extends AbstractPluginService<ServiceManagerPlugin> {
    private final Logger log = Logger.getLogger(ServiceManagerPlugin.class);
    private final InjectedValue<BundleManager> injectedBundleManager = new InjectedValue();
    private final InjectedValue<FrameworkEventsPlugin> injectedFrameworkEvents = new InjectedValue();
    private final InjectedValue<ModuleManagerPlugin> injectedModuleManager = new InjectedValue();
    private AtomicLong identityGenerator = new AtomicLong();
    private ServiceContainer serviceContainer;
    private ServiceTarget serviceTarget;

    static void addService(ServiceTarget serviceTarget) {
        ServiceManagerPlugin service = new ServiceManagerPlugin();
        ServiceBuilder builder = serviceTarget.addService(InternalServices.SERVICE_MANAGER_PLUGIN, (Service)service);
        builder.addDependency(Services.BUNDLE_MANAGER, BundleManager.class, service.injectedBundleManager);
        builder.addDependency(InternalServices.FRAMEWORK_EVENTS_PLUGIN, FrameworkEventsPlugin.class, service.injectedFrameworkEvents);
        builder.addDependency(InternalServices.MODULE_MANGER_PLUGIN, ModuleManagerPlugin.class, service.injectedModuleManager);
        builder.setInitialMode(ServiceController.Mode.ON_DEMAND);
        builder.install();
    }

    private ServiceManagerPlugin() {
    }

    @Override
    public void start(StartContext context) throws StartException {
        super.start(context);
        this.serviceContainer = context.getController().getServiceContainer();
        this.serviceTarget = context.getChildTarget();
    }

    @Override
    public void stop(StopContext context) {
        super.stop(context);
    }

    public ServiceManagerPlugin getValue() {
        return this;
    }

    FrameworkEventsPlugin getFrameworkEventsPlugin() {
        return (FrameworkEventsPlugin)((Object)this.injectedFrameworkEvents.getValue());
    }

    long getNextServiceId() {
        return this.identityGenerator.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ServiceState registerService(AbstractBundleState bundleState, String[] clazzes, final Object serviceValue, Dictionary properties) {
        if (clazzes == null || clazzes.length == 0) {
            throw new IllegalArgumentException("Null service classes");
        }
        FrameworkEventsPlugin eventsPlugin = this.getFrameworkEventsPlugin();
        Collection<ListenerHook.ListenerInfo> listenerInfos = null;
        if (serviceValue instanceof ListenerHook) {
            listenerInfos = eventsPlugin.getServiceListenerInfos(null);
        }
        ServiceState.ValueProvider valueProvider = new ServiceState.ValueProvider(){

            @Override
            public Object getValue() {
                return serviceValue;
            }
        };
        long serviceId = this.getNextServiceId();
        ServiceState serviceState = new ServiceState(this, bundleState, serviceId, clazzes, valueProvider, properties);
        this.log.debugf("Register service: %s", (Object)serviceState);
        for (ServiceName serviceName : serviceState.getServiceNames()) {
            String sns;
            String string = sns = serviceName.getCanonicalName().intern();
            synchronized (string) {
                CopyOnWriteArrayList<ServiceState> serviceStates;
                ServiceController controller = this.serviceContainer.getService(serviceName);
                if (controller != null) {
                    serviceStates = (CopyOnWriteArrayList<ServiceState>)controller.getValue();
                    serviceStates.add(serviceState);
                } else {
                    serviceStates = new CopyOnWriteArrayList<ServiceState>();
                    serviceStates.add(serviceState);
                    AbstractService<List<ServiceState>> service = new AbstractService<List<ServiceState>>(){

                        public List<ServiceState> getValue() throws IllegalStateException {
                            return serviceStates;
                        }
                    };
                    ServiceBuilder builder = this.serviceTarget.addService(serviceName, (Service)service);
                    builder.install();
                }
            }
        }
        bundleState.addRegisteredService(serviceState);
        if (serviceValue instanceof ListenerHook) {
            ListenerHook listenerHook = (ListenerHook)serviceValue;
            listenerHook.added(listenerInfos);
        }
        eventsPlugin.fireServiceEvent(bundleState, 1, serviceState);
        return serviceState;
    }

    ServiceState getServiceReference(AbstractBundleState bundleState, String clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("Null clazz");
        }
        boolean checkAssignable = bundleState.getBundleId() != 0L;
        List<ServiceState> result = this.getServiceReferencesInternal(bundleState, clazz, NoFilter.INSTANCE, checkAssignable);
        if ((result = this.processFindHooks(bundleState, clazz, null, true, result)).isEmpty()) {
            return null;
        }
        int lastIndex = result.size() - 1;
        return result.get(lastIndex);
    }

    List<ServiceState> getServiceReferences(AbstractBundleState bundleState, String clazz, String filterStr, boolean checkAssignable) throws InvalidSyntaxException {
        Filter filter = NoFilter.INSTANCE;
        if (filterStr != null) {
            filter = FrameworkUtil.createFilter((String)filterStr);
        }
        List<ServiceState> result = this.getServiceReferencesInternal(bundleState, clazz, filter, checkAssignable);
        result = this.processFindHooks(bundleState, clazz, filterStr, checkAssignable, result);
        return result;
    }

    private List<ServiceState> getServiceReferencesInternal(final AbstractBundleState bundleState, String className, Filter filter, boolean checkAssignable) {
        HashSet<ServiceName> serviceNames;
        block10: {
            block8: {
                block9: {
                    if (bundleState == null) {
                        throw new IllegalArgumentException("Null bundleState");
                    }
                    if (filter == null) {
                        throw new IllegalArgumentException("Null filter");
                    }
                    serviceNames = new HashSet<ServiceName>();
                    if (className == null) break block8;
                    ServiceName serviceName = ServiceState.createServiceName(className);
                    if (this.serviceContainer.getService(serviceName) == null) break block9;
                    serviceNames.add(serviceName);
                    break block10;
                }
                ServiceName xserviceName = ServiceState.createXServiceName(className);
                if (this.serviceContainer.getService(xserviceName) == null) break block10;
                serviceNames.add(xserviceName);
                break block10;
            }
            for (ServiceName aux : this.serviceContainer.getServiceNames()) {
                if (!Services.JBOSGI_SERVICE_BASE_NAME.isParentOf(aux) && !Services.JBOSGI_XSERVICE_BASE_NAME.isParentOf(aux)) continue;
                serviceNames.add(aux);
            }
        }
        if (serviceNames.isEmpty()) {
            return Collections.emptyList();
        }
        HashSet<ServiceState> resultset = new HashSet<ServiceState>();
        for (ServiceName serviceName : serviceNames) {
            String auxName;
            final ServiceController controller = this.serviceContainer.getService(serviceName);
            if (controller == null) continue;
            if (Services.JBOSGI_SERVICE_BASE_NAME.isParentOf(serviceName)) {
                List serviceStates = (List)controller.getValue();
                for (ServiceState serviceState : serviceStates) {
                    if (!this.isMatchingService(bundleState, serviceState, className, filter, checkAssignable)) continue;
                    resultset.add(serviceState);
                }
                continue;
            }
            if (!Services.JBOSGI_XSERVICE_BASE_NAME.isParentOf(serviceName)) continue;
            ServiceState.ValueProvider valueProvider = new ServiceState.ValueProvider(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Object getValue() {
                    AbstractBundleRevision currentRevision = bundleState.getCurrentRevision();
                    ModuleClassLoader classLoader = null;
                    try {
                        classLoader = currentRevision.getModuleClassLoader();
                    }
                    catch (ModuleLoadException ex) {
                        ServiceManagerPlugin.this.log.errorf((Throwable)ex, "Cannot obtain class loader for: %s", (Object)currentRevision);
                    }
                    ClassLoader ctxLoader = SecurityActions.getContextClassLoader();
                    try {
                        SecurityActions.setContextClassLoader((ClassLoader)classLoader);
                        Object object = controller.getValue();
                        return object;
                    }
                    finally {
                        SecurityActions.setContextClassLoader(ctxLoader);
                    }
                }
            };
            long serviceId = this.getNextServiceId();
            Object value = valueProvider.getValue();
            AbstractBundleState auxBundle = ((ModuleManagerPlugin)((Object)this.injectedModuleManager.getValue())).getBundleState(value.getClass());
            AbstractBundleState owner = auxBundle != null ? auxBundle : ((BundleManager)this.injectedBundleManager.getValue()).getSystemBundle();
            String string = auxName = className != null ? className : serviceName.getSimpleName();
            ServiceState serviceState = new ServiceState(this, owner, serviceId, new String[]{auxName}, valueProvider, null);
            if (!this.isMatchingService(bundleState, serviceState, auxName, filter, checkAssignable)) continue;
            resultset.add(serviceState);
        }
        ArrayList resultlist = new ArrayList(resultset);
        if (resultlist.size() > 1) {
            Collections.sort(resultlist, ServiceReferenceComparator.getInstance());
        }
        return Collections.unmodifiableList(resultlist);
    }

    private boolean isMatchingService(AbstractBundleState bundleState, ServiceState serviceState, String clazzName, Filter filter, boolean checkAssignable) {
        if (serviceState.isUnregistered() || !filter.match((ServiceReference)serviceState)) {
            return false;
        }
        if (!checkAssignable || clazzName == null) {
            return true;
        }
        return serviceState.isAssignableTo(bundleState, clazzName);
    }

    Object getService(AbstractBundleState bundleState, ServiceState serviceState) {
        if (serviceState.isUnregistered()) {
            return null;
        }
        bundleState.addServiceInUse(serviceState);
        serviceState.addUsingBundle(bundleState);
        Object value = serviceState.getScopedValue(bundleState);
        if (value == null) {
            bundleState.removeServiceInUse(serviceState);
            serviceState.removeUsingBundle(bundleState);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregisterService(ServiceState serviceState) {
        ServiceState serviceState2 = serviceState;
        synchronized (serviceState2) {
            if (serviceState.isUnregistered()) {
                return;
            }
            for (ServiceName serviceName : serviceState.getServiceNames()) {
                this.log.debugf("Unregister service: %s", (Object)serviceName);
                try {
                    ServiceController controller = this.serviceContainer.getService(serviceName);
                    if (controller == null) continue;
                    List serviceStates = (List)controller.getValue();
                    serviceStates.remove(serviceState);
                    if (!serviceStates.isEmpty()) continue;
                    BundleManager bundleManager = (BundleManager)this.injectedBundleManager.getValue();
                    bundleManager.setServiceMode(controller, ServiceController.Mode.REMOVE);
                }
                catch (RuntimeException ex) {
                    this.log.errorf((Throwable)ex, "Cannot remove service: %s", (Object)serviceName);
                }
            }
            AbstractBundleState serviceOwner = serviceState.getServiceOwner();
            FrameworkEventsPlugin eventsPlugin = (FrameworkEventsPlugin)((Object)this.injectedFrameworkEvents.getValue());
            eventsPlugin.fireServiceEvent(serviceOwner, 4, serviceState);
            for (AbstractBundleState bundleState : serviceState.getUsingBundlesInternal()) {
                while (this.ungetService(bundleState, serviceState)) {
                }
            }
            serviceOwner.removeRegisteredService(serviceState);
        }
    }

    boolean ungetService(AbstractBundleState bundleState, ServiceState serviceState) {
        serviceState.ungetScopedValue(bundleState);
        int useCount = bundleState.removeServiceInUse(serviceState);
        if (useCount == 0) {
            serviceState.removeUsingBundle(bundleState);
        }
        return useCount >= 0;
    }

    private List<ServiceState> processFindHooks(AbstractBundleState bundle, String clazz, String filterStr, boolean checkAssignable, List<ServiceState> serviceStates) {
        BundleContext context = bundle.getBundleContext();
        List<ServiceState> hookRefs = this.getServiceReferencesInternal(bundle, FindHook.class.getName(), NoFilter.INSTANCE, true);
        if (hookRefs.isEmpty()) {
            return serviceStates;
        }
        if (clazz != null && clazz.startsWith(FindHook.class.getPackage().getName())) {
            return serviceStates;
        }
        ArrayList<ServiceState> sortedHookRefs = new ArrayList<ServiceState>(hookRefs);
        Collections.reverse(sortedHookRefs);
        ArrayList<FindHook> hooks = new ArrayList<FindHook>();
        for (ServiceReference serviceReference : sortedHookRefs) {
            hooks.add((FindHook)context.getService(serviceReference));
        }
        Collection hookParam = new ArrayList<ServiceReference>();
        for (ServiceState aux : serviceStates) {
            hookParam.add(aux.getReference());
        }
        hookParam = new RemoveOnlyCollection(hookParam);
        for (FindHook hook : hooks) {
            try {
                hook.find(context, clazz, filterStr, !checkAssignable, hookParam);
            }
            catch (Exception ex) {
                this.log.warnf((Throwable)ex, "Error while calling FindHook: %s", (Object)hook);
            }
        }
        ArrayList<ServiceState> arrayList = new ArrayList<ServiceState>();
        for (ServiceReference aux : hookParam) {
            ServiceState serviceState = ServiceState.assertServiceState(aux);
            arrayList.add(serviceState);
        }
        return arrayList;
    }
}

