/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.config.descriptor.impl;

import org.jboss.arquillian.config.descriptor.api.EngineDef;
import org.jboss.arquillian.config.descriptor.impl.ArquillianDescriptorImpl;
import org.jboss.shrinkwrap.descriptor.spi.Node;
import org.jboss.shrinkwrap.descriptor.spi.query.Pattern;
import org.jboss.shrinkwrap.descriptor.spi.query.Patterns;

public class EngineDefImpl
extends ArquillianDescriptorImpl
implements EngineDef {
    private static final Pattern[] exportPath = Patterns.from((String)"property@name=deploymentExportPath");
    private static final Pattern[] maxTestClasses = Patterns.from((String)"property@name=maxTestClassesBeforeRestart");
    private Node engine;

    public EngineDefImpl(String descriptorName, Node model, Node engine) {
        super(descriptorName, model);
        this.engine = engine;
    }

    public EngineDef deploymentExportPath(String path) {
        this.engine.getOrCreate(exportPath).text(path);
        return this;
    }

    public String getDeploymentExportPath() {
        return this.getTextIfExists(exportPath);
    }

    public EngineDef maxTestClassesBeforeRestart(Integer max) {
        this.engine.getOrCreate(maxTestClasses).text((Object)max);
        return this;
    }

    public Integer getMaxTestClassesBeforeRestart() {
        return this.getTextIfExistsAsInteger(maxTestClasses);
    }

    private Integer getTextIfExistsAsInteger(Pattern ... pattern) {
        String text = this.getTextIfExists(pattern);
        if (text != null) {
            return Integer.parseInt(text);
        }
        return null;
    }

    private String getTextIfExists(Pattern ... pattern) {
        Node propery = this.engine.getSingle(pattern);
        if (propery != null) {
            return propery.getText();
        }
        return null;
    }
}

