/*
 * Decompiled with CFR 0.152.
 */
package org.jamel.dbf.utils;

import java.io.DataInput;
import java.io.IOException;

public final class DbfUtils {
    private DbfUtils() {
    }

    public static int readLittleEndianInt(DataInput in) throws IOException {
        int bigEndian = 0;
        for (int shiftBy = 0; shiftBy < 32; shiftBy += 8) {
            bigEndian |= (in.readUnsignedByte() & 0xFF) << shiftBy;
        }
        return bigEndian;
    }

    public static short readLittleEndianShort(DataInput in) throws IOException {
        int low = in.readUnsignedByte() & 0xFF;
        int high = in.readUnsignedByte();
        return (short)(high << 8 | low);
    }

    public static byte[] trimLeftSpaces(byte[] arr) {
        int i = arr.length;
        while (--i >= 0 && arr[i] == 32) {
        }
        byte[] result = new byte[++i];
        if (i > 0) {
            System.arraycopy(arr, 0, result, 0, i);
        }
        return result;
    }

    public static boolean contains(byte[] arr, byte value) {
        for (byte anArr : arr) {
            if (anArr != value) continue;
            return true;
        }
        return false;
    }

    public static int parseInt(byte[] bytes) {
        int result = 0;
        for (byte aByte : bytes) {
            if (aByte == 32) {
                return result;
            }
            result *= 10;
            result += aByte - 48;
        }
        return result;
    }

    public static int parseInt(byte[] bytes, int from, int to) {
        int result = 0;
        for (int i = from; i < to && i < bytes.length; ++i) {
            result *= 10;
            result += bytes[i] - 48;
        }
        return result;
    }

    public static long parseLong(byte[] bytes) {
        long result = 0L;
        for (byte aByte : bytes) {
            if (aByte == 32) {
                return result;
            }
            result *= 10L;
            result += (long)(aByte - 48);
        }
        return result;
    }

    public static long parseLong(byte[] bytes, int from, int to) {
        long result = 0L;
        for (int i = from; i < to && i < bytes.length; ++i) {
            result *= 10L;
            result += (long)(bytes[i] - 48);
        }
        return result;
    }
}

