/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.memcached.binary;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.time.Instant;
import java.util.List;
import javax.security.auth.Subject;
import org.infinispan.commons.util.Util;
import org.infinispan.server.memcached.MemcachedServer;
import org.infinispan.server.memcached.binary.BinaryCommand;
import org.infinispan.server.memcached.binary.BinaryHeader;
import org.infinispan.server.memcached.binary.BinaryIntrinsics;
import org.infinispan.server.memcached.binary.BinaryOpDecoder;

public class BinaryOpDecoderImpl
extends BinaryOpDecoder {
    private int state;
    private int requestBytes;
    private long mc_long;
    private byte mc_dataType;
    private short mc_vbucketId;
    private int mc_opaque;
    private BinaryCommand mc_op;
    private int mc_totalBodyLength;
    private int mc_int;
    private int mc_verbosity;
    private int mc_expiration;
    private BinaryHeader mc_header;
    private int mc_flags;
    private long mc_cas;
    private BinaryCommand mc_opCode;
    private byte[] mc_fixedArray;
    private byte mc_byte;
    private long mc_initial;
    private byte[] mc_key;
    private byte mc_magic;
    private short mc_keyLength;
    private long mc_delta;
    private byte[] mc_value;
    private short mc_short;
    private int mc_valueLength;
    private byte mc_extrasLength;
    private boolean deadEnd = false;

    public BinaryOpDecoderImpl(MemcachedServer server, Subject subject) {
        super(server, subject);
    }

    public BinaryOpDecoderImpl(MemcachedServer server) {
        this(server, ANONYMOUS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decode(ChannelHandlerContext ctx, ByteBuf buf, List<Object> out) throws Exception {
        int pos = buf.readerIndex();
        try {
            if (!ctx.channel().config().isAutoRead()) {
                log.tracef("Auto read was disabled, not reading next bytes yet", new Object[0]);
                return;
            }
            log.tracef("Auto read was enabled, reading next bytes", new Object[0]);
            while (this.switch1_0(buf, out)) {
            }
        }
        catch (Throwable t) {
            this.exceptionally(t);
        }
        finally {
            this.requestBytes += buf.readerIndex() - pos;
        }
    }

    private boolean switch1_0(ByteBuf buf, List<Object> out) throws Exception {
        switch (this.state >> 6) {
            case 0: {
                return this.switch0(buf, out);
            }
            case 1: {
                return this.switch1(buf, out);
            }
            case 2: {
                return this.switch2(buf, out);
            }
        }
        throw new IllegalStateException();
    }

    private boolean switch0(ByteBuf buf, List<Object> out) throws Exception {
        switch (this.state) {
            case 0: {
                this.reset();
                this.state = 1;
            }
            case 1: {
                int pos = buf.readerIndex();
                this.mc_byte = BinaryIntrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_magic = this.mc_byte;
                this.state = 2;
            }
            case 2: {
                if (this.accessLogging) {
                    this.requestStart = Instant.now();
                }
                this.state = 3;
            }
            case 3: {
                if (this.mc_magic != -128) {
                    this.state = 5;
                    return true;
                }
                this.deadEnd = false;
                this.state = 6;
                return true;
            }
            case 4: {
                if (log.isTraceEnabled()) {
                    log.tracef("Parsed header: %s", this.mc_header);
                }
                this.state = 14;
                return true;
            }
            case 5: {
                throw new IllegalStateException("Error reading magic byte or message id: " + this.mc_magic);
            }
            case 6: {
                int pos = buf.readerIndex();
                this.mc_opCode = BinaryIntrinsics.opCode(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_op = this.mc_opCode;
                this.state = 7;
            }
            case 7: {
                int pos = buf.readerIndex();
                this.mc_short = BinaryIntrinsics.short_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_keyLength = this.mc_short;
                this.state = 8;
            }
            case 8: {
                int pos = buf.readerIndex();
                this.mc_byte = BinaryIntrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_extrasLength = this.mc_byte;
                this.state = 9;
            }
            case 9: {
                int pos = buf.readerIndex();
                this.mc_byte = BinaryIntrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_dataType = this.mc_byte;
                this.state = 10;
            }
            case 10: {
                int pos = buf.readerIndex();
                this.mc_short = BinaryIntrinsics.short_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_vbucketId = this.mc_short;
                this.state = 11;
            }
            case 11: {
                int pos = buf.readerIndex();
                this.mc_int = BinaryIntrinsics.int_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_totalBodyLength = this.mc_int;
                this.state = 12;
            }
            case 12: {
                int pos = buf.readerIndex();
                this.mc_int = BinaryIntrinsics.int_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_opaque = this.mc_int;
                this.state = 13;
            }
            case 13: {
                int pos = buf.readerIndex();
                this.mc_long = BinaryIntrinsics.long_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_cas = this.mc_long;
                this.mc_valueLength = this.mc_totalBodyLength - this.mc_keyLength - this.mc_extrasLength;
                this.mc_header = this.acquireHeader().replace(this.requestStart, this.requestBytes, this.principalName, this.mc_key, this.mc_opCode, this.mc_opaque, this.mc_cas);
                this.state = 4;
                return true;
            }
            case 14: {
                return this.userSwitch14();
            }
            case 15: {
                if (this.mc_keyLength > 0) {
                    this.state = 17;
                    return true;
                }
                this.mc_key = Util.EMPTY_BYTE_ARRAY;
                this.state = 16;
            }
            case 16: {
                if (out.add(this.get(this.mc_header, this.mc_key, false))) {
                    this.state = 0;
                    return false;
                }
                this.state = 0;
                return true;
            }
            case 17: {
                int pos = buf.readerIndex();
                this.mc_fixedArray = BinaryIntrinsics.fixedArray(buf, this.mc_keyLength);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_key = this.mc_fixedArray;
                this.state = 16;
                return true;
            }
            case 18: {
                if (this.mc_keyLength > 0) {
                    this.state = 20;
                    return true;
                }
                this.mc_key = Util.EMPTY_BYTE_ARRAY;
                this.state = 19;
            }
            case 19: {
                if (out.add(this.get(this.mc_header, this.mc_key, true))) {
                    this.state = 0;
                    return false;
                }
                this.state = 0;
                return true;
            }
            case 20: {
                int pos = buf.readerIndex();
                this.mc_fixedArray = BinaryIntrinsics.fixedArray(buf, this.mc_keyLength);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_key = this.mc_fixedArray;
                this.state = 19;
                return true;
            }
            case 21: {
                if (this.mc_keyLength > 0) {
                    this.state = 23;
                    return true;
                }
                this.mc_key = Util.EMPTY_BYTE_ARRAY;
                this.state = 22;
            }
            case 22: {
                if (out.add(this.get(this.mc_header, this.mc_key, false))) {
                    this.state = 0;
                    return false;
                }
                this.state = 0;
                return true;
            }
            case 23: {
                int pos = buf.readerIndex();
                this.mc_fixedArray = BinaryIntrinsics.fixedArray(buf, this.mc_keyLength);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_key = this.mc_fixedArray;
                this.state = 22;
                return true;
            }
            case 24: {
                if (this.mc_keyLength > 0) {
                    this.state = 26;
                    return true;
                }
                this.mc_key = Util.EMPTY_BYTE_ARRAY;
                this.state = 25;
            }
            case 25: {
                if (out.add(this.get(this.mc_header, this.mc_key, true))) {
                    this.state = 0;
                    return false;
                }
                this.state = 0;
                return true;
            }
            case 26: {
                int pos = buf.readerIndex();
                this.mc_fixedArray = BinaryIntrinsics.fixedArray(buf, this.mc_keyLength);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_key = this.mc_fixedArray;
                this.state = 25;
                return true;
            }
            case 27: {
                int pos = buf.readerIndex();
                this.mc_int = BinaryIntrinsics.int_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_flags = this.mc_int;
                this.state = 28;
            }
            case 28: {
                if (this.mc_extrasLength > 0) {
                    this.state = 30;
                    return true;
                }
                this.mc_expiration = 0;
                this.state = 29;
            }
            case 29: {
                if (this.mc_keyLength > 0) {
                    this.state = 32;
                    return true;
                }
                this.mc_key = Util.EMPTY_BYTE_ARRAY;
                this.state = 31;
                return true;
            }
            case 30: {
                int pos = buf.readerIndex();
                this.mc_int = BinaryIntrinsics.int_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_expiration = this.mc_int;
                this.state = 29;
                return true;
            }
            case 31: {
                if (this.mc_valueLength > 0) {
                    this.state = 34;
                    return true;
                }
                this.mc_value = Util.EMPTY_BYTE_ARRAY;
                this.state = 33;
                return true;
            }
            case 32: {
                int pos = buf.readerIndex();
                this.mc_fixedArray = BinaryIntrinsics.fixedArray(buf, this.mc_keyLength);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_key = this.mc_fixedArray;
                this.state = 31;
                return true;
            }
            case 33: {
                if (out.add(this.set(this.mc_header, this.mc_key, this.mc_value, this.mc_flags, this.mc_expiration, false))) {
                    this.state = 0;
                    return false;
                }
                this.state = 0;
                return true;
            }
            case 34: {
                int pos = buf.readerIndex();
                this.mc_fixedArray = BinaryIntrinsics.fixedArray(buf, this.mc_valueLength);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_value = this.mc_fixedArray;
                this.state = 33;
                return true;
            }
            case 35: {
                int pos = buf.readerIndex();
                this.mc_int = BinaryIntrinsics.int_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_flags = this.mc_int;
                this.state = 36;
            }
            case 36: {
                if (this.mc_extrasLength > 0) {
                    this.state = 38;
                    return true;
                }
                this.mc_expiration = 0;
                this.state = 37;
            }
            case 37: {
                if (this.mc_keyLength > 0) {
                    this.state = 40;
                    return true;
                }
                this.mc_key = Util.EMPTY_BYTE_ARRAY;
                this.state = 39;
                return true;
            }
            case 38: {
                int pos = buf.readerIndex();
                this.mc_int = BinaryIntrinsics.int_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_expiration = this.mc_int;
                this.state = 37;
                return true;
            }
            case 39: {
                if (this.mc_valueLength > 0) {
                    this.state = 42;
                    return true;
                }
                this.mc_value = Util.EMPTY_BYTE_ARRAY;
                this.state = 41;
                return true;
            }
            case 40: {
                int pos = buf.readerIndex();
                this.mc_fixedArray = BinaryIntrinsics.fixedArray(buf, this.mc_keyLength);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_key = this.mc_fixedArray;
                this.state = 39;
                return true;
            }
            case 41: {
                if (out.add(this.set(this.mc_header, this.mc_key, this.mc_value, this.mc_flags, this.mc_expiration, true))) {
                    this.state = 0;
                    return false;
                }
                this.state = 0;
                return true;
            }
            case 42: {
                int pos = buf.readerIndex();
                this.mc_fixedArray = BinaryIntrinsics.fixedArray(buf, this.mc_valueLength);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_value = this.mc_fixedArray;
                this.state = 41;
                return true;
            }
            case 43: {
                int pos = buf.readerIndex();
                this.mc_int = BinaryIntrinsics.int_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_flags = this.mc_int;
                this.state = 44;
            }
            case 44: {
                if (this.mc_extrasLength > 0) {
                    this.state = 46;
                    return true;
                }
                this.mc_expiration = 0;
                this.state = 45;
            }
            case 45: {
                if (this.mc_keyLength > 0) {
                    this.state = 48;
                    return true;
                }
                this.mc_key = Util.EMPTY_BYTE_ARRAY;
                this.state = 47;
                return true;
            }
            case 46: {
                int pos = buf.readerIndex();
                this.mc_int = BinaryIntrinsics.int_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_expiration = this.mc_int;
                this.state = 45;
                return true;
            }
            case 47: {
                if (this.mc_valueLength > 0) {
                    this.state = 50;
                    return true;
                }
                this.mc_value = Util.EMPTY_BYTE_ARRAY;
                this.state = 49;
                return true;
            }
            case 48: {
                int pos = buf.readerIndex();
                this.mc_fixedArray = BinaryIntrinsics.fixedArray(buf, this.mc_keyLength);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_key = this.mc_fixedArray;
                this.state = 47;
                return true;
            }
            case 49: {
                if (out.add(this.add(this.mc_header, this.mc_key, this.mc_value, this.mc_flags, this.mc_expiration, false))) {
                    this.state = 0;
                    return false;
                }
                this.state = 0;
                return true;
            }
            case 50: {
                int pos = buf.readerIndex();
                this.mc_fixedArray = BinaryIntrinsics.fixedArray(buf, this.mc_valueLength);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_value = this.mc_fixedArray;
                this.state = 49;
                return true;
            }
            case 51: {
                int pos = buf.readerIndex();
                this.mc_int = BinaryIntrinsics.int_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_flags = this.mc_int;
                this.state = 52;
            }
            case 52: {
                if (this.mc_extrasLength > 0) {
                    this.state = 54;
                    return true;
                }
                this.mc_expiration = 0;
                this.state = 53;
            }
            case 53: {
                if (this.mc_keyLength > 0) {
                    this.state = 56;
                    return true;
                }
                this.mc_key = Util.EMPTY_BYTE_ARRAY;
                this.state = 55;
                return true;
            }
            case 54: {
                int pos = buf.readerIndex();
                this.mc_int = BinaryIntrinsics.int_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_expiration = this.mc_int;
                this.state = 53;
                return true;
            }
            case 55: {
                if (this.mc_valueLength > 0) {
                    this.state = 58;
                    return true;
                }
                this.mc_value = Util.EMPTY_BYTE_ARRAY;
                this.state = 57;
                return true;
            }
            case 56: {
                int pos = buf.readerIndex();
                this.mc_fixedArray = BinaryIntrinsics.fixedArray(buf, this.mc_keyLength);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_key = this.mc_fixedArray;
                this.state = 55;
                return true;
            }
            case 57: {
                if (out.add(this.add(this.mc_header, this.mc_key, this.mc_value, this.mc_flags, this.mc_expiration, true))) {
                    this.state = 0;
                    return false;
                }
                this.state = 0;
                return true;
            }
            case 58: {
                int pos = buf.readerIndex();
                this.mc_fixedArray = BinaryIntrinsics.fixedArray(buf, this.mc_valueLength);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_value = this.mc_fixedArray;
                this.state = 57;
                return true;
            }
            case 59: {
                int pos = buf.readerIndex();
                this.mc_int = BinaryIntrinsics.int_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_flags = this.mc_int;
                this.state = 60;
            }
            case 60: {
                if (this.mc_extrasLength > 0) {
                    this.state = 62;
                    return true;
                }
                this.mc_expiration = 0;
                this.state = 61;
            }
            case 61: {
                if (this.mc_keyLength > 0) {
                    this.state = 64;
                    return true;
                }
                this.mc_key = Util.EMPTY_BYTE_ARRAY;
                this.state = 63;
                return true;
            }
            case 62: {
                int pos = buf.readerIndex();
                this.mc_int = BinaryIntrinsics.int_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_expiration = this.mc_int;
                this.state = 61;
                return true;
            }
            case 63: {
                if (this.mc_valueLength > 0) {
                    this.state = 66;
                    return true;
                }
                this.mc_value = Util.EMPTY_BYTE_ARRAY;
                this.state = 65;
                return true;
            }
        }
        return true;
    }

    private boolean switch1(ByteBuf buf, List<Object> out) throws Exception {
        switch (this.state) {
            case 64: {
                int pos = buf.readerIndex();
                this.mc_fixedArray = BinaryIntrinsics.fixedArray(buf, this.mc_keyLength);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_key = this.mc_fixedArray;
                this.state = 63;
                return true;
            }
            case 65: {
                if (out.add(this.replace(this.mc_header, this.mc_key, this.mc_value, this.mc_flags, this.mc_expiration, false))) {
                    this.state = 0;
                    return false;
                }
                this.state = 0;
                return true;
            }
            case 66: {
                int pos = buf.readerIndex();
                this.mc_fixedArray = BinaryIntrinsics.fixedArray(buf, this.mc_valueLength);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_value = this.mc_fixedArray;
                this.state = 65;
                return true;
            }
            case 67: {
                int pos = buf.readerIndex();
                this.mc_int = BinaryIntrinsics.int_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_flags = this.mc_int;
                this.state = 68;
            }
            case 68: {
                if (this.mc_extrasLength > 0) {
                    this.state = 70;
                    return true;
                }
                this.mc_expiration = 0;
                this.state = 69;
            }
            case 69: {
                if (this.mc_keyLength > 0) {
                    this.state = 72;
                    return true;
                }
                this.mc_key = Util.EMPTY_BYTE_ARRAY;
                this.state = 71;
                return true;
            }
            case 70: {
                int pos = buf.readerIndex();
                this.mc_int = BinaryIntrinsics.int_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_expiration = this.mc_int;
                this.state = 69;
                return true;
            }
            case 71: {
                if (this.mc_valueLength > 0) {
                    this.state = 74;
                    return true;
                }
                this.mc_value = Util.EMPTY_BYTE_ARRAY;
                this.state = 73;
                return true;
            }
            case 72: {
                int pos = buf.readerIndex();
                this.mc_fixedArray = BinaryIntrinsics.fixedArray(buf, this.mc_keyLength);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_key = this.mc_fixedArray;
                this.state = 71;
                return true;
            }
            case 73: {
                if (out.add(this.replace(this.mc_header, this.mc_key, this.mc_value, this.mc_flags, this.mc_expiration, true))) {
                    this.state = 0;
                    return false;
                }
                this.state = 0;
                return true;
            }
            case 74: {
                int pos = buf.readerIndex();
                this.mc_fixedArray = BinaryIntrinsics.fixedArray(buf, this.mc_valueLength);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_value = this.mc_fixedArray;
                this.state = 73;
                return true;
            }
            case 75: {
                if (this.mc_keyLength > 0) {
                    this.state = 77;
                    return true;
                }
                this.mc_key = Util.EMPTY_BYTE_ARRAY;
                this.state = 76;
            }
            case 76: {
                if (out.add(this.delete(this.mc_header, this.mc_key, false))) {
                    this.state = 0;
                    return false;
                }
                this.state = 0;
                return true;
            }
            case 77: {
                int pos = buf.readerIndex();
                this.mc_fixedArray = BinaryIntrinsics.fixedArray(buf, this.mc_keyLength);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_key = this.mc_fixedArray;
                this.state = 76;
                return true;
            }
            case 78: {
                if (this.mc_keyLength > 0) {
                    this.state = 80;
                    return true;
                }
                this.mc_key = Util.EMPTY_BYTE_ARRAY;
                this.state = 79;
            }
            case 79: {
                if (out.add(this.delete(this.mc_header, this.mc_key, true))) {
                    this.state = 0;
                    return false;
                }
                this.state = 0;
                return true;
            }
            case 80: {
                int pos = buf.readerIndex();
                this.mc_fixedArray = BinaryIntrinsics.fixedArray(buf, this.mc_keyLength);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_key = this.mc_fixedArray;
                this.state = 79;
                return true;
            }
            case 81: {
                int pos = buf.readerIndex();
                this.mc_long = BinaryIntrinsics.long_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_delta = this.mc_long;
                this.state = 82;
            }
            case 82: {
                int pos = buf.readerIndex();
                this.mc_long = BinaryIntrinsics.long_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_initial = this.mc_long;
                this.state = 83;
            }
            case 83: {
                if (this.mc_extrasLength > 0) {
                    this.state = 85;
                    return true;
                }
                this.mc_expiration = 0;
                this.state = 84;
            }
            case 84: {
                if (this.mc_keyLength > 0) {
                    this.state = 87;
                    return true;
                }
                this.mc_key = Util.EMPTY_BYTE_ARRAY;
                this.state = 86;
                return true;
            }
            case 85: {
                int pos = buf.readerIndex();
                this.mc_int = BinaryIntrinsics.int_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_expiration = this.mc_int;
                this.state = 84;
                return true;
            }
            case 86: {
                if (out.add(this.increment(this.mc_header, this.mc_key, this.mc_delta, this.mc_initial, this.mc_expiration, false))) {
                    this.state = 0;
                    return false;
                }
                this.state = 0;
                return true;
            }
            case 87: {
                int pos = buf.readerIndex();
                this.mc_fixedArray = BinaryIntrinsics.fixedArray(buf, this.mc_keyLength);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_key = this.mc_fixedArray;
                this.state = 86;
                return true;
            }
            case 88: {
                int pos = buf.readerIndex();
                this.mc_long = BinaryIntrinsics.long_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_delta = this.mc_long;
                this.state = 89;
            }
            case 89: {
                int pos = buf.readerIndex();
                this.mc_long = BinaryIntrinsics.long_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_initial = this.mc_long;
                this.state = 90;
            }
            case 90: {
                if (this.mc_extrasLength > 0) {
                    this.state = 92;
                    return true;
                }
                this.mc_expiration = 0;
                this.state = 91;
            }
            case 91: {
                if (this.mc_keyLength > 0) {
                    this.state = 94;
                    return true;
                }
                this.mc_key = Util.EMPTY_BYTE_ARRAY;
                this.state = 93;
                return true;
            }
            case 92: {
                int pos = buf.readerIndex();
                this.mc_int = BinaryIntrinsics.int_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_expiration = this.mc_int;
                this.state = 91;
                return true;
            }
            case 93: {
                if (out.add(this.increment(this.mc_header, this.mc_key, this.mc_delta, this.mc_initial, this.mc_expiration, true))) {
                    this.state = 0;
                    return false;
                }
                this.state = 0;
                return true;
            }
            case 94: {
                int pos = buf.readerIndex();
                this.mc_fixedArray = BinaryIntrinsics.fixedArray(buf, this.mc_keyLength);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_key = this.mc_fixedArray;
                this.state = 93;
                return true;
            }
            case 95: {
                int pos = buf.readerIndex();
                this.mc_long = BinaryIntrinsics.long_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_delta = this.mc_long;
                this.state = 96;
            }
            case 96: {
                int pos = buf.readerIndex();
                this.mc_long = BinaryIntrinsics.long_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_initial = this.mc_long;
                this.state = 97;
            }
            case 97: {
                if (this.mc_extrasLength > 0) {
                    this.state = 99;
                    return true;
                }
                this.mc_expiration = 0;
                this.state = 98;
            }
            case 98: {
                if (this.mc_keyLength > 0) {
                    this.state = 101;
                    return true;
                }
                this.mc_key = Util.EMPTY_BYTE_ARRAY;
                this.state = 100;
                return true;
            }
            case 99: {
                int pos = buf.readerIndex();
                this.mc_int = BinaryIntrinsics.int_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_expiration = this.mc_int;
                this.state = 98;
                return true;
            }
            case 100: {
                if (out.add(this.increment(this.mc_header, this.mc_key, -this.mc_delta, this.mc_initial, this.mc_expiration, false))) {
                    this.state = 0;
                    return false;
                }
                this.state = 0;
                return true;
            }
            case 101: {
                int pos = buf.readerIndex();
                this.mc_fixedArray = BinaryIntrinsics.fixedArray(buf, this.mc_keyLength);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_key = this.mc_fixedArray;
                this.state = 100;
                return true;
            }
            case 102: {
                int pos = buf.readerIndex();
                this.mc_long = BinaryIntrinsics.long_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_delta = this.mc_long;
                this.state = 103;
            }
            case 103: {
                int pos = buf.readerIndex();
                this.mc_long = BinaryIntrinsics.long_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_initial = this.mc_long;
                this.state = 104;
            }
            case 104: {
                if (this.mc_extrasLength > 0) {
                    this.state = 106;
                    return true;
                }
                this.mc_expiration = 0;
                this.state = 105;
            }
            case 105: {
                if (this.mc_keyLength > 0) {
                    this.state = 108;
                    return true;
                }
                this.mc_key = Util.EMPTY_BYTE_ARRAY;
                this.state = 107;
                return true;
            }
            case 106: {
                int pos = buf.readerIndex();
                this.mc_int = BinaryIntrinsics.int_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_expiration = this.mc_int;
                this.state = 105;
                return true;
            }
            case 107: {
                if (out.add(this.increment(this.mc_header, this.mc_key, -this.mc_delta, this.mc_initial, this.mc_expiration, true))) {
                    this.state = 0;
                    return false;
                }
                this.state = 0;
                return true;
            }
            case 108: {
                int pos = buf.readerIndex();
                this.mc_fixedArray = BinaryIntrinsics.fixedArray(buf, this.mc_keyLength);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_key = this.mc_fixedArray;
                this.state = 107;
                return true;
            }
            case 109: {
                if (out.add(this.quit(this.mc_header, false))) {
                    this.state = 0;
                    return false;
                }
                this.state = 0;
                return true;
            }
            case 110: {
                this.quit(this.mc_header, true);
                this.state = 0;
                return true;
            }
            case 111: {
                if (this.mc_extrasLength > 0) {
                    this.state = 113;
                    return true;
                }
                this.mc_expiration = 0;
                this.state = 112;
            }
            case 112: {
                if (out.add(this.flush(this.mc_header, this.mc_expiration, false))) {
                    this.state = 0;
                    return false;
                }
                this.state = 0;
                return true;
            }
            case 113: {
                int pos = buf.readerIndex();
                this.mc_int = BinaryIntrinsics.int_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_expiration = this.mc_int;
                this.state = 112;
                return true;
            }
            case 114: {
                if (this.mc_extrasLength > 0) {
                    this.state = 116;
                    return true;
                }
                this.mc_expiration = 0;
                this.state = 115;
            }
            case 115: {
                this.flush(this.mc_header, this.mc_expiration, true);
                this.state = 0;
                return true;
            }
            case 116: {
                int pos = buf.readerIndex();
                this.mc_int = BinaryIntrinsics.int_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_expiration = this.mc_int;
                this.state = 115;
                return true;
            }
            case 117: {
                if (out.add(this.noop(this.mc_header))) {
                    this.state = 0;
                    return false;
                }
                this.state = 0;
                return true;
            }
            case 118: {
                if (out.add(this.version(this.mc_header))) {
                    this.state = 0;
                    return false;
                }
                this.state = 0;
                return true;
            }
            case 119: {
                if (this.mc_keyLength > 0) {
                    this.state = 121;
                    return true;
                }
                this.mc_key = Util.EMPTY_BYTE_ARRAY;
                this.state = 120;
            }
            case 120: {
                if (this.mc_valueLength > 0) {
                    this.state = 123;
                    return true;
                }
                this.mc_value = Util.EMPTY_BYTE_ARRAY;
                this.state = 122;
                return true;
            }
            case 121: {
                int pos = buf.readerIndex();
                this.mc_fixedArray = BinaryIntrinsics.fixedArray(buf, this.mc_keyLength);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_key = this.mc_fixedArray;
                this.state = 120;
                return true;
            }
            case 122: {
                if (out.add(this.append(this.mc_header, this.mc_key, this.mc_value, false))) {
                    this.state = 0;
                    return false;
                }
                this.state = 0;
                return true;
            }
            case 123: {
                int pos = buf.readerIndex();
                this.mc_fixedArray = BinaryIntrinsics.fixedArray(buf, this.mc_valueLength);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_value = this.mc_fixedArray;
                this.state = 122;
                return true;
            }
            case 124: {
                if (this.mc_keyLength > 0) {
                    this.state = 126;
                    return true;
                }
                this.mc_key = Util.EMPTY_BYTE_ARRAY;
                this.state = 125;
            }
            case 125: {
                if (this.mc_valueLength > 0) {
                    this.state = 128;
                    return true;
                }
                this.mc_value = Util.EMPTY_BYTE_ARRAY;
                this.state = 127;
                return true;
            }
            case 126: {
                int pos = buf.readerIndex();
                this.mc_fixedArray = BinaryIntrinsics.fixedArray(buf, this.mc_keyLength);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_key = this.mc_fixedArray;
                this.state = 125;
                return true;
            }
            case 127: {
                if (out.add(this.append(this.mc_header, this.mc_key, this.mc_value, true))) {
                    this.state = 0;
                    return false;
                }
                this.state = 0;
                return true;
            }
        }
        return true;
    }

    private boolean switch2(ByteBuf buf, List<Object> out) throws Exception {
        switch (this.state) {
            case 128: {
                int pos = buf.readerIndex();
                this.mc_fixedArray = BinaryIntrinsics.fixedArray(buf, this.mc_valueLength);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_value = this.mc_fixedArray;
                this.state = 127;
                return true;
            }
            case 129: {
                if (this.mc_keyLength > 0) {
                    this.state = 131;
                    return true;
                }
                this.mc_key = Util.EMPTY_BYTE_ARRAY;
                this.state = 130;
            }
            case 130: {
                if (this.mc_valueLength > 0) {
                    this.state = 133;
                    return true;
                }
                this.mc_value = Util.EMPTY_BYTE_ARRAY;
                this.state = 132;
                return true;
            }
            case 131: {
                int pos = buf.readerIndex();
                this.mc_fixedArray = BinaryIntrinsics.fixedArray(buf, this.mc_keyLength);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_key = this.mc_fixedArray;
                this.state = 130;
                return true;
            }
            case 132: {
                if (out.add(this.prepend(this.mc_header, this.mc_key, this.mc_value, false))) {
                    this.state = 0;
                    return false;
                }
                this.state = 0;
                return true;
            }
            case 133: {
                int pos = buf.readerIndex();
                this.mc_fixedArray = BinaryIntrinsics.fixedArray(buf, this.mc_valueLength);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_value = this.mc_fixedArray;
                this.state = 132;
                return true;
            }
            case 134: {
                if (this.mc_keyLength > 0) {
                    this.state = 136;
                    return true;
                }
                this.mc_key = Util.EMPTY_BYTE_ARRAY;
                this.state = 135;
            }
            case 135: {
                if (this.mc_valueLength > 0) {
                    this.state = 138;
                    return true;
                }
                this.mc_value = Util.EMPTY_BYTE_ARRAY;
                this.state = 137;
                return true;
            }
            case 136: {
                int pos = buf.readerIndex();
                this.mc_fixedArray = BinaryIntrinsics.fixedArray(buf, this.mc_keyLength);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_key = this.mc_fixedArray;
                this.state = 135;
                return true;
            }
            case 137: {
                if (out.add(this.prepend(this.mc_header, this.mc_key, this.mc_value, true))) {
                    this.state = 0;
                    return false;
                }
                this.state = 0;
                return true;
            }
            case 138: {
                int pos = buf.readerIndex();
                this.mc_fixedArray = BinaryIntrinsics.fixedArray(buf, this.mc_valueLength);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_value = this.mc_fixedArray;
                this.state = 137;
                return true;
            }
            case 139: {
                int pos = buf.readerIndex();
                this.mc_int = BinaryIntrinsics.int_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_verbosity = this.mc_int;
                this.state = 140;
            }
            case 140: {
                if (out.add(this.verbosityLevel(this.mc_header, this.mc_verbosity))) {
                    this.state = 0;
                    return false;
                }
                this.state = 0;
                return true;
            }
            case 141: {
                if (this.mc_extrasLength > 0) {
                    this.state = 143;
                    return true;
                }
                this.mc_expiration = 0;
                this.state = 142;
            }
            case 142: {
                if (this.mc_keyLength > 0) {
                    this.state = 145;
                    return true;
                }
                this.mc_key = Util.EMPTY_BYTE_ARRAY;
                this.state = 144;
                return true;
            }
            case 143: {
                int pos = buf.readerIndex();
                this.mc_int = BinaryIntrinsics.int_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_expiration = this.mc_int;
                this.state = 142;
                return true;
            }
            case 144: {
                if (out.add(this.touch(this.mc_header, this.mc_key, this.mc_expiration))) {
                    this.state = 0;
                    return false;
                }
                this.state = 0;
                return true;
            }
            case 145: {
                int pos = buf.readerIndex();
                this.mc_fixedArray = BinaryIntrinsics.fixedArray(buf, this.mc_keyLength);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_key = this.mc_fixedArray;
                this.state = 144;
                return true;
            }
            case 146: {
                if (this.mc_extrasLength > 0) {
                    this.state = 148;
                    return true;
                }
                this.mc_expiration = 0;
                this.state = 147;
            }
            case 147: {
                if (this.mc_keyLength > 0) {
                    this.state = 150;
                    return true;
                }
                this.mc_key = Util.EMPTY_BYTE_ARRAY;
                this.state = 149;
                return true;
            }
            case 148: {
                int pos = buf.readerIndex();
                this.mc_int = BinaryIntrinsics.int_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_expiration = this.mc_int;
                this.state = 147;
                return true;
            }
            case 149: {
                if (out.add(this.gat(this.mc_header, this.mc_key, this.mc_expiration, false))) {
                    this.state = 0;
                    return false;
                }
                this.state = 0;
                return true;
            }
            case 150: {
                int pos = buf.readerIndex();
                this.mc_fixedArray = BinaryIntrinsics.fixedArray(buf, this.mc_keyLength);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_key = this.mc_fixedArray;
                this.state = 149;
                return true;
            }
            case 151: {
                if (this.mc_extrasLength > 0) {
                    this.state = 153;
                    return true;
                }
                this.mc_expiration = 0;
                this.state = 152;
            }
            case 152: {
                if (this.mc_keyLength > 0) {
                    this.state = 155;
                    return true;
                }
                this.mc_key = Util.EMPTY_BYTE_ARRAY;
                this.state = 154;
                return true;
            }
            case 153: {
                int pos = buf.readerIndex();
                this.mc_int = BinaryIntrinsics.int_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_expiration = this.mc_int;
                this.state = 152;
                return true;
            }
            case 154: {
                if (out.add(this.gat(this.mc_header, this.mc_key, this.mc_expiration, true))) {
                    this.state = 0;
                    return false;
                }
                this.state = 0;
                return true;
            }
            case 155: {
                int pos = buf.readerIndex();
                this.mc_fixedArray = BinaryIntrinsics.fixedArray(buf, this.mc_keyLength);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_key = this.mc_fixedArray;
                this.state = 154;
                return true;
            }
            case 156: {
                if (this.mc_extrasLength > 0) {
                    this.state = 158;
                    return true;
                }
                this.mc_expiration = 0;
                this.state = 157;
            }
            case 157: {
                if (this.mc_keyLength > 0) {
                    this.state = 160;
                    return true;
                }
                this.mc_key = Util.EMPTY_BYTE_ARRAY;
                this.state = 159;
                return true;
            }
            case 158: {
                int pos = buf.readerIndex();
                this.mc_int = BinaryIntrinsics.int_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_expiration = this.mc_int;
                this.state = 157;
                return true;
            }
            case 159: {
                if (out.add(this.gat(this.mc_header, this.mc_key, this.mc_expiration, false))) {
                    this.state = 0;
                    return false;
                }
                this.state = 0;
                return true;
            }
            case 160: {
                int pos = buf.readerIndex();
                this.mc_fixedArray = BinaryIntrinsics.fixedArray(buf, this.mc_keyLength);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_key = this.mc_fixedArray;
                this.state = 159;
                return true;
            }
            case 161: {
                if (this.mc_extrasLength > 0) {
                    this.state = 163;
                    return true;
                }
                this.mc_expiration = 0;
                this.state = 162;
            }
            case 162: {
                if (this.mc_keyLength > 0) {
                    this.state = 165;
                    return true;
                }
                this.mc_key = Util.EMPTY_BYTE_ARRAY;
                this.state = 164;
                return true;
            }
            case 163: {
                int pos = buf.readerIndex();
                this.mc_int = BinaryIntrinsics.int_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_expiration = this.mc_int;
                this.state = 162;
                return true;
            }
            case 164: {
                if (out.add(this.gat(this.mc_header, this.mc_key, this.mc_expiration, true))) {
                    this.state = 0;
                    return false;
                }
                this.state = 0;
                return true;
            }
            case 165: {
                int pos = buf.readerIndex();
                this.mc_fixedArray = BinaryIntrinsics.fixedArray(buf, this.mc_keyLength);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_key = this.mc_fixedArray;
                this.state = 164;
                return true;
            }
            case 166: {
                if (this.mc_keyLength > 0) {
                    this.state = 168;
                    return true;
                }
                this.mc_key = Util.EMPTY_BYTE_ARRAY;
                this.state = 167;
            }
            case 167: {
                if (out.add(this.stat(this.mc_header, this.mc_key))) {
                    this.state = 0;
                    return false;
                }
                this.state = 0;
                return true;
            }
            case 168: {
                int pos = buf.readerIndex();
                this.mc_fixedArray = BinaryIntrinsics.fixedArray(buf, this.mc_keyLength);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_key = this.mc_fixedArray;
                this.state = 167;
                return true;
            }
            case 169: {
                if (this.mc_keyLength > 0) {
                    this.state = 171;
                    return true;
                }
                this.mc_key = Util.EMPTY_BYTE_ARRAY;
                this.state = 170;
            }
            case 170: {
                if (out.add(this.config(this.mc_header, this.mc_key))) {
                    this.state = 0;
                    return false;
                }
                this.state = 0;
                return true;
            }
            case 171: {
                int pos = buf.readerIndex();
                this.mc_fixedArray = BinaryIntrinsics.fixedArray(buf, this.mc_keyLength);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_key = this.mc_fixedArray;
                this.state = 170;
                return true;
            }
        }
        return true;
    }

    private void deadEnd() {
        if (!this.deadEnd) {
            log.tracef("Invalid state of parsing", new Object[0]);
            this.exceptionCaught(this.mc_header, new IllegalStateException("Dead end processing request"));
            this.deadEnd = true;
        }
        this.state = 0;
    }

    private void exceptionally(Throwable t) throws Exception {
        log.trace("Parsing error", t);
        this.state = 0;
        this.exceptionCaught(this.mc_header, t);
    }

    private void reset() {
        this.requestBytes = 0;
        this.mc_long = 0L;
        this.mc_dataType = 0;
        this.mc_vbucketId = 0;
        this.mc_opaque = 0;
        this.mc_op = null;
        this.mc_totalBodyLength = 0;
        this.mc_int = 0;
        this.mc_verbosity = 0;
        this.mc_expiration = 0;
        this.mc_header = null;
        this.mc_flags = 0;
        this.mc_cas = 0L;
        this.mc_opCode = null;
        this.mc_fixedArray = null;
        this.mc_byte = 0;
        this.mc_initial = 0L;
        this.mc_key = null;
        this.mc_magic = 0;
        this.mc_keyLength = 0;
        this.mc_delta = 0L;
        this.mc_value = null;
        this.mc_short = 0;
        this.mc_valueLength = 0;
        this.mc_extrasLength = 0;
    }

    public int requestBytes() {
        return this.requestBytes;
    }

    private boolean userSwitch14() throws Exception {
        switch (this.mc_op) {
            case GET: {
                this.state = 15;
                return true;
            }
            case GETQ: {
                this.state = 18;
                return true;
            }
            case GETK: {
                this.state = 21;
                return true;
            }
            case GETKQ: {
                this.state = 24;
                return true;
            }
            case SET: {
                this.state = 27;
                return true;
            }
            case SETQ: {
                this.state = 35;
                return true;
            }
            case ADD: {
                this.state = 43;
                return true;
            }
            case ADDQ: {
                this.state = 51;
                return true;
            }
            case REPLACE: {
                this.state = 59;
                return true;
            }
            case REPLACEQ: {
                this.state = 67;
                return true;
            }
            case DELETE: {
                this.state = 75;
                return true;
            }
            case DELETEQ: {
                this.state = 78;
                return true;
            }
            case INCREMENT: {
                this.state = 81;
                return true;
            }
            case INCREMENTQ: {
                this.state = 88;
                return true;
            }
            case DECREMENT: {
                this.state = 95;
                return true;
            }
            case DECREMENTQ: {
                this.state = 102;
                return true;
            }
            case QUIT: {
                this.state = 109;
                return true;
            }
            case QUITQ: {
                this.state = 110;
                return true;
            }
            case FLUSH: {
                this.state = 111;
                return true;
            }
            case FLUSHQ: {
                this.state = 114;
                return true;
            }
            case NO_OP: {
                this.state = 117;
                return true;
            }
            case VERSION: {
                this.state = 118;
                return true;
            }
            case APPEND: {
                this.state = 119;
                return true;
            }
            case APPENDQ: {
                this.state = 124;
                return true;
            }
            case PREPEND: {
                this.state = 129;
                return true;
            }
            case PREPENDQ: {
                this.state = 134;
                return true;
            }
            case VERBOSITY: {
                this.state = 139;
                return true;
            }
            case TOUCH: {
                this.state = 141;
                return true;
            }
            case GAT: {
                this.state = 146;
                return true;
            }
            case GATQ: {
                this.state = 151;
                return true;
            }
            case GATK: {
                this.state = 156;
                return true;
            }
            case GATKQ: {
                this.state = 161;
                return true;
            }
            case STAT: {
                this.state = 166;
                return true;
            }
            case CONFIG_GET: {
                this.state = 169;
                return true;
            }
        }
        throw new IllegalArgumentException("Unknown operation " + String.valueOf((Object)this.mc_op));
    }
}

