/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.internal.reveng.reader;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.hibernate.JDBCException;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.PrimaryKey;
import org.hibernate.mapping.Table;
import org.hibernate.sql.Alias;
import org.hibernate.tool.api.reveng.RevengDialect;
import org.hibernate.tool.api.reveng.RevengStrategy;
import org.hibernate.tool.internal.reveng.RevengMetadataCollector;
import org.hibernate.tool.internal.reveng.util.RevengUtils;
import org.jboss.logging.Logger;

public class PrimaryKeyProcessor {
    private static final Logger log = Logger.getLogger(PrimaryKeyProcessor.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void processPrimaryKey(RevengDialect metaDataDialect, RevengStrategy revengStrategy, String defaultSchema, String defaultCatalog, RevengMetadataCollector revengMetadataCollector, Table table) {
        ArrayList<Object[]> columns = new ArrayList<Object[]>();
        PrimaryKey key = null;
        Iterator<Map<String, Object>> primaryKeyIterator = null;
        try {
            Map<String, Object> primaryKeyRs = null;
            primaryKeyIterator = metaDataDialect.getPrimaryKeys(PrimaryKeyProcessor.getCatalogForDBLookup(table.getCatalog(), defaultCatalog), PrimaryKeyProcessor.getSchemaForDBLookup(table.getSchema(), defaultSchema), table.getName());
            while (primaryKeyIterator.hasNext()) {
                primaryKeyRs = primaryKeyIterator.next();
                String columnName = (String)primaryKeyRs.get("COLUMN_NAME");
                short seq = (Short)primaryKeyRs.get("KEY_SEQ");
                String name = (String)primaryKeyRs.get("PK_NAME");
                if (key == null) {
                    key = new PrimaryKey(table);
                    key.setName(name);
                    key.setTable(table);
                    if (table.getPrimaryKey() != null) {
                        throw new RuntimeException(table + " already has a primary key!");
                    }
                    table.setPrimaryKey(key);
                } else if (name != key.getName() && name != null && !name.equals(key.getName())) {
                    throw new RuntimeException("Duplicate names found for primarykey. Existing name: " + key.getName() + " JDBC name: " + name + " on table " + table);
                }
                columns.add(new Object[]{seq, columnName});
            }
        }
        finally {
            if (primaryKeyIterator != null) {
                try {
                    metaDataDialect.close(primaryKeyIterator);
                }
                catch (JDBCException se) {
                    log.warn((Object)"Exception when closing resultset for reading primary key information", (Throwable)se);
                }
            }
        }
        Collections.sort(columns, new Comparator<Object[]>(){

            @Override
            public int compare(Object[] o1, Object[] o2) {
                Short left = (Short)o1[0];
                Short right = (Short)o2[0];
                return left.compareTo(right);
            }
        });
        ArrayList<String> t = new ArrayList<String>(columns.size());
        for (Object[] element : columns) {
            t.add((String)element[1]);
        }
        if (key == null) {
            log.warn((Object)("The JDBC driver didn't report any primary key columns in " + table.getName() + ". Asking rev.eng. strategy"));
            List<String> userPrimaryKey = RevengUtils.getPrimaryKeyInfoInRevengStrategy(revengStrategy, table, defaultCatalog, defaultSchema);
            if (userPrimaryKey != null && !userPrimaryKey.isEmpty()) {
                key = new PrimaryKey(table);
                key.setName(new Alias(15, "PK").toAliasString(table.getName()));
                key.setTable(table);
                if (table.getPrimaryKey() != null) {
                    throw new RuntimeException(table + " already has a primary key!");
                }
                table.setPrimaryKey(key);
                t = new ArrayList<String>(userPrimaryKey);
            } else {
                log.warn((Object)("Rev.eng. strategy did not report any primary key columns for " + table.getName()));
            }
        }
        Iterator<Map<String, Object>> suggestedPrimaryKeyStrategyName = metaDataDialect.getSuggestedPrimaryKeyStrategyName(PrimaryKeyProcessor.getCatalogForDBLookup(table.getCatalog(), defaultCatalog), PrimaryKeyProcessor.getSchemaForDBLookup(table.getSchema(), defaultSchema), table.getName());
        try {
            Map<String, Object> m;
            String suggestion;
            if (suggestedPrimaryKeyStrategyName.hasNext() && (suggestion = (String)(m = suggestedPrimaryKeyStrategyName.next()).get("HIBERNATE_STRATEGY")) != null) {
                revengMetadataCollector.addSuggestedIdentifierStrategy(PrimaryKeyProcessor.transformForModelLookup(table.getCatalog(), defaultCatalog), PrimaryKeyProcessor.transformForModelLookup(table.getSchema(), defaultSchema), table.getName(), suggestion);
            }
        }
        finally {
            if (suggestedPrimaryKeyStrategyName != null) {
                try {
                    metaDataDialect.close(suggestedPrimaryKeyStrategyName);
                }
                catch (JDBCException se) {
                    log.warn((Object)"Exception while closing iterator for suggested primary key strategy name", (Throwable)se);
                }
            }
        }
        if (key != null) {
            for (String name : t) {
                Column col = PrimaryKeyProcessor.getColumn(metaDataDialect, table, name);
                key.addColumn(col);
            }
            log.debug((Object)("primary key for " + table + " -> " + key));
        }
    }

    private static String getCatalogForDBLookup(String catalog, String defaultCatalog) {
        return catalog == null ? defaultCatalog : catalog;
    }

    private static String transformForModelLookup(String id, String defaultId) {
        return id == null || id.equals(defaultId) ? null : id;
    }

    private static String getSchemaForDBLookup(String schema, String defaultSchema) {
        return schema == null ? defaultSchema : schema;
    }

    private static Column getColumn(RevengDialect metaDataDialect, Table table, String columnName) {
        Column column = new Column();
        column.setName(PrimaryKeyProcessor.quote(metaDataDialect, columnName));
        Column existing = table.getColumn(column);
        if (existing != null) {
            column = existing;
        }
        return column;
    }

    private static String quote(RevengDialect metaDataDialect, String columnName) {
        if (columnName == null) {
            return columnName;
        }
        if (metaDataDialect.needQuote(columnName)) {
            if (columnName.length() > 1 && columnName.charAt(0) == '`' && columnName.charAt(columnName.length() - 1) == '`') {
                return columnName;
            }
            return "`" + columnName + "`";
        }
        return columnName;
    }
}

