/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.loading.impl;

import java.lang.invoke.MethodHandles;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.search.mapper.orm.loading.impl.AbstractHibernateOrmLoadingStrategy;
import org.hibernate.search.mapper.orm.loading.impl.HibernateOrmEntityLoadingStrategy;
import org.hibernate.search.mapper.orm.loading.impl.HibernateOrmSelectionEntityByNonIdPropertyLoader;
import org.hibernate.search.mapper.orm.loading.impl.LoadingSessionContext;
import org.hibernate.search.mapper.orm.loading.impl.LoadingTypeContext;
import org.hibernate.search.mapper.orm.loading.impl.MutableEntityLoadingOptions;
import org.hibernate.search.mapper.orm.loading.impl.TypeQueryFactory;
import org.hibernate.search.mapper.orm.logging.impl.Log;
import org.hibernate.search.mapper.orm.search.loading.EntityLoadingCacheLookupStrategy;
import org.hibernate.search.mapper.pojo.loading.spi.PojoSelectionEntityLoader;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reflect.spi.ValueReadHandle;

public class HibernateOrmNonEntityIdPropertyEntityLoadingStrategy<E, I>
extends AbstractHibernateOrmLoadingStrategy<E, I> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final EntityPersister entityPersister;
    private final TypeQueryFactory<E, I> queryFactory;
    private final String documentIdSourcePropertyName;
    private final ValueReadHandle<?> documentIdSourceHandle;

    public static <I> HibernateOrmEntityLoadingStrategy<?, ?> create(SessionFactoryImplementor sessionFactory, EntityPersister entityPersister, String documentIdSourcePropertyName, ValueReadHandle<I> documentIdSourceHandle) {
        TypeQueryFactory<?, ?> queryFactory = TypeQueryFactory.create(sessionFactory, entityPersister, documentIdSourcePropertyName);
        return new HibernateOrmNonEntityIdPropertyEntityLoadingStrategy(sessionFactory, entityPersister, queryFactory, documentIdSourcePropertyName, documentIdSourceHandle);
    }

    private HibernateOrmNonEntityIdPropertyEntityLoadingStrategy(SessionFactoryImplementor sessionFactory, EntityPersister entityPersister, TypeQueryFactory<E, I> queryFactory, String documentIdSourcePropertyName, ValueReadHandle<I> documentIdSourceHandle) {
        super(sessionFactory, entityPersister, queryFactory);
        this.entityPersister = entityPersister;
        this.queryFactory = queryFactory;
        this.documentIdSourcePropertyName = documentIdSourcePropertyName;
        this.documentIdSourceHandle = documentIdSourceHandle;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        HibernateOrmNonEntityIdPropertyEntityLoadingStrategy other = (HibernateOrmNonEntityIdPropertyEntityLoadingStrategy)obj;
        return this.entityPersister.equals(other.entityPersister) && this.documentIdSourcePropertyName.equals(other.documentIdSourcePropertyName) && this.documentIdSourceHandle.equals(other.documentIdSourceHandle);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.entityPersister, this.documentIdSourcePropertyName, this.documentIdSourceHandle);
    }

    @Override
    public <E2> PojoSelectionEntityLoader<E2> createLoader(Set<LoadingTypeContext<? extends E2>> targetEntityTypeContexts, LoadingSessionContext sessionContext, EntityLoadingCacheLookupStrategy cacheLookupStrategy, MutableEntityLoadingOptions loadingOptions) {
        if (targetEntityTypeContexts.size() != 1) {
            throw this.multipleTypesException(targetEntityTypeContexts);
        }
        return this.doCreate(targetEntityTypeContexts.iterator().next(), sessionContext, cacheLookupStrategy, loadingOptions);
    }

    private <E2> PojoSelectionEntityLoader<E2> doCreate(LoadingTypeContext<?> targetEntityTypeContext, LoadingSessionContext sessionContext, EntityLoadingCacheLookupStrategy cacheLookupStrategy, MutableEntityLoadingOptions loadingOptions) {
        if (!this.entityPersister.equals(targetEntityTypeContext.entityPersister())) {
            throw this.invalidTypeException(targetEntityTypeContext.entityPersister());
        }
        HibernateOrmSelectionEntityByNonIdPropertyLoader result = new HibernateOrmSelectionEntityByNonIdPropertyLoader(this.entityPersister, targetEntityTypeContext, this.queryFactory, this.documentIdSourcePropertyName, this.documentIdSourceHandle, sessionContext, loadingOptions);
        if (!EntityLoadingCacheLookupStrategy.SKIP.equals((Object)cacheLookupStrategy)) {
            log.skippingPreliminaryCacheLookupsForNonEntityIdEntityLoader(targetEntityTypeContext.jpaEntityName(), cacheLookupStrategy);
        }
        return result;
    }

    private AssertionFailure invalidTypeException(EntityPersister otherEntityPersister) {
        throw new AssertionFailure("Attempt to use a criteria-based entity loader with an unexpected target entity type. Expected entity name: " + this.entityPersister.getEntityName() + " Targeted entity name: " + otherEntityPersister);
    }

    private AssertionFailure multipleTypesException(Set<? extends LoadingTypeContext<?>> targetEntityTypeContexts) {
        return new AssertionFailure("Attempt to use a criteria-based entity loader with multiple target entity types. Expected entity name: " + this.entityPersister.getEntityName() + " Targeted entity names: " + targetEntityTypeContexts.stream().map(LoadingTypeContext::entityPersister).map(EntityPersister::getEntityName).collect(Collectors.toList()));
    }
}

