/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.hbmlint;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.cfg.Configuration;
import org.hibernate.tool.hbmlint.Detector;
import org.hibernate.tool.hbmlint.Issue;
import org.hibernate.tool.hbmlint.IssueCollector;
import org.hibernate.tool.hbmlint.detector.BadCachingDetector;
import org.hibernate.tool.hbmlint.detector.InstrumentationDetector;
import org.hibernate.tool.hbmlint.detector.SchemaByMetaDataDetector;
import org.hibernate.tool.hbmlint.detector.ShadowedIdentifierDetector;

public class HbmLint
implements IssueCollector {
    final Detector[] detectors;
    List<Issue> results = new ArrayList<Issue>();

    public HbmLint(Detector[] detectors) {
        this.detectors = detectors;
    }

    public void analyze(Configuration cfg) {
        for (int i = 0; i < this.detectors.length; ++i) {
            this.detectors[i].initialize(cfg);
            this.detectors[i].visit(cfg, this);
        }
    }

    @Override
    public void reportIssue(Issue analyze) {
        this.results.add(analyze);
    }

    public List<Issue> getResults() {
        return this.results;
    }

    public static HbmLint createInstance() {
        return new HbmLint(new Detector[]{new BadCachingDetector(), new InstrumentationDetector(), new ShadowedIdentifierDetector(), new SchemaByMetaDataDetector()});
    }
}

