/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg.reveng;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.hibernate.cfg.reveng.AbstractDatabaseCollector;
import org.hibernate.cfg.reveng.dialect.MetaDataDialect;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.Table;

public class DefaultDatabaseCollector
extends AbstractDatabaseCollector {
    private Map<String, Table> tables = new HashMap<String, Table>();
    private Map<String, List<Table>> qualifiers = new HashMap<String, List<Table>>();

    public DefaultDatabaseCollector(MetaDataDialect metaDataDialect) {
        super(metaDataDialect);
    }

    @Override
    public Iterator<Table> iterateTables() {
        return this.tables.values().iterator();
    }

    @Override
    public Table addTable(String schema, String catalog, String name) {
        String key = Table.qualify((String)this.quote(catalog), (String)this.quote(schema), (String)this.quote(name));
        Table table = this.tables.get(key);
        if (table == null) {
            table = new Table();
            table.setAbstract(false);
            table.setName(name);
            table.setSchema(schema);
            table.setCatalog(catalog);
            this.tables.put(key, table);
            String qualifier = StringHelper.qualifier((String)key);
            List<Table> schemaList = this.qualifiers.get(qualifier);
            if (schemaList == null) {
                schemaList = new ArrayList<Table>();
                this.qualifiers.put(qualifier, schemaList);
            }
            schemaList.add(table);
        } else {
            table.setAbstract(false);
        }
        return table;
    }

    @Override
    public Table getTable(String schema, String catalog, String name) {
        String key = Table.qualify((String)this.quote(catalog), (String)this.quote(schema), (String)this.quote(name));
        return this.tables.get(key);
    }

    public Iterator<Map.Entry<String, List<Table>>> getQualifierEntries() {
        return this.qualifiers.entrySet().iterator();
    }
}

