/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.dsl.impl;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.hibernate.annotations.common.AssertionFailure;
import org.hibernate.search.SearchException;
import org.hibernate.search.engine.spi.DocumentBuilderIndexedEntity;
import org.hibernate.search.engine.spi.EntityIndexBinder;
import org.hibernate.search.engine.spi.SearchFactoryImplementor;
import org.hibernate.search.query.dsl.impl.FieldContext;
import org.hibernate.search.query.dsl.impl.QueryBuildingContext;

class Helper {
    Helper() {
    }

    static String getAnalyzedTerm(String fieldName, String value, String name, Analyzer queryAnalyzer, FieldContext fieldContext) {
        if (fieldContext.isIgnoreAnalyzer()) {
            return value;
        }
        try {
            List<String> termsFromText = Helper.getAllTermsFromText(fieldName, value.toString(), queryAnalyzer);
            if (termsFromText.size() > 1) {
                StringBuilder error = new StringBuilder("The ").append(name).append(" parameter leads to several terms when analyzed: ");
                for (String term : termsFromText) {
                    error.append(term).append(", ");
                }
                int length = error.length();
                throw new SearchException(error.delete(length - 1, length).toString());
            }
            return termsFromText.size() == 0 ? null : termsFromText.get(0);
        }
        catch (IOException e) {
            throw new AssertionFailure("IO exception while reading String stream??", (Throwable)e);
        }
    }

    static List<String> getAllTermsFromText(String fieldName, String localText, Analyzer analyzer) throws IOException {
        ArrayList<String> terms = new ArrayList<String>();
        if (localText == null) {
            throw new SearchException("Search parameter on field " + fieldName + " could not be converted. " + "Are the parameter and the field of the same type?" + "Alternatively, apply the ignoreFieldBridge() option to " + "pass String parameters");
        }
        StringReader reader = new StringReader(localText);
        TokenStream stream = analyzer.reusableTokenStream(fieldName, (Reader)reader);
        CharTermAttribute attribute = (CharTermAttribute)stream.addAttribute(CharTermAttribute.class);
        stream.reset();
        while (stream.incrementToken()) {
            if (attribute.length() <= 0) continue;
            String term = new String(attribute.buffer(), 0, attribute.length());
            terms.add(term);
        }
        stream.end();
        stream.close();
        return terms;
    }

    static DocumentBuilderIndexedEntity<?> getDocumentBuilder(QueryBuildingContext queryContext) {
        Class<?> type;
        SearchFactoryImplementor factory = queryContext.getFactory();
        EntityIndexBinder indexBinding = factory.getIndexBindingForEntity(type = queryContext.getEntityType());
        if (indexBinding == null) {
            throw new AssertionFailure("Class in not indexed: " + type);
        }
        return indexBinding.getDocumentBuilder();
    }
}

