/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.reports;

import com.oracle.graal.pointsto.api.PointstoOptions;
import org.graalvm.collections.EconomicMap;
import org.graalvm.compiler.options.EnumOptionKey;
import org.graalvm.compiler.options.Option;
import org.graalvm.compiler.options.OptionKey;

public class AnalysisReportsOptions {
    @Option(help={"Print analysis results statistics."})
    public static final OptionKey<Boolean> PrintAnalysisStatistics = new OptionKey((Object)false);
    @Option(help={"Analysis results statistics file."})
    public static final OptionKey<String> AnalysisStatisticsFile = new OptionKey(null);
    @Option(help={"Print analysis call tree, a breadth-first tree reduction of the call graph."})
    public static final OptionKey<Boolean> PrintAnalysisCallTree = new OptionKey((Object)false);
    @Option(help={"Print call edges with other analysis results statistics."})
    public static final OptionKey<Boolean> PrintCallEdges = new OptionKey<Boolean>(Boolean.valueOf(false)){

        protected void onValueUpdate(EconomicMap<OptionKey<?>, Object> values, Boolean oldValue, Boolean newValue) {
            if (newValue.booleanValue()) {
                PrintAnalysisStatistics.update(values, (Object)true);
                PointstoOptions.TrackAccessChain.update(values, (Object)true);
            }
        }
    };
    @Option(help={"Change the output format of the analysis call tree, available options are TXT and CSV. See: Reports.md."})
    public static final EnumOptionKey<CallTreeType> PrintAnalysisCallTreeType = new EnumOptionKey<CallTreeType>(CallTreeType.TXT){

        protected void onValueUpdate(EconomicMap<OptionKey<?>, Object> values, CallTreeType oldValue, CallTreeType newValue) {
            super.onValueUpdate(values, (Enum)oldValue, (Enum)newValue);
            PrintAnalysisCallTree.update(values, (Object)true);
        }
    };
    @Option(help={"Print image object hierarchy."})
    public static final OptionKey<Boolean> PrintImageObjectTree = new OptionKey((Object)false);
    @Option(help={"Override the default suppression of specified roots. See: Reports.md."})
    public static final OptionKey<String> ImageObjectTreeExpandRoots = new OptionKey((Object)"");
    @Option(help={"Suppress the expansion of specified roots. See: Reports.md."})
    public static final OptionKey<String> ImageObjectTreeSuppressRoots = new OptionKey((Object)"");
    @Option(help={"Override the default suppression of specified types. See: Reports.md."})
    public static final OptionKey<String> ImageObjectTreeExpandTypes = new OptionKey((Object)"");
    @Option(help={"Suppress the expansion of specified types. See: Reports.md."})
    public static final OptionKey<String> ImageObjectTreeSuppressTypes = new OptionKey((Object)"");

    static enum CallTreeType {
        TXT,
        CSV;

    }
}

