/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2014 Oracle and/or its affiliates. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License.  You can
 * obtain a copy of the License at
 * https://glassfish.dev.java.net/public/CDDL+GPL_1_1.html
 * or packager/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 *
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at packager/legal/LICENSE.txt.
 *
 * GPL Classpath Exception:
 * Oracle designates this particular file as subject to the "Classpath"
 * exception as provided by Oracle in the GPL Version 2 section of the License
 * file that accompanied this code.
 *
 * Modifications:
 * If applicable, add the following below the License Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyright [year] [name of copyright owner]"
 *
 * Contributor(s):
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */
package org.glassfish.hk2.utilities;

import java.util.ArrayList;

import org.glassfish.hk2.api.Descriptor;
import org.glassfish.hk2.api.Filter;
import org.glassfish.hk2.api.IndexedFilter;
import org.glassfish.hk2.utilities.general.GeneralUtilities;

/**
 * Creates a filter that matches if at least one
 * of the sub-filters is a match.  Respects the
 * rules of {@link IndexedFilter} as well
 * 
 * @author jwells
 *
 */
public class OrFilter implements Filter {
    private final ArrayList<Filter> allFilters;
    
    /**
     * Creates an OrFilter whose matches methods returns
     * true if at least one of the filters given returns
     * true.  If filters is zero length then the matches
     * method will always return false because none of
     * the filters returned true!
     * 
     * @param filters other filters to be considered in the
     * Or expression
     */
    public OrFilter(Filter...filters) {
        
        allFilters = new ArrayList<Filter>(filters.length);
        
        for (Filter f : filters) {
            if (f != null) {
                allFilters.add(f);
            }
        }
    }

    /* (non-Javadoc)
     * @see org.glassfish.hk2.api.Filter#matches(org.glassfish.hk2.api.Descriptor)
     */
    @Override
    public boolean matches(Descriptor d) {
        for (Filter filter : allFilters) {
            if (filter instanceof IndexedFilter) {
                IndexedFilter iFilter = (IndexedFilter) filter;
                
                String name = iFilter.getName();
                if (name != null) {
                  if (!GeneralUtilities.safeEquals(name, d.getName())) continue;
                }
                
                String contract = iFilter.getAdvertisedContract();
                if (contract != null) {
                    if (!d.getAdvertisedContracts().contains(contract)) continue;
                }
            }
            
            if (filter.matches(d)) return true;
        }
        
        return false;
    }

}
