/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common.io.payload;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Utf8Appendable;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.api.BadPayloadException;
import org.eclipse.jetty.websocket.api.extensions.Frame;
import org.eclipse.jetty.websocket.common.io.payload.PayloadProcessor;

public class UTF8Validator
extends Utf8Appendable
implements PayloadProcessor {
    private static final Logger LOG = Log.getLogger(UTF8Validator.class);
    private EmptyAppender buffer;

    public UTF8Validator() {
        super(new EmptyAppender());
        this.buffer = (EmptyAppender)this._appendable;
    }

    @Override
    public int length() {
        return this.buffer.getLength();
    }

    @Override
    public void process(ByteBuffer payload) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Payload: {}", BufferUtil.toDetailString(payload));
        }
        if (payload == null || payload.remaining() <= 0) {
            return;
        }
        try {
            this.append(payload.slice());
        }
        catch (Utf8Appendable.NotUtf8Exception e) {
            throw new BadPayloadException(e);
        }
    }

    @Override
    public void reset(Frame frame) {
    }

    private static class EmptyAppender
    implements Appendable {
        private int length = 0;

        private EmptyAppender() {
        }

        @Override
        public Appendable append(char c) throws IOException {
            ++this.length;
            return this;
        }

        @Override
        public Appendable append(CharSequence csq) throws IOException {
            this.length += csq.length();
            return this;
        }

        @Override
        public Appendable append(CharSequence csq, int start, int end) throws IOException {
            this.length += end - start;
            return this;
        }

        public int getLength() {
            return this.length;
        }
    }
}

