/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee10.websocket.jakarta.common.decoders;

import jakarta.websocket.DecodeException;
import jakarta.websocket.Decoder;
import org.eclipse.jetty.ee10.websocket.jakarta.common.decoders.AbstractDecoder;

public class LongDecoder
extends AbstractDecoder
implements Decoder.Text<Long> {
    public static final LongDecoder INSTANCE = new LongDecoder();

    public Long decode(String s) throws DecodeException {
        try {
            return Long.parseLong(s);
        }
        catch (NumberFormatException e) {
            throw new DecodeException(s, "Unable to parse Long", (Throwable)e);
        }
    }

    public boolean willDecode(String s) {
        if (s == null) {
            return false;
        }
        try {
            Long.parseLong(s);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }
}

